/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.deps;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessingData;
import org.gradle.api.internal.tasks.compile.incremental.processing.GeneratedResource;

public class ClassSetAnalysis {
    private final ClassSetAnalysisData classAnalysis;
    private final AnnotationProcessingData annotationProcessingData;
    private final ImmutableSetMultimap<String, String> classDependenciesFromAnnotationProcessing;
    private final ImmutableSetMultimap<String, GeneratedResource> resourceDependenciesFromAnnotationProcessing;

    public ClassSetAnalysis(ClassSetAnalysisData classAnalysis) {
        this(classAnalysis, new AnnotationProcessingData());
    }

    public ClassSetAnalysis(ClassSetAnalysisData classAnalysis, AnnotationProcessingData annotationProcessingData) {
        this.classAnalysis = classAnalysis;
        this.annotationProcessingData = annotationProcessingData;
        ImmutableSetMultimap.Builder classDependenciesFromAnnotationProcessing = ImmutableSetMultimap.builder();
        for (Map.Entry<String, Set<String>> entry : annotationProcessingData.getGeneratedTypesByOrigin().entrySet()) {
            for (String generated : entry.getValue()) {
                String origin = entry.getKey();
                classDependenciesFromAnnotationProcessing.put((Object)origin, (Object)generated);
                classDependenciesFromAnnotationProcessing.put((Object)generated, (Object)origin);
            }
        }
        this.classDependenciesFromAnnotationProcessing = classDependenciesFromAnnotationProcessing.build();
        ImmutableSetMultimap.Builder resourceDependenciesFromAnnotationProcessing = ImmutableSetMultimap.builder();
        for (Map.Entry<String, Set<GeneratedResource>> entry : annotationProcessingData.getGeneratedResourcesByOrigin().entrySet()) {
            for (GeneratedResource generated : entry.getValue()) {
                String origin = entry.getKey();
                resourceDependenciesFromAnnotationProcessing.put((Object)origin, (Object)generated);
            }
        }
        this.resourceDependenciesFromAnnotationProcessing = resourceDependenciesFromAnnotationProcessing.build();
    }

    public ClassSetAnalysis withAnnotationProcessingData(AnnotationProcessingData annotationProcessingData) {
        return new ClassSetAnalysis(this.classAnalysis, annotationProcessingData);
    }

    public DependentsSet getRelevantDependents(Iterable<String> classes, IntSet constants) {
        LinkedHashSet resultClasses = null;
        LinkedHashSet resultResources = null;
        for (String cls : classes) {
            DependentsSet d = this.getRelevantDependents(cls, constants);
            if (d.isDependencyToAll()) {
                return d;
            }
            Set<String> dependentClasses = d.getDependentClasses();
            Set<GeneratedResource> dependentResources = d.getDependentResources();
            if (dependentClasses.isEmpty() && dependentResources.isEmpty()) continue;
            if (resultClasses == null) {
                resultClasses = Sets.newLinkedHashSet();
            }
            resultClasses.addAll(dependentClasses);
            if (resultResources == null) {
                resultResources = Sets.newLinkedHashSet();
            }
            resultResources.addAll(dependentResources);
        }
        return resultClasses == null ? DependentsSet.empty() : DependentsSet.dependents(resultClasses, resultResources);
    }

    public DependentsSet getRelevantDependents(String className, IntSet constants) {
        String fullRebuildCause = this.annotationProcessingData.getFullRebuildCause();
        if (fullRebuildCause != null) {
            return DependentsSet.dependencyToAll(fullRebuildCause);
        }
        DependentsSet deps = this.getDependents(className);
        if (deps.isDependencyToAll()) {
            return deps;
        }
        if (!constants.isEmpty()) {
            return DependentsSet.dependencyToAll();
        }
        Set<String> classesDependingOnAllOthers = this.annotationProcessingData.getGeneratedTypesDependingOnAllOthers();
        Set<GeneratedResource> resourcesDependingOnAllOthers = this.annotationProcessingData.getGeneratedResourcesDependingOnAllOthers();
        if (deps.getDependentClasses().isEmpty() && classesDependingOnAllOthers.isEmpty() && resourcesDependingOnAllOthers.isEmpty()) {
            return deps;
        }
        HashSet<String> resultClasses = new HashSet<String>();
        HashSet<GeneratedResource> resultResources = new HashSet<GeneratedResource>(resourcesDependingOnAllOthers);
        this.recurseDependentClasses(new HashSet<String>(), resultClasses, resultResources, deps.getDependentClasses());
        this.recurseDependentClasses(new HashSet<String>(), resultClasses, resultResources, classesDependingOnAllOthers);
        resultClasses.remove(className);
        return DependentsSet.dependents(resultClasses, resultResources);
    }

    public Set<String> getTypesToReprocess() {
        return this.annotationProcessingData.getAggregatedTypes();
    }

    public boolean isDependencyToAll(String className) {
        return this.classAnalysis.getDependents(className).isDependencyToAll();
    }

    private void recurseDependentClasses(Set<String> visitedClasses, Set<String> resultClasses, Set<GeneratedResource> resultResources, Iterable<String> dependentClasses) {
        for (String d : dependentClasses) {
            DependentsSet currentDependents;
            if (!visitedClasses.add(d)) continue;
            if (!this.isNestedClass(d)) {
                resultClasses.add(d);
            }
            if ((currentDependents = this.getDependents(d)).isDependencyToAll()) continue;
            resultResources.addAll(currentDependents.getDependentResources());
            this.recurseDependentClasses(visitedClasses, resultClasses, resultResources, currentDependents.getDependentClasses());
        }
    }

    private DependentsSet getDependents(String className) {
        DependentsSet dependents = this.classAnalysis.getDependents(className);
        if (dependents.isDependencyToAll()) {
            return dependents;
        }
        ImmutableSet additionalClassDeps = this.classDependenciesFromAnnotationProcessing.get((Object)className);
        ImmutableSet additionalResourceDeps = this.resourceDependenciesFromAnnotationProcessing.get((Object)className);
        if (additionalClassDeps.isEmpty() && additionalResourceDeps.isEmpty()) {
            return dependents;
        }
        return DependentsSet.dependents((Set<String>)Sets.union(dependents.getDependentClasses(), (Set)additionalClassDeps), (Set<GeneratedResource>)Sets.union(dependents.getDependentResources(), (Set)additionalResourceDeps));
    }

    private boolean isNestedClass(String d) {
        return d.contains("$");
    }

    public IntSet getConstants(String className) {
        return this.classAnalysis.getConstants(className);
    }
}

