/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profile;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.gradle.internal.html.SimpleHtmlWriter;
import org.gradle.internal.time.TimeFormatting;
import org.gradle.profile.BuildProfile;
import org.gradle.profile.CompositeOperation;
import org.gradle.profile.Operation;
import org.gradle.profile.ProjectProfile;
import org.gradle.profile.TaskExecution;
import org.gradle.reporting.HtmlReportRenderer;
import org.gradle.reporting.ReportRenderer;
import org.gradle.reporting.TabbedPageRenderer;

public class ProfileReportRenderer {
    public void writeTo(BuildProfile buildProfile, File file) {
        HtmlReportRenderer renderer = new HtmlReportRenderer();
        renderer.renderSinglePage((Object)buildProfile, (ReportRenderer)new ProfilePageRenderer(), file);
    }

    private static class ProfilePageRenderer
    extends TabbedPageRenderer<BuildProfile> {
        private static final URL STYLE_URL = ProfilePageRenderer.class.getResource("style.css");

        private ProfilePageRenderer() {
        }

        protected String getTitle() {
            return "Profile report";
        }

        protected URL getStyleUrl() {
            return STYLE_URL;
        }

        protected ReportRenderer<BuildProfile, SimpleHtmlWriter> getHeaderRenderer() {
            return new ReportRenderer<BuildProfile, SimpleHtmlWriter>(){

                public void render(BuildProfile model, SimpleHtmlWriter htmlWriter) throws IOException {
                    htmlWriter.startElement("div").attribute("id", "header").startElement("p").characters((CharSequence)model.getBuildDescription()).endElement().startElement("p").characters((CharSequence)model.getBuildStartedDescription()).endElement().endElement();
                }
            };
        }

        protected ReportRenderer<BuildProfile, SimpleHtmlWriter> getContentRenderer() {
            return new ReportRenderer<BuildProfile, SimpleHtmlWriter>(){

                public void render(BuildProfile model, SimpleHtmlWriter htmlWriter) throws IOException {
                    CompositeOperation<Operation> profiledProjectConfiguration = model.getProjectConfiguration();
                    htmlWriter.startElement("div").attribute("id", "tabs").startElement("ul").attribute("class", "tabLinks").startElement("li").startElement("a").attribute("href", "#tab0").characters((CharSequence)"Summary").endElement().endElement().startElement("li").startElement("a").attribute("href", "#tab1").characters((CharSequence)"Configuration").endElement().endElement().startElement("li").startElement("a").attribute("href", "#tab2").characters((CharSequence)"Dependency Resolution").endElement().endElement().startElement("li").startElement("a").attribute("href", "#tab3").characters((CharSequence)"Artifact Transforms").endElement().endElement().startElement("li").startElement("a").attribute("href", "#tab4").characters((CharSequence)"Task Execution").endElement().endElement().endElement();
                    htmlWriter.startElement("div").attribute("class", "tab").attribute("id", "tab0");
                    htmlWriter.startElement("h2").characters((CharSequence)"Summary").endElement();
                    htmlWriter.startElement("table");
                    htmlWriter.startElement("thead");
                    htmlWriter.startElement("tr");
                    htmlWriter.startElement("th").characters((CharSequence)"Description").endElement();
                    htmlWriter.startElement("th").attribute("class", "numeric").characters((CharSequence)"Duration").endElement();
                    htmlWriter.endElement();
                    htmlWriter.endElement();
                    htmlWriter.startElement("tr");
                    htmlWriter.startElement("td").characters((CharSequence)"Total Build Time").endElement();
                    htmlWriter.startElement("td").attribute("class", "numeric").characters((CharSequence)TimeFormatting.formatDurationVeryTerse((long)model.getElapsedTotal())).endElement();
                    htmlWriter.endElement();
                    htmlWriter.startElement("tr");
                    htmlWriter.startElement("td").characters((CharSequence)"Startup").endElement();
                    htmlWriter.startElement("td").attribute("class", "numeric").characters((CharSequence)TimeFormatting.formatDurationVeryTerse((long)model.getElapsedStartup())).endElement();
                    htmlWriter.endElement();
                    htmlWriter.startElement("tr");
                    htmlWriter.startElement("td").characters((CharSequence)"Settings and BuildSrc").endElement();
                    htmlWriter.startElement("td").attribute("class", "numeric").characters((CharSequence)TimeFormatting.formatDurationVeryTerse((long)model.getElapsedSettings())).endElement();
                    htmlWriter.endElement();
                    htmlWriter.startElement("tr");
                    htmlWriter.startElement("td").characters((CharSequence)"Loading Projects").endElement();
                    htmlWriter.startElement("td").attribute("class", "numeric").characters((CharSequence)TimeFormatting.formatDurationVeryTerse((long)model.getElapsedProjectsLoading())).endElement();
                    htmlWriter.endElement();
                    htmlWriter.startElement("tr");
                    htmlWriter.startElement("td").characters((CharSequence)"Configuring Projects").endElement();
                    htmlWriter.startElement("td").attribute("class", "numeric").characters((CharSequence)TimeFormatting.formatDurationVeryTerse((long)profiledProjectConfiguration.getElapsedTime())).endElement();
                    htmlWriter.endElement();
                    htmlWriter.startElement("tr");
                    htmlWriter.startElement("td").characters((CharSequence)"Artifact Transforms").endElement();
                    htmlWriter.startElement("td").attribute("class", "numeric").characters((CharSequence)TimeFormatting.formatDurationVeryTerse((long)model.getElapsedArtifactTransformTime())).endElement();
                    htmlWriter.endElement();
                    htmlWriter.startElement("tr");
                    htmlWriter.startElement("td").characters((CharSequence)"Task Execution").endElement();
                    htmlWriter.startElement("td").attribute("class", "numeric").characters((CharSequence)TimeFormatting.formatDurationVeryTerse((long)model.getElapsedTotalExecutionTime())).endElement();
                    htmlWriter.endElement();
                    htmlWriter.endElement();
                    htmlWriter.endElement();
                    htmlWriter.startElement("div").attribute("class", "tab").attribute("id", "tab1");
                    htmlWriter.startElement("h2").characters((CharSequence)"Configuration").endElement();
                    htmlWriter.startElement("table");
                    htmlWriter.startElement("thead");
                    htmlWriter.startElement("tr");
                    htmlWriter.startElement("th").characters((CharSequence)"Project").endElement();
                    htmlWriter.startElement("th").attribute("class", "numeric").characters((CharSequence)"Duration").endElement();
                    htmlWriter.endElement();
                    htmlWriter.endElement();
                    htmlWriter.startElement("tr");
                    htmlWriter.startElement("td").characters((CharSequence)"All projects").endElement();
                    htmlWriter.startElement("td").attribute("class", "numeric").characters((CharSequence)TimeFormatting.formatDurationVeryTerse((long)profiledProjectConfiguration.getElapsedTime())).endElement();
                    htmlWriter.endElement();
                    for (Operation operation : profiledProjectConfiguration) {
                        htmlWriter.startElement("tr");
                        htmlWriter.startElement("td").characters((CharSequence)operation.getDescription()).endElement();
                        htmlWriter.startElement("td").attribute("class", "numeric").characters((CharSequence)TimeFormatting.formatDurationVeryTerse((long)operation.getElapsedTime())).endElement();
                        htmlWriter.endElement();
                    }
                    htmlWriter.endElement().endElement();
                    htmlWriter.startElement("div").attribute("class", "tab").attribute("id", "tab2");
                    htmlWriter.startElement("h2").characters((CharSequence)"Dependency Resolution").endElement().startElement("table").startElement("thead");
                    htmlWriter.startElement("tr");
                    htmlWriter.startElement("th").characters((CharSequence)"Dependencies").endElement();
                    htmlWriter.startElement("th").attribute("class", "numeric").characters((CharSequence)"Duration").endElement();
                    htmlWriter.endElement();
                    htmlWriter.endElement();
                    htmlWriter.startElement("tr");
                    htmlWriter.startElement("td").characters((CharSequence)"All dependencies").endElement();
                    htmlWriter.startElement("td").attribute("class", "numeric").characters((CharSequence)TimeFormatting.formatDurationVeryTerse((long)model.getDependencySets().getElapsedTime())).endElement();
                    htmlWriter.endElement();
                    for (Operation operation : model.getDependencySets()) {
                        htmlWriter.startElement("tr");
                        htmlWriter.startElement("td").characters((CharSequence)operation.getDescription()).endElement();
                        htmlWriter.startElement("td").attribute("class", "numeric").characters((CharSequence)TimeFormatting.formatDurationVeryTerse((long)operation.getElapsedTime())).endElement();
                        htmlWriter.endElement();
                    }
                    htmlWriter.endElement().endElement();
                    htmlWriter.startElement("div").attribute("class", "tab").attribute("id", "tab3");
                    htmlWriter.startElement("h2").characters((CharSequence)"Artifact Transforms").endElement().startElement("table").startElement("thead");
                    htmlWriter.startElement("tr");
                    htmlWriter.startElement("th").characters((CharSequence)"Transform").endElement();
                    htmlWriter.startElement("th").attribute("class", "numeric").characters((CharSequence)"Duration").endElement();
                    htmlWriter.endElement();
                    htmlWriter.endElement();
                    htmlWriter.startElement("tr");
                    htmlWriter.startElement("td").characters((CharSequence)"All transforms").endElement();
                    htmlWriter.startElement("td").attribute("class", "numeric").characters((CharSequence)TimeFormatting.formatDurationVeryTerse((long)model.getElapsedArtifactTransformTime())).endElement();
                    htmlWriter.endElement();
                    for (Operation operation : model.getTransformations()) {
                        htmlWriter.startElement("tr");
                        htmlWriter.startElement("td").characters((CharSequence)operation.getDescription()).endElement();
                        htmlWriter.startElement("td").attribute("class", "numeric").characters((CharSequence)TimeFormatting.formatDurationVeryTerse((long)operation.getElapsedTime())).endElement();
                        htmlWriter.endElement();
                    }
                    htmlWriter.endElement().endElement();
                    htmlWriter.startElement("div").attribute("class", "tab").attribute("id", "tab4");
                    htmlWriter.startElement("h2").characters((CharSequence)"Task Execution").endElement().startElement("table").startElement("thead").startElement("tr").startElement("th").characters((CharSequence)"Task").endElement().startElement("th").attribute("class", "numeric").characters((CharSequence)"Duration").endElement().startElement("th").characters((CharSequence)"Result").endElement().endElement().endElement();
                    for (ProjectProfile projectProfile : model.getProjects()) {
                        htmlWriter.startElement("tr").startElement("td").characters((CharSequence)projectProfile.getPath()).endElement().startElement("td").attribute("class", "numeric").characters((CharSequence)TimeFormatting.formatDurationVeryTerse((long)projectProfile.getElapsedTime())).endElement().startElement("td").characters((CharSequence)"(total)").endElement().endElement();
                        for (TaskExecution taskExecution : projectProfile.getTasks()) {
                            htmlWriter.startElement("tr").startElement("td").attribute("class", "indentPath").characters((CharSequence)taskExecution.getPath()).endElement().startElement("td").attribute("class", "numeric").characters((CharSequence)TimeFormatting.formatDurationVeryTerse((long)taskExecution.getElapsedTime())).endElement().startElement("td").characters((CharSequence)taskExecution.getStatus()).endElement().endElement();
                        }
                    }
                    htmlWriter.endElement().endElement().endElement();
                }
            };
        }
    }
}

