/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.util.GUtil;

public class UnionFileCollection
extends CompositeFileCollection {
    private final Set<FileCollection> source;

    public UnionFileCollection(FileCollection ... source) {
        this(Arrays.asList(source));
    }

    public UnionFileCollection(Iterable<? extends FileCollection> source) {
        this.source = (Set)GUtil.addToCollection(new LinkedHashSet(), (Iterable[])new Iterable[]{source});
    }

    @Override
    public String getDisplayName() {
        return "file collection";
    }

    public Set<FileCollection> getSources() {
        return this.source;
    }

    public void addToUnion(FileCollection collection) {
        this.source.add(collection);
    }

    @Override
    public void visitContents(FileCollectionResolveContext context) {
        context.add(this.source);
    }
}

