/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.api.internal.GradleInternal;
import org.gradle.composite.internal.IncludedBuildControllers;
import org.gradle.execution.BuildConfigurationActionExecuter;
import org.gradle.execution.taskgraph.TaskExecutionGraphInternal;
import org.gradle.initialization.ProjectsEvaluatedNotifier;
import org.gradle.initialization.TaskExecutionPreparer;
import org.gradle.internal.operations.BuildOperationExecutor;

public class DefaultTaskExecutionPreparer
implements TaskExecutionPreparer {
    private final BuildOperationExecutor buildOperationExecutor;
    private final BuildConfigurationActionExecuter buildConfigurationActionExecuter;
    private final IncludedBuildControllers includedBuildControllers;

    public DefaultTaskExecutionPreparer(BuildConfigurationActionExecuter buildConfigurationActionExecuter, IncludedBuildControllers includedBuildControllers, BuildOperationExecutor buildOperationExecutor) {
        this.buildConfigurationActionExecuter = buildConfigurationActionExecuter;
        this.includedBuildControllers = includedBuildControllers;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public void prepareForTaskExecution(GradleInternal gradle) {
        this.buildConfigurationActionExecuter.select(gradle);
        TaskExecutionGraphInternal taskGraph = gradle.getTaskGraph();
        taskGraph.populate();
        this.includedBuildControllers.populateTaskGraphs();
        if (gradle.getStartParameter().isConfigureOnDemand()) {
            new ProjectsEvaluatedNotifier(this.buildOperationExecutor).notify(gradle);
        }
    }
}

