/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.execution.BuildConfigurationAction;
import org.gradle.execution.BuildExecutionContext;
import org.gradle.execution.TaskSelector;

public class ExcludedTaskFilteringBuildConfigurationAction
implements BuildConfigurationAction {
    private final TaskSelector taskSelector;

    public ExcludedTaskFilteringBuildConfigurationAction(TaskSelector taskSelector) {
        this.taskSelector = taskSelector;
    }

    @Override
    public void configure(BuildExecutionContext context) {
        GradleInternal gradle = context.getGradle();
        Set excludedTaskNames = gradle.getStartParameter().getExcludedTaskNames();
        if (!excludedTaskNames.isEmpty()) {
            HashSet<Spec<Task>> filters = new HashSet<Spec<Task>>();
            for (String taskName : excludedTaskNames) {
                filters.add(this.taskSelector.getFilter(taskName));
            }
            gradle.getTaskGraph().useFilter((Spec<? super Task>)Specs.intersect(filters));
        }
        context.proceed();
    }
}

