/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.graph.nodes;

import java.util.List;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.AbstractRenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.DependencyEdge;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.Section;

public class DependencyReportHeader
extends AbstractRenderableDependency
implements HasAttributes {
    private final DependencyEdge dependency;
    private final String description;
    private final List<ResolvedVariantResult> selectedVariants;
    private final List<Section> extraDetails;

    public DependencyReportHeader(DependencyEdge dependency, String description, List<ResolvedVariantResult> resolvedVariants, List<Section> extraDetails) {
        this.dependency = dependency;
        this.description = description;
        this.selectedVariants = resolvedVariants;
        this.extraDetails = extraDetails;
    }

    public ComponentIdentifier getId() {
        return this.dependency.getActual();
    }

    @Override
    public String getName() {
        return this.getId().getDisplayName();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public RenderableDependency.ResolutionState getResolutionState() {
        return this.dependency.isResolvable() ? RenderableDependency.ResolutionState.RESOLVED : RenderableDependency.ResolutionState.FAILED;
    }

    @Override
    public List<ResolvedVariantResult> getResolvedVariants() {
        return this.selectedVariants;
    }

    public AttributeContainer getAttributes() {
        ComponentSelector requested = this.dependency.getRequested();
        return requested instanceof ModuleComponentSelector ? requested.getAttributes() : ImmutableAttributes.EMPTY;
    }

    @Override
    public List<Section> getExtraDetails() {
        return this.extraDetails;
    }
}

