/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.artifact;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.publish.internal.PublicationArtifactSet;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyArtifactSet;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.typeconversion.NotationParser;

public class DefaultIvyArtifactSet
extends DefaultDomainObjectSet<IvyArtifact>
implements IvyArtifactSet,
PublicationArtifactSet<IvyArtifact> {
    private final String publicationName;
    private final TaskDependencyInternal builtBy = new ArtifactsTaskDependency();
    private final FileCollection files;
    private final NotationParser<Object, IvyArtifact> ivyArtifactParser;

    public DefaultIvyArtifactSet(String publicationName, NotationParser<Object, IvyArtifact> ivyArtifactParser, FileCollectionFactory fileCollectionFactory, CollectionCallbackActionDecorator collectionCallbackActionDecorator) {
        super(IvyArtifact.class, collectionCallbackActionDecorator);
        this.publicationName = publicationName;
        this.ivyArtifactParser = ivyArtifactParser;
        this.files = fileCollectionFactory.create((TaskDependency)this.builtBy, (MinimalFileSet)new ArtifactsFileCollection());
    }

    @Override
    public IvyArtifact artifact(Object source) {
        IvyArtifact artifact = (IvyArtifact)this.ivyArtifactParser.parseNotation(source);
        this.add(artifact);
        return artifact;
    }

    @Override
    public IvyArtifact artifact(Object source, Action<? super IvyArtifact> config) {
        IvyArtifact artifact = this.artifact(source);
        config.execute((Object)artifact);
        return artifact;
    }

    public FileCollection getFiles() {
        return this.files;
    }

    private class ArtifactsTaskDependency
    extends AbstractTaskDependency {
        private ArtifactsTaskDependency() {
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            Iterator iterator = DefaultIvyArtifactSet.this.iterator();
            while (iterator.hasNext()) {
                IvyArtifact ivyArtifact = (IvyArtifact)iterator.next();
                context.add((Object)ivyArtifact);
            }
        }
    }

    private class ArtifactsFileCollection
    implements MinimalFileSet {
        private ArtifactsFileCollection() {
        }

        public String getDisplayName() {
            return "artifacts for Ivy publication '" + DefaultIvyArtifactSet.this.publicationName + "'";
        }

        public Set<File> getFiles() {
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            Iterator iterator = DefaultIvyArtifactSet.this.iterator();
            while (iterator.hasNext()) {
                IvyArtifact artifact = (IvyArtifact)iterator.next();
                files.add(artifact.getFile());
            }
            return files;
        }
    }
}

