/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.gradle.cache.CleanableStore;
import org.gradle.cache.CleanupProgressMonitor;
import org.gradle.cache.internal.AbstractCacheCleanup;
import org.gradle.cache.internal.FilesFinder;
import org.gradle.internal.resource.local.FileAccessTimeJournal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeastRecentlyUsedCacheCleanup
extends AbstractCacheCleanup {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeastRecentlyUsedCacheCleanup.class);
    public static final long DEFAULT_MAX_AGE_IN_DAYS_FOR_RECREATABLE_CACHE_ENTRIES = 7L;
    public static final long DEFAULT_MAX_AGE_IN_DAYS_FOR_EXTERNAL_CACHE_ENTRIES = 30L;
    private final FileAccessTimeJournal journal;
    private final long minimumTimestamp;

    public LeastRecentlyUsedCacheCleanup(FilesFinder eligibleFilesFinder, FileAccessTimeJournal journal, long numberOfDays) {
        super(eligibleFilesFinder);
        this.journal = journal;
        this.minimumTimestamp = Math.max(0L, System.currentTimeMillis() - TimeUnit.DAYS.toMillis(numberOfDays));
    }

    @Override
    public void clean(CleanableStore cleanableStore, CleanupProgressMonitor progressMonitor) {
        LOGGER.info("{} removing files not accessed on or after {}.", (Object)cleanableStore.getDisplayName(), (Object)new Date(this.minimumTimestamp));
        super.clean(cleanableStore, progressMonitor);
    }

    @Override
    protected boolean shouldDelete(File file) {
        return this.journal.getLastAccessTime(file) < this.minimumTimestamp;
    }

    @Override
    protected void handleDeletion(File file) {
        this.journal.deleteLastAccessTime(file);
    }
}

