/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse;

import javax.inject.Inject;
import org.gradle.api.tasks.Internal;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.plugins.ide.api.XmlGeneratorTask;
import org.gradle.plugins.ide.eclipse.model.Classpath;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;

public class GenerateEclipseClasspath
extends XmlGeneratorTask<Classpath> {
    private EclipseClasspath classpath;

    public GenerateEclipseClasspath() {
        this.getXmlTransformer().setIndentation("\t");
    }

    @Inject
    public GenerateEclipseClasspath(EclipseClasspath classpath) {
        this.classpath = classpath;
    }

    @Override
    protected Classpath create() {
        return new Classpath(this.getXmlTransformer(), this.classpath.getFileReferenceFactory());
    }

    @Override
    protected void configure(Classpath xmlClasspath) {
        this.classpath.mergeXmlClasspath(xmlClasspath);
    }

    @Override
    public XmlTransformer getXmlTransformer() {
        if (this.classpath == null) {
            return super.getXmlTransformer();
        }
        return this.classpath.getFile().getXmlTransformer();
    }

    @Internal
    public EclipseClasspath getClasspath() {
        return this.classpath;
    }

    public void setClasspath(EclipseClasspath classpath) {
        this.classpath = classpath;
    }
}

