/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.psi.IfNotParsed;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtVisitor;

public class KtBinaryExpression
extends KtExpressionImpl
implements KtOperationExpression {
    public KtBinaryExpression(@NotNull ASTNode node) {
        if (node == null) {
            KtBinaryExpression.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            KtBinaryExpression.$$$reportNull$$$0(1);
        }
        return visitor2.visitBinaryExpression(this, data);
    }

    @IfNotParsed
    @Nullable
    public KtExpression getLeft() {
        for (ASTNode node = this.getOperationReference().getNode().getTreePrev(); node != null; node = node.getTreePrev()) {
            PsiElement psi = node.getPsi();
            if (!(psi instanceof KtExpression)) continue;
            return (KtExpression)psi;
        }
        return null;
    }

    @IfNotParsed
    @Nullable
    public KtExpression getRight() {
        for (ASTNode node = this.getOperationReference().getNode().getTreeNext(); node != null; node = node.getTreeNext()) {
            PsiElement psi = node.getPsi();
            if (!(psi instanceof KtExpression)) continue;
            return (KtExpression)psi;
        }
        return null;
    }

    @Override
    @NotNull
    public KtOperationReferenceExpression getOperationReference() {
        Object operationReference = this.findChildByType(KtNodeTypes.OPERATION_REFERENCE);
        if (operationReference == null) {
            throw new NullPointerException("No operation reference for binary expression: " + Arrays.toString(this.getChildren()));
        }
        KtOperationReferenceExpression ktOperationReferenceExpression = (KtOperationReferenceExpression)operationReference;
        if (ktOperationReferenceExpression == null) {
            KtBinaryExpression.$$$reportNull$$$0(2);
        }
        return ktOperationReferenceExpression;
    }

    @NotNull
    public IElementType getOperationToken() {
        IElementType iElementType = this.getOperationReference().getReferencedNameElementType();
        if (iElementType == null) {
            KtBinaryExpression.$$$reportNull$$$0(3);
        }
        return iElementType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/psi/KtBinaryExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/psi/KtBinaryExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationToken";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

