/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.kotlin.com.intellij.codeInsight.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class CheckedExceptionCompatibilityConstraint
extends InputOutputConstraintFormula {
    private static final Logger LOG = Logger.getInstance(CheckedExceptionCompatibilityConstraint.class);
    private final PsiExpression myExpression;
    private PsiType myT;

    public CheckedExceptionCompatibilityConstraint(PsiExpression expression2, PsiType t) {
        this.myExpression = expression2;
        this.myT = t;
    }

    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        block18: {
            Object exceptions;
            PsiExpression body;
            PsiType type3;
            if (!PsiPolyExpressionUtil.isPolyExpression(this.myExpression)) {
                return true;
            }
            if (this.myExpression instanceof PsiParenthesizedExpression) {
                constraints.add(new CheckedExceptionCompatibilityConstraint(((PsiParenthesizedExpression)this.myExpression).getExpression(), this.myT));
                return true;
            }
            if (this.myExpression instanceof PsiConditionalExpression) {
                PsiExpression elseExpression;
                PsiExpression thenExpression = ((PsiConditionalExpression)this.myExpression).getThenExpression();
                if (thenExpression != null) {
                    constraints.add(new CheckedExceptionCompatibilityConstraint(thenExpression, this.myT));
                }
                if ((elseExpression = ((PsiConditionalExpression)this.myExpression).getElseExpression()) != null) {
                    constraints.add(new CheckedExceptionCompatibilityConstraint(elseExpression, this.myT));
                }
                return true;
            }
            if (!(this.myExpression instanceof PsiLambdaExpression) && !(this.myExpression instanceof PsiMethodReferenceExpression)) break block18;
            if (!LambdaUtil.isFunctionalType(this.myT)) {
                session.registerIncompatibleErrorMessage(session.getPresentableText(this.myT) + " is not a functional interface");
                return false;
            }
            PsiType groundTargetType = this.myExpression instanceof PsiLambdaExpression ? FunctionalInterfaceParameterizationUtil.getGroundTargetType(this.myT, (PsiLambdaExpression)this.myExpression, false) : FunctionalInterfaceParameterizationUtil.getGroundTargetType(this.myT);
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(groundTargetType);
            if (interfaceMethod == null) {
                session.registerIncompatibleErrorMessage("No valid function type can be found for " + session.getPresentableText(this.myT));
                return false;
            }
            PsiSubstitutor substitutor2 = LambdaUtil.getSubstitutor(interfaceMethod, PsiUtil.resolveGenericsClassInType(groundTargetType));
            if (this.myExpression instanceof PsiLambdaExpression && !((PsiLambdaExpression)this.myExpression).hasFormalParameterTypes() || this.myExpression instanceof PsiMethodReferenceExpression && !((PsiMethodReferenceExpression)this.myExpression).isExact()) {
                for (PsiParameter parameter : interfaceMethod.getParameterList().getParameters()) {
                    PsiType type4 = substitutor2.substitute(parameter.getType());
                    if (session.isProperType(type4)) continue;
                    session.registerIncompatibleErrorMessage("Parameter type is not yet inferred: " + session.getPresentableText(type4));
                    return false;
                }
            }
            PsiType returnType2 = interfaceMethod.getReturnType();
            if (!(!(this.myExpression instanceof PsiLambdaExpression) && ((PsiMethodReferenceExpression)this.myExpression).isExact() || session.isProperType(type3 = substitutor2.substitute(returnType2)))) {
                session.registerIncompatibleErrorMessage("Return type is not yet inferred: " + session.getPresentableText(type3));
                return false;
            }
            List<PsiType> expectedThrownTypes = ContainerUtil.map(interfaceMethod.getThrowsList().getReferencedTypes(), type2 -> session.substituteWithInferenceVariables(substitutor2.substitute((PsiType)type2)));
            ArrayList<PsiType> expectedNonProperThrownTypes = new ArrayList<PsiType>();
            for (PsiType type4 : expectedThrownTypes) {
                if (session.isProperType(type4)) continue;
                expectedNonProperThrownTypes.add(type4);
            }
            ArrayList<PsiClassType> thrownTypes = new ArrayList<PsiClassType>();
            PsiElement psiElement = body = this.myExpression instanceof PsiLambdaExpression ? ((PsiLambdaExpression)this.myExpression).getBody() : this.myExpression;
            if (body != null && (exceptions = ExceptionUtil.getUnhandledExceptions(new PsiElement[]{body})) != null) {
                thrownTypes.addAll(ContainerUtil.filter(exceptions, type2 -> !ExceptionUtil.isUncheckedException(type2)));
            }
            if (expectedNonProperThrownTypes.isEmpty()) {
                for (PsiType psiType : thrownTypes) {
                    if (CheckedExceptionCompatibilityConstraint.isAddressed(expectedThrownTypes, psiType)) continue;
                    session.registerIncompatibleErrorMessage("Unhandled exception: " + session.getPresentableText(psiType));
                    return false;
                }
            } else {
                ArrayList<PsiType> expectedProperTypes = new ArrayList<PsiType>(expectedThrownTypes);
                expectedProperTypes.removeAll(expectedNonProperThrownTypes);
                for (PsiType psiType : thrownTypes) {
                    if (CheckedExceptionCompatibilityConstraint.isAddressed(expectedProperTypes, psiType)) continue;
                    for (PsiType expectedNonProperThrownType : expectedNonProperThrownTypes) {
                        constraints.add(new StrictSubtypingConstraint(expectedNonProperThrownType, psiType));
                    }
                }
                for (PsiType psiType : expectedNonProperThrownTypes) {
                    InferenceVariable variable2 = session.getInferenceVariable(psiType);
                    if (variable2 == null) continue;
                    variable2.setThrownBound();
                }
            }
        }
        return true;
    }

    private static boolean isAddressed(List<PsiType> expectedThrownTypes, PsiType thrownType) {
        for (PsiType expectedThrownType : expectedThrownTypes) {
            if (!TypeConversionUtil.isAssignable(expectedThrownType, thrownType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PsiExpression getExpression() {
        return this.myExpression;
    }

    @Override
    protected PsiType getT() {
        return this.myT;
    }

    @Override
    protected void setT(PsiType t) {
        this.myT = t;
    }

    @Override
    protected InputOutputConstraintFormula createSelfConstraint(PsiType type2, PsiExpression expression2) {
        return new CheckedExceptionCompatibilityConstraint(expression2, type2);
    }

    @Override
    protected void collectReturnTypeVariables(InferenceSession session, PsiExpression psiExpression, PsiType returnType2, Set<InferenceVariable> result2) {
        session.collectDependencies(returnType2, result2);
    }
}

