/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.MissingResourceException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.LowMemoryWatcher;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.util.Consumer;
import org.jetbrains.kotlin.com.intellij.util.concurrency.SequentialTaskExecutor;

public class LowMemoryWatcherManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.LowMemoryWatcherManager");
    @NotNull
    private final ExecutorService myExecutorService;
    private Future<?> mySubmitted;
    private final AtomicBoolean myProcessing;
    private final Consumer<Boolean> myJanitor;
    private final NotificationListener myLowMemoryListener;

    public LowMemoryWatcherManager(@NotNull Executor executorService) {
        if (executorService == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(0);
        }
        this.myProcessing = new AtomicBoolean();
        this.myJanitor = new Consumer<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void consume(@NotNull Boolean afterGc) {
                if (afterGc == null) {
                    1.$$$reportNull$$$0(0);
                }
                Consumer consumer = LowMemoryWatcherManager.this.myJanitor;
                synchronized (consumer) {
                    LowMemoryWatcherManager.this.mySubmitted = null;
                }
                LowMemoryWatcher.onLowMemorySignalReceived(afterGc);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterGc", "org/jetbrains/kotlin/com/intellij/openapi/util/LowMemoryWatcherManager$1", "consume"));
            }
        };
        this.myLowMemoryListener = new NotificationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleNotification(Notification notification, Object __) {
                boolean memoryThreshold = "java.management.memory.threshold.exceeded".equals(notification.getType());
                boolean memoryCollectionThreshold = "java.management.memory.collection.threshold.exceeded".equals(notification.getType());
                if (memoryThreshold || memoryCollectionThreshold) {
                    final boolean afterGc = memoryCollectionThreshold;
                    if (Registry.is("low.memory.watcher.sync", true)) {
                        LowMemoryWatcherManager.this.handleEventImmediately(afterGc);
                        return;
                    }
                    Consumer consumer = LowMemoryWatcherManager.this.myJanitor;
                    synchronized (consumer) {
                        if (LowMemoryWatcherManager.this.mySubmitted == null) {
                            LowMemoryWatcherManager.this.mySubmitted = LowMemoryWatcherManager.this.myExecutorService.submit(new Runnable(){

                                @Override
                                public void run() {
                                    LowMemoryWatcherManager.this.myJanitor.consume(afterGc);
                                }
                            });
                        }
                    }
                }
            }
        };
        this.myExecutorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor("LowMemoryWatcherManager", executorService);
        try {
            for (MemoryPoolMXBean bean : ManagementFactory.getMemoryPoolMXBeans()) {
                long max;
                long threshold;
                if (bean.getType() != MemoryType.HEAP || !bean.isCollectionUsageThresholdSupported() || !bean.isUsageThresholdSupported() || (threshold = Math.min((long)((double)(max = bean.getUsage().getMax()) * LowMemoryWatcherManager.getOccupiedMemoryThreshold()), max - 0x500000L)) <= 0L) continue;
                bean.setUsageThreshold(threshold);
                bean.setCollectionUsageThreshold(threshold);
            }
            ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).addNotificationListener(this.myLowMemoryListener, null, null);
        }
        catch (Throwable e) {
            LOG.info("Errors initializing LowMemoryWatcher: ", e);
        }
    }

    private static double getOccupiedMemoryThreshold() {
        try {
            return Registry.doubleValue("low.memory.watcher.notification.threshold");
        }
        catch (MissingResourceException e) {
            return 0.95;
        }
    }

    private void handleEventImmediately(boolean afterGc) {
        if (this.myProcessing.compareAndSet(false, true)) {
            try {
                this.myJanitor.consume(afterGc);
            }
            finally {
                this.myProcessing.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        try {
            ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).removeNotificationListener(this.myLowMemoryListener);
        }
        catch (ListenerNotFoundException e) {
            LOG.error(e);
        }
        Consumer<Boolean> consumer = this.myJanitor;
        synchronized (consumer) {
            if (this.mySubmitted != null) {
                this.mySubmitted.cancel(false);
                this.mySubmitted = null;
            }
        }
        LowMemoryWatcher.stopAll();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorService", "org/jetbrains/kotlin/com/intellij/openapi/util/LowMemoryWatcherManager", "<init>"));
    }
}

