/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.codegen.CallableReferenceUtilKt;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.JvmKotlinType;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.DelegatingResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class FunctionReferenceGenerationStrategy
extends FunctionGenerationStrategy.CodegenBased {
    private final ResolvedCall<?> resolvedCall;
    private final FunctionDescriptor referencedFunction;
    private final FunctionDescriptor functionDescriptor;
    private final Type receiverType;
    private final KotlinType receiverKotlinType;
    private final StackValue receiverValue;
    private final boolean isInliningStrategy;

    public FunctionReferenceGenerationStrategy(@NotNull GenerationState state2, @NotNull FunctionDescriptor functionDescriptor, @NotNull ResolvedCall<?> resolvedCall2, @Nullable JvmKotlinType receiverJvmKotlinType, @Nullable StackValue receiverValue, boolean isInliningStrategy) {
        if (state2 == null) {
            FunctionReferenceGenerationStrategy.$$$reportNull$$$0(0);
        }
        if (functionDescriptor == null) {
            FunctionReferenceGenerationStrategy.$$$reportNull$$$0(1);
        }
        if (resolvedCall2 == null) {
            FunctionReferenceGenerationStrategy.$$$reportNull$$$0(2);
        }
        super(state2);
        this.resolvedCall = resolvedCall2;
        FunctionDescriptor referencedFunction = (FunctionDescriptor)resolvedCall2.getResultingDescriptor();
        if (referencedFunction.isSuspend()) {
            this.referencedFunction = CoroutineCodegenUtilKt.getOrCreateJvmSuspendFunctionView(referencedFunction, state2);
            this.functionDescriptor = CoroutineCodegenUtilKt.getOrCreateJvmSuspendFunctionView(functionDescriptor, state2);
        } else {
            this.referencedFunction = referencedFunction;
            this.functionDescriptor = functionDescriptor;
        }
        this.receiverType = receiverJvmKotlinType != null ? receiverJvmKotlinType.getType() : null;
        this.receiverKotlinType = receiverJvmKotlinType != null ? receiverJvmKotlinType.getKotlinType() : null;
        this.receiverValue = receiverValue;
        this.isInliningStrategy = isInliningStrategy;
        assert (this.receiverType != null || receiverValue == null) : "A receiver value is provided for unbound function reference. Either this is a bound reference and you forgot to pass receiverType, or you accidentally passed some receiverValue for a reference without receiver";
    }

    @Override
    public void doGenerateBody(@NotNull ExpressionCodegen codegen2, @NotNull JvmMethodSignature signature) {
        StackValue result2;
        if (codegen2 == null) {
            FunctionReferenceGenerationStrategy.$$$reportNull$$$0(3);
        }
        if (signature == null) {
            FunctionReferenceGenerationStrategy.$$$reportNull$$$0(4);
        }
        final int receivers = CallableReferenceUtilKt.computeExpectedNumberOfReceivers(this.referencedFunction, this.receiverType != null);
        final int fakeArgCount = this.functionDescriptor.getValueParameters().size() - receivers;
        KtCallExpression fakeExpression = CodegenUtil.constructFakeFunctionCall(this.state.getProject(), fakeArgCount);
        final List<KtValueArgument> fakeArguments = fakeExpression.getValueArguments();
        final ReceiverValue dispatchReceiver = this.computeAndSaveReceiver(signature, codegen2, this.referencedFunction.getDispatchReceiverParameter());
        final ReceiverValue extensionReceiver2 = this.computeAndSaveReceiver(signature, codegen2, this.referencedFunction.getExtensionReceiverParameter());
        this.computeAndSaveArguments(fakeArguments, codegen2, receivers);
        DelegatingResolvedCall<CallableDescriptor> fakeResolvedCall2 = new DelegatingResolvedCall<CallableDescriptor>(this.resolvedCall){
            private final Map<ValueParameterDescriptor, ResolvedValueArgument> argumentMap;
            {
                super(arg0);
                this.argumentMap = new LinkedHashMap<ValueParameterDescriptor, ResolvedValueArgument>();
                int i = 0;
                for (ValueParameterDescriptor parameter : FunctionReferenceGenerationStrategy.this.referencedFunction.getValueParameters()) {
                    if (parameter.getVarargElementType() != null) {
                        if (i == fakeArgCount) {
                            this.argumentMap.put(parameter, ArgumentsUtilsKt.hasDefaultValue(parameter) ? DefaultValueArgument.DEFAULT : new VarargValueArgument());
                            continue;
                        }
                        if (FunctionReferenceGenerationStrategy.this.functionDescriptor.getValueParameters().get(receivers + i).getType().equals(parameter.getVarargElementType())) {
                            this.argumentMap.put(parameter, new VarargValueArgument(fakeArguments.subList(i, fakeArgCount)));
                            i = fakeArgCount;
                            continue;
                        }
                    }
                    if (i < fakeArgCount) {
                        this.argumentMap.put(parameter, new ExpressionValueArgument((ValueArgument)fakeArguments.get(i++)));
                        continue;
                    }
                    assert (ArgumentsUtilsKt.hasDefaultValue(parameter)) : "Parameter should be either vararg or expression or default: " + parameter + " (reference in: " + FunctionReferenceGenerationStrategy.access$100(FunctionReferenceGenerationStrategy.this).getContainingDeclaration() + ")";
                    this.argumentMap.put(parameter, DefaultValueArgument.DEFAULT);
                }
            }

            @Override
            @Nullable
            public ReceiverValue getExtensionReceiver() {
                return extensionReceiver2;
            }

            @Override
            @Nullable
            public ReceiverValue getDispatchReceiver() {
                return dispatchReceiver;
            }

            @Override
            @NotNull
            public List<ResolvedValueArgument> getValueArgumentsByIndex() {
                ArrayList<ResolvedValueArgument> arrayList = new ArrayList<ResolvedValueArgument>(this.argumentMap.values());
                if (arrayList == null) {
                    1.$$$reportNull$$$0(0);
                }
                return arrayList;
            }

            @Override
            @NotNull
            public Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArguments() {
                Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = this.argumentMap;
                if (map2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return map2;
            }

            @Override
            @NotNull
            public CallableDescriptor getCandidateDescriptor() {
                FunctionDescriptor functionDescriptor = FunctionReferenceGenerationStrategy.this.referencedFunction;
                if (functionDescriptor == null) {
                    1.$$$reportNull$$$0(2);
                }
                return functionDescriptor;
            }

            @Override
            @NotNull
            public CallableDescriptor getResultingDescriptor() {
                FunctionDescriptor functionDescriptor = FunctionReferenceGenerationStrategy.this.referencedFunction;
                if (functionDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                return functionDescriptor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueArgumentsByIndex";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueArguments";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCandidateDescriptor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getResultingDescriptor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        Type returnType2 = codegen2.getReturnType();
        if (this.referencedFunction instanceof ConstructorDescriptor) {
            result2 = returnType2.getSort() == 9 ? codegen2.generateNewArray(fakeExpression, this.referencedFunction.getReturnType(), fakeResolvedCall2) : codegen2.generateConstructorCall(fakeResolvedCall2, returnType2);
        } else {
            Call call2 = CallMaker.makeCall(fakeExpression, null, null, fakeExpression, fakeArguments);
            result2 = codegen2.invokeFunction(call2, fakeResolvedCall2, StackValue.none());
        }
        InstructionAdapter v2 = codegen2.v;
        result2.put(returnType2, v2);
        v2.areturn(returnType2);
    }

    private void computeAndSaveArguments(@NotNull List<? extends ValueArgument> fakeArguments, @NotNull ExpressionCodegen codegen2, int receivers) {
        if (fakeArguments == null) {
            FunctionReferenceGenerationStrategy.$$$reportNull$$$0(5);
        }
        if (codegen2 == null) {
            FunctionReferenceGenerationStrategy.$$$reportNull$$$0(6);
        }
        List valueParameters2 = CollectionsKt.drop(this.functionDescriptor.getValueParameters(), (int)receivers);
        assert (valueParameters2.size() == fakeArguments.size()) : this.functionDescriptor + ": " + valueParameters2.size() + " != " + fakeArguments.size();
        for (int i = 0; i < valueParameters2.size(); ++i) {
            ValueParameterDescriptor parameter = (ValueParameterDescriptor)valueParameters2.get(i);
            ValueArgument fakeArgument = fakeArguments.get(i);
            Type type2 = this.state.getTypeMapper().mapType(parameter);
            int localIndex = codegen2.myFrameMap.getIndex(parameter);
            if (localIndex > 0) {
                codegen2.tempVariables.put(fakeArgument.getArgumentExpression(), StackValue.local(localIndex, type2));
                continue;
            }
            codegen2.tempVariables.put(fakeArgument.getArgumentExpression(), StackValue.local(parameter.getIndex() + 1 + receivers, type2));
        }
    }

    @Nullable
    private ReceiverValue computeAndSaveReceiver(@NotNull JvmMethodSignature signature, @NotNull ExpressionCodegen codegen2, @Nullable ReceiverParameterDescriptor receiver2) {
        if (signature == null) {
            FunctionReferenceGenerationStrategy.$$$reportNull$$$0(7);
        }
        if (codegen2 == null) {
            FunctionReferenceGenerationStrategy.$$$reportNull$$$0(8);
        }
        if (receiver2 == null) {
            return null;
        }
        KtExpression receiverExpression = KtPsiFactoryKt.KtPsiFactory(this.state.getProject(), false).createExpression("callableReferenceFakeReceiver");
        codegen2.tempVariables.put(receiverExpression, this.receiverParameterStackValue(signature, codegen2));
        return ExpressionReceiver.Companion.create(receiverExpression, receiver2.getType(), BindingContext.EMPTY);
    }

    @NotNull
    private StackValue receiverParameterStackValue(@NotNull JvmMethodSignature signature, @NotNull ExpressionCodegen codegen2) {
        if (signature == null) {
            FunctionReferenceGenerationStrategy.$$$reportNull$$$0(9);
        }
        if (codegen2 == null) {
            FunctionReferenceGenerationStrategy.$$$reportNull$$$0(10);
        }
        if (this.receiverValue != null) {
            StackValue stackValue = this.receiverValue;
            if (stackValue == null) {
                FunctionReferenceGenerationStrategy.$$$reportNull$$$0(11);
            }
            return stackValue;
        }
        if (this.receiverType != null) {
            ClassDescriptor classDescriptor2 = (ClassDescriptor)codegen2.getContext().getParentContext().getContextDescriptor();
            Type asmType = codegen2.getState().getTypeMapper().mapClass(classDescriptor2);
            StackValue stackValue = CallableReferenceUtilKt.capturedBoundReferenceReceiver(asmType, this.receiverType, this.receiverKotlinType, this.isInliningStrategy);
            if (stackValue == null) {
                FunctionReferenceGenerationStrategy.$$$reportNull$$$0(12);
            }
            return stackValue;
        }
        StackValue.Local local = StackValue.local(1, signature.getAsmMethod().getArgumentTypes()[0]);
        if (local == null) {
            FunctionReferenceGenerationStrategy.$$$reportNull$$$0(13);
        }
        return local;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedCall";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codegen";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fakeArguments";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "receiverParameterStackValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doGenerateBody";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeAndSaveArguments";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeAndSaveReceiver";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "receiverParameterStackValue";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

