/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal.services;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.artifacts.mvnsettings.MavenSettingsProvider;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.buildinit.plugins.internal.BasicProjectGenerator;
import org.gradle.buildinit.plugins.internal.BuildContentGenerator;
import org.gradle.buildinit.plugins.internal.BuildInitializer;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilderFactory;
import org.gradle.buildinit.plugins.internal.CompositeProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.CppApplicationProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.CppLibraryProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.DefaultTemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.GitIgnoreGenerator;
import org.gradle.buildinit.plugins.internal.GroovyApplicationProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.GroovyGradlePluginProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.GroovyLibraryProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.JavaApplicationProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.JavaGradlePluginProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.JavaLibraryProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.KotlinApplicationProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.KotlinGradlePluginProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.KotlinLibraryProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.LanguageSpecificAdaptor;
import org.gradle.buildinit.plugins.internal.LanguageSpecificProjectGenerator;
import org.gradle.buildinit.plugins.internal.ProjectGenerator;
import org.gradle.buildinit.plugins.internal.ProjectLayoutSetupRegistry;
import org.gradle.buildinit.plugins.internal.ResourceDirsGenerator;
import org.gradle.buildinit.plugins.internal.ScalaLibraryProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.SimpleGlobalFilesBuildSettingsDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;
import org.gradle.buildinit.plugins.internal.maven.PomProjectInitDescriptor;
import org.gradle.internal.file.PathToFileResolver;

public class ProjectLayoutSetupRegistryFactory {
    private final DocumentationRegistry documentationRegistry;
    private final MavenSettingsProvider mavenSettingsProvider;
    private final FileResolver fileResolver;
    private final BuildScriptBuilderFactory scriptBuilderFactory;
    private final TemplateOperationFactory templateOperationBuilder;

    public ProjectLayoutSetupRegistryFactory(MavenSettingsProvider mavenSettingsProvider, DocumentationRegistry documentationRegistry, FileResolver fileResolver) {
        this.mavenSettingsProvider = mavenSettingsProvider;
        this.documentationRegistry = documentationRegistry;
        this.fileResolver = fileResolver;
        this.scriptBuilderFactory = new BuildScriptBuilderFactory((PathToFileResolver)fileResolver);
        this.templateOperationBuilder = new TemplateOperationFactory("/org/gradle/buildinit/tasks/templates", (PathToFileResolver)fileResolver, documentationRegistry);
    }

    public ProjectLayoutSetupRegistry createProjectLayoutSetupRegistry() {
        DefaultTemplateLibraryVersionProvider libraryVersionProvider = new DefaultTemplateLibraryVersionProvider();
        TemplateOperationFactory templateOperationBuilder = this.templateOperationBuilder;
        SimpleGlobalFilesBuildSettingsDescriptor settingsDescriptor = new SimpleGlobalFilesBuildSettingsDescriptor(this.scriptBuilderFactory, this.documentationRegistry);
        ResourceDirsGenerator resourcesGenerator = new ResourceDirsGenerator((PathToFileResolver)this.fileResolver);
        GitIgnoreGenerator gitIgnoreGenerator = new GitIgnoreGenerator(this.fileResolver);
        ImmutableList jvmProjectGenerators = ImmutableList.of((Object)settingsDescriptor, (Object)gitIgnoreGenerator, (Object)resourcesGenerator);
        ImmutableList commonGenerators = ImmutableList.of((Object)settingsDescriptor, (Object)gitIgnoreGenerator);
        BuildInitializer basicType = this.of(new BasicProjectGenerator(this.scriptBuilderFactory, this.documentationRegistry), (List<BuildContentGenerator>)commonGenerators);
        PomProjectInitDescriptor mavenBuildConverter = new PomProjectInitDescriptor((PathToFileResolver)this.fileResolver, this.mavenSettingsProvider, this.scriptBuilderFactory, this.documentationRegistry);
        ProjectLayoutSetupRegistry registry = new ProjectLayoutSetupRegistry(basicType, mavenBuildConverter);
        registry.add(this.of(new JavaLibraryProjectInitDescriptor(libraryVersionProvider, this.documentationRegistry), (List<BuildContentGenerator>)jvmProjectGenerators));
        registry.add(this.of(new JavaApplicationProjectInitDescriptor(libraryVersionProvider, this.documentationRegistry), (List<BuildContentGenerator>)jvmProjectGenerators));
        registry.add(this.of(new GroovyApplicationProjectInitDescriptor(libraryVersionProvider, this.documentationRegistry), (List<BuildContentGenerator>)jvmProjectGenerators));
        registry.add(this.of(new GroovyLibraryProjectInitDescriptor(libraryVersionProvider, this.documentationRegistry), (List<BuildContentGenerator>)jvmProjectGenerators));
        registry.add(this.of(new ScalaLibraryProjectInitDescriptor(libraryVersionProvider, this.documentationRegistry), (List<BuildContentGenerator>)jvmProjectGenerators));
        registry.add(this.of(new CppApplicationProjectInitDescriptor(templateOperationBuilder, this.documentationRegistry), (List<BuildContentGenerator>)commonGenerators));
        registry.add(this.of(new CppLibraryProjectInitDescriptor(templateOperationBuilder, this.documentationRegistry), (List<BuildContentGenerator>)commonGenerators));
        registry.add(this.of(new KotlinApplicationProjectInitDescriptor(libraryVersionProvider), (List<BuildContentGenerator>)jvmProjectGenerators));
        registry.add(this.of(new KotlinLibraryProjectInitDescriptor(libraryVersionProvider), (List<BuildContentGenerator>)jvmProjectGenerators));
        registry.add(this.of(new JavaGradlePluginProjectInitDescriptor(libraryVersionProvider, this.documentationRegistry), (List<BuildContentGenerator>)jvmProjectGenerators));
        registry.add(this.of(new GroovyGradlePluginProjectInitDescriptor(libraryVersionProvider, this.documentationRegistry), (List<BuildContentGenerator>)jvmProjectGenerators));
        registry.add(this.of(new KotlinGradlePluginProjectInitDescriptor(libraryVersionProvider, this.documentationRegistry), (List<BuildContentGenerator>)jvmProjectGenerators));
        return registry;
    }

    private BuildInitializer of(ProjectGenerator projectGenerator, List<BuildContentGenerator> generators) {
        return new CompositeProjectInitDescriptor(projectGenerator, generators);
    }

    private BuildInitializer of(LanguageSpecificProjectGenerator projectGenerator, List<BuildContentGenerator> generators) {
        return this.of(new LanguageSpecificAdaptor(projectGenerator, this.scriptBuilderFactory, this.fileResolver, this.templateOperationBuilder), generators);
    }
}

