/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.util.Iterator;
import net.htmlparser.jericho.Cache;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.Tag;
import net.htmlparser.jericho.TagType;

final class SubCache {
    private final Cache cache;
    public final TagType tagType;
    private final CacheEntry bof;
    private final CacheEntry eof;
    private CacheEntry[] array = new CacheEntry[64];
    private static final int INITIAL_CAPACITY = 64;

    public SubCache(Cache cache, TagType tagType) {
        this.cache = cache;
        this.tagType = tagType;
        this.array[0] = this.bof = new CacheEntry(0, -1, null, false, false);
        this.array[1] = this.eof = new CacheEntry(1, cache.getSourceLength(), null, false, false);
    }

    public int size() {
        return this.eof.index + 1;
    }

    public void clear() {
        this.bof.nextCached = false;
        this.eof.index = 1;
        this.eof.previousCached = false;
        this.array[1] = this.eof;
    }

    public void bulkLoad_Init(int tagCount) {
        this.array = new CacheEntry[tagCount + 2];
        this.array[0] = this.bof;
        this.bof.nextCached = true;
        this.eof.index = tagCount + 1;
        this.array[this.eof.index] = this.eof;
        this.eof.previousCached = true;
    }

    public void bulkLoad_Set(int tagsIndex, Tag tag) {
        int index = tagsIndex + 1;
        this.array[index] = new CacheEntry(index, tag.begin, tag, true, true);
    }

    public void bulkLoad_AddToTypeSpecificCache(Tag tag) {
        int index = this.eof.index;
        if (this.array.length == this.eof.index + 1) {
            this.doubleCapacity();
        }
        this.array[index] = new CacheEntry(index, tag.begin, tag, true, true);
        ++this.eof.index;
    }

    public void bulkLoad_FinaliseTypeSpecificCache() {
        this.bof.nextCached = true;
        this.eof.previousCached = true;
        this.array[this.eof.index] = this.eof;
    }

    public Tag getTagAt(int pos, boolean serverTagOnly) {
        if (this.cache.getSourceLength() == 0) {
            return null;
        }
        if (pos < 0 || pos >= this.cache.getSourceLength()) {
            return null;
        }
        int index = this.getIndexOfPos(pos);
        CacheEntry cacheEntry = this.array[index];
        if (cacheEntry.pos == pos) {
            if (serverTagOnly && !cacheEntry.tag.getTagType().isServerTag()) {
                return null;
            }
            return cacheEntry.tag;
        }
        if (cacheEntry.previousCached) {
            return null;
        }
        return this.cache.addTagAt(pos, serverTagOnly);
    }

    public void addTagAt(int pos, Tag tag) {
        int index = this.getIndexOfPos(pos);
        CacheEntry nextCacheEntry = this.array[index];
        CacheEntry previousCacheEntry = this.getPrevious(nextCacheEntry);
        this.add(previousCacheEntry, new CacheEntry(index, pos, tag, pos == previousCacheEntry.pos + 1, pos == nextCacheEntry.pos - 1), nextCacheEntry);
    }

    public Tag getPreviousTag(int pos) {
        if (this.cache.getSourceLength() == 0) {
            return null;
        }
        if (pos < 0 || pos >= this.cache.getSourceLength()) {
            return null;
        }
        int index = this.getIndexOfPos(pos);
        CacheEntry cacheEntry = this.array[index];
        if (cacheEntry.pos == pos && cacheEntry.tag != null && cacheEntry.tag.includeInSearch()) {
            return cacheEntry.tag;
        }
        Tag tag = this.getPreviousTag(this.getPrevious(cacheEntry), pos, cacheEntry);
        this.addPreviousTag(pos, tag);
        return tag;
    }

    public Tag getNextTag(int pos) {
        Tag tag;
        if (this.cache.getSourceLength() == 0) {
            return null;
        }
        if (pos < 0 || pos >= this.cache.getSourceLength()) {
            return null;
        }
        int index = this.getIndexOfPos(pos);
        CacheEntry cacheEntry = this.array[index];
        if (cacheEntry.pos == pos) {
            if (cacheEntry.tag != null && cacheEntry.tag.includeInSearch()) {
                return cacheEntry.tag;
            }
            tag = this.getNextTag(cacheEntry, pos, this.getNext(cacheEntry));
        } else {
            tag = this.getNextTag(this.getPrevious(cacheEntry), pos, cacheEntry);
        }
        this.addNextTag(pos, tag);
        return tag;
    }

    public Iterator<Tag> getTagIterator() {
        return new TagIterator();
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    protected StringBuilder appendTo(StringBuilder sb) {
        sb.append("Cache for TagType : ").append(this.tagType).append(Config.NewLine);
        for (int i = 0; i <= this.lastIndex(); ++i) {
            sb.append(this.array[i]).append(Config.NewLine);
        }
        return sb;
    }

    private Tag getPreviousTag(CacheEntry previousCacheEntry, int pos, CacheEntry nextCacheEntry) {
        while (true) {
            Tag tag;
            if (!nextCacheEntry.previousCached && (tag = Tag.getPreviousTagUncached(this.cache.source, pos, this.tagType, previousCacheEntry.pos)) != null) {
                if (!this.cache.source.useAllTypesCache) {
                    this.addTagAt(tag.begin, tag);
                }
                return tag;
            }
            if (previousCacheEntry == this.bof) {
                return null;
            }
            if (previousCacheEntry.tag != null && previousCacheEntry.tag.includeInSearch()) {
                return previousCacheEntry.tag;
            }
            pos = previousCacheEntry.pos - 1;
            nextCacheEntry = previousCacheEntry;
            previousCacheEntry = this.getPrevious(nextCacheEntry);
        }
    }

    private Tag getNextTag(CacheEntry previousCacheEntry, int pos, CacheEntry nextCacheEntry) {
        while (true) {
            Tag tag;
            if (!previousCacheEntry.nextCached && (tag = Tag.getNextTagUncached(this.cache.source, pos, this.tagType, nextCacheEntry.pos)) != null) {
                if (!this.cache.source.useAllTypesCache) {
                    this.addTagAt(tag.begin, tag);
                }
                return tag;
            }
            if (nextCacheEntry == this.eof) {
                return null;
            }
            if (nextCacheEntry.tag != null && nextCacheEntry.tag.includeInSearch()) {
                return nextCacheEntry.tag;
            }
            pos = nextCacheEntry.pos + 1;
            previousCacheEntry = nextCacheEntry;
            nextCacheEntry = this.getNext(previousCacheEntry);
        }
    }

    private void addPreviousTag(int pos, Tag tag) {
        int tagPos;
        int n = tagPos = tag == null ? this.bof.pos : tag.begin;
        if (tagPos == pos) {
            return;
        }
        int index = this.getIndexOfPos(pos);
        CacheEntry stepCacheEntry = this.array[index];
        int compactStartIndex = Integer.MAX_VALUE;
        if (stepCacheEntry.pos == pos) {
            stepCacheEntry.previousCached = true;
            if (stepCacheEntry.isRedundant()) {
                stepCacheEntry.removed = true;
                compactStartIndex = Math.min(compactStartIndex, stepCacheEntry.index);
            }
        } else if (!stepCacheEntry.previousCached) {
            if (this.tagType == null) {
                this.cache.addTagAt(pos, false);
            } else {
                this.addTagAt(pos, null);
            }
            index = this.getIndexOfPos(pos);
            stepCacheEntry = this.array[index];
            if (stepCacheEntry.pos == pos) {
                stepCacheEntry.previousCached = true;
                if (stepCacheEntry.isRedundant()) {
                    stepCacheEntry.removed = true;
                    compactStartIndex = Math.min(compactStartIndex, stepCacheEntry.index);
                }
            }
        }
        while (true) {
            stepCacheEntry = this.array[--index];
            if (stepCacheEntry.pos <= tagPos) break;
            if (stepCacheEntry.tag != null) {
                if (stepCacheEntry.tag.includeInSearch()) {
                    throw new SourceCacheEntryMissingInternalError(this.tagType, tag, this);
                }
                stepCacheEntry.previousCached = true;
                stepCacheEntry.nextCached = true;
                continue;
            }
            stepCacheEntry.removed = true;
            compactStartIndex = Math.min(compactStartIndex, stepCacheEntry.index);
        }
        if (stepCacheEntry.pos != tagPos) {
            throw new FoundCacheEntryMissingInternalError(this.tagType, tag, this);
        }
        stepCacheEntry.nextCached = true;
        this.compact(compactStartIndex);
    }

    private void addNextTag(int pos, Tag tag) {
        int tagPos;
        int n = tagPos = tag == null ? this.eof.pos : tag.begin;
        if (tagPos == pos) {
            return;
        }
        int index = this.getIndexOfPos(pos);
        CacheEntry stepCacheEntry = this.array[index];
        int compactStartIndex = Integer.MAX_VALUE;
        if (stepCacheEntry.pos == pos) {
            stepCacheEntry.nextCached = true;
            if (stepCacheEntry.isRedundant()) {
                stepCacheEntry.removed = true;
                compactStartIndex = Math.min(compactStartIndex, stepCacheEntry.index);
            }
        } else if (!this.getPrevious((CacheEntry)stepCacheEntry).nextCached) {
            if (this.tagType == null) {
                this.cache.addTagAt(pos, false);
            } else {
                this.addTagAt(pos, null);
            }
            index = this.getIndexOfPos(pos);
            stepCacheEntry = this.array[index];
            if (stepCacheEntry.pos == pos) {
                stepCacheEntry.nextCached = true;
                if (stepCacheEntry.isRedundant()) {
                    stepCacheEntry.removed = true;
                    compactStartIndex = Math.min(compactStartIndex, stepCacheEntry.index);
                }
            }
        }
        if (stepCacheEntry.pos < tagPos) {
            while (true) {
                stepCacheEntry = this.array[++index];
                if (stepCacheEntry.pos >= tagPos) break;
                if (stepCacheEntry.tag != null) {
                    if (stepCacheEntry.tag.includeInSearch()) {
                        throw new SourceCacheEntryMissingInternalError(this.tagType, tag, this);
                    }
                    stepCacheEntry.previousCached = true;
                    stepCacheEntry.nextCached = true;
                    continue;
                }
                stepCacheEntry.removed = true;
                compactStartIndex = Math.min(compactStartIndex, stepCacheEntry.index);
            }
            if (stepCacheEntry.pos != tagPos) {
                throw new FoundCacheEntryMissingInternalError(this.tagType, tag, this);
            }
        }
        stepCacheEntry.previousCached = true;
        this.compact(compactStartIndex);
    }

    private void compact(int i) {
        int lastIndex = this.lastIndex();
        int removedCount = 1;
        while (i < lastIndex) {
            CacheEntry cacheEntry = this.array[++i];
            if (cacheEntry.removed) {
                ++removedCount;
                continue;
            }
            cacheEntry.index = i - removedCount;
            this.array[cacheEntry.index] = cacheEntry;
        }
    }

    private void add(CacheEntry previousCacheEntry, CacheEntry newCacheEntry, CacheEntry nextCacheEntry) {
        if (!newCacheEntry.isRedundant()) {
            this.insert(newCacheEntry);
        }
        if (newCacheEntry.previousCached) {
            previousCacheEntry.nextCached = true;
            if (previousCacheEntry.isRedundant()) {
                this.remove(previousCacheEntry);
            }
        }
        if (newCacheEntry.nextCached) {
            nextCacheEntry.previousCached = true;
            if (nextCacheEntry.isRedundant()) {
                this.remove(nextCacheEntry);
            }
        }
    }

    private int getIndexOfPos(int pos) {
        int minIndex = 0;
        int maxIndex = this.lastIndex();
        int index = maxIndex >> 1;
        while (true) {
            CacheEntry cacheEntry = this.array[index];
            if (pos > cacheEntry.pos) {
                CacheEntry nextCacheEntry = this.getNext(cacheEntry);
                if (pos <= nextCacheEntry.pos) {
                    return nextCacheEntry.index;
                }
                minIndex = nextCacheEntry.index;
            } else if (pos < cacheEntry.pos) {
                CacheEntry previousCacheEntry = this.getPrevious(cacheEntry);
                if (pos == previousCacheEntry.pos) {
                    return previousCacheEntry.index;
                }
                if (pos > previousCacheEntry.pos) {
                    return index;
                }
                maxIndex = previousCacheEntry.index;
            } else {
                return index;
            }
            index = minIndex + maxIndex >> 1;
        }
    }

    private CacheEntry getNext(CacheEntry cacheEntry) {
        return this.array[cacheEntry.index + 1];
    }

    private CacheEntry getPrevious(CacheEntry cacheEntry) {
        return this.array[cacheEntry.index - 1];
    }

    private int lastIndex() {
        return this.eof.index;
    }

    private void insert(CacheEntry cacheEntry) {
        int index = cacheEntry.index;
        if (this.array.length == this.size()) {
            this.doubleCapacity();
        }
        for (int i = this.lastIndex(); i >= index; --i) {
            CacheEntry movedCacheEntry = this.array[i];
            movedCacheEntry.index = i + 1;
            this.array[movedCacheEntry.index] = movedCacheEntry;
        }
        this.array[index] = cacheEntry;
    }

    private void remove(CacheEntry cacheEntry) {
        int lastIndex = this.lastIndex();
        int i = cacheEntry.index;
        while (i < lastIndex) {
            CacheEntry movedCacheEntry = this.array[i + 1];
            movedCacheEntry.index = i++;
            this.array[movedCacheEntry.index] = movedCacheEntry;
        }
    }

    private void doubleCapacity() {
        CacheEntry[] newArray = new CacheEntry[this.array.length << 1];
        for (int i = this.lastIndex(); i >= 0; --i) {
            newArray[i] = this.array[i];
        }
        this.array = newArray;
    }

    private static final class CacheEntry {
        public int index;
        public final int pos;
        public final Tag tag;
        public boolean previousCached;
        public boolean nextCached;
        public boolean removed = false;

        public CacheEntry(int index, int pos, Tag tag, boolean previousCached, boolean nextCached) {
            this.index = index;
            this.pos = pos;
            this.tag = tag;
            this.previousCached = previousCached;
            this.nextCached = nextCached;
        }

        public boolean isRedundant() {
            return this.tag == null && this.previousCached && this.nextCached;
        }

        public String toString() {
            return this.pad(this.index, 4) + " " + this.pad(this.pos, 5) + " " + (this.previousCached ? (char)'|' : '-') + ' ' + (this.nextCached ? (char)'|' : '-') + ' ' + (this.tag == null ? "null" : this.tag.getDebugInfo());
        }

        private String pad(int n, int places) {
            String nstring = String.valueOf(n);
            StringBuilder sb = new StringBuilder(places);
            for (int i = places - nstring.length(); i > 0; --i) {
                sb.append(' ');
            }
            sb.append(nstring);
            return sb.toString();
        }
    }

    private final class TagIterator
    implements Iterator<Tag> {
        private int i = 0;
        private Tag nextTag;

        public TagIterator() {
            this.loadNextTag();
        }

        @Override
        public boolean hasNext() {
            return this.nextTag != null;
        }

        @Override
        public Tag next() {
            Tag result = this.nextTag;
            this.loadNextTag();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void loadNextTag() {
            while (++this.i <= SubCache.this.lastIndex() && (this.nextTag = ((SubCache)SubCache.this).array[this.i].tag) == null) {
            }
        }
    }

    private static class FoundCacheEntryMissingInternalError
    extends CacheEntryMissingInternalError {
        public FoundCacheEntryMissingInternalError(TagType tagType, Tag tag, SubCache subCache) {
            super(tagType, tag, subCache, "missing cache entry for found tag");
        }
    }

    private static class SourceCacheEntryMissingInternalError
    extends CacheEntryMissingInternalError {
        public SourceCacheEntryMissingInternalError(TagType tagType, Tag tag, SubCache subCache) {
            super(tagType, tag, subCache, "cache entry no longer found in source:");
        }
    }

    private static class CacheEntryMissingInternalError
    extends AssertionError {
        public CacheEntryMissingInternalError(TagType tagType, Tag tag, SubCache subCache, String message) {
            super((Object)("INTERNAL ERROR: Inconsistent Cache State for TagType \"" + tagType + "\" - " + message + ' ' + tag.getDebugInfo() + '\n' + subCache));
        }
    }
}

