/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.EndTagType;
import net.htmlparser.jericho.ParseText;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.Tag;

public class StartTagTypeGenericImplementation
extends StartTagType {
    final boolean nameCharAfterPrefixAllowed = this.getNamePrefix().length() == 0 || !Character.isLetter(this.getNamePrefix().charAt(this.getNamePrefix().length() - 1));

    protected StartTagTypeGenericImplementation(String description, String startDelimiter, String closingDelimiter, EndTagType correspondingEndTagType, boolean isServerTag) {
        this(description, startDelimiter, closingDelimiter, correspondingEndTagType, isServerTag, false, false);
    }

    protected StartTagTypeGenericImplementation(String description, String startDelimiter, String closingDelimiter, EndTagType correspondingEndTagType, boolean isServerTag, boolean hasAttributes, boolean isNameAfterPrefixRequired) {
        super(description, startDelimiter, closingDelimiter, correspondingEndTagType, isServerTag, hasAttributes, isNameAfterPrefixRequired);
    }

    @Override
    protected Tag constructTagAt(Source source, int pos) {
        int end;
        ParseText parseText = source.getParseText();
        int nameBegin = pos + 1;
        String name = this.getNamePrefix();
        int nameEnd = nameBegin + this.getNamePrefix().length();
        if (this.isNameAfterPrefixRequired()) {
            int extendedNameEnd = source.getNameEnd(nameEnd);
            if (extendedNameEnd == -1) {
                return null;
            }
            name = source.getName(nameBegin, extendedNameEnd);
            nameEnd = extendedNameEnd;
        } else if (!this.nameCharAfterPrefixAllowed && Tag.isXMLNameChar(parseText.charAt(nameEnd))) {
            return null;
        }
        Attributes attributes = null;
        if (this.hasAttributes()) {
            attributes = this.parseAttributes(source, pos, name);
            if (attributes == null) {
                return null;
            }
            end = this.getEnd(source, attributes.getEnd());
        } else {
            end = this.getEnd(source, nameEnd);
            if (end < 0) {
                if (end == -1 && source.logger.isErrorEnabled()) {
                    source.logger.error(source.getRowColumnVector(pos).appendTo(new StringBuilder(200).append("StartTag ").append(name).append(" at ")).append(" not recognised as type '").append(this.getDescription()).append("' because it has no closing delimiter").toString());
                }
                return null;
            }
        }
        return this.constructStartTag(source, pos, end, name, attributes);
    }

    protected int getEnd(Source source, int pos) {
        int delimiterBegin = source.getParseText().indexOf(this.getClosingDelimiter(), pos);
        return delimiterBegin == -1 ? -1 : delimiterBegin + this.getClosingDelimiter().length();
    }
}

