/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.OutputSegment;

class AttributesOutputSegment
implements OutputSegment {
    private final int begin;
    private final int end;
    private final Map<String, String> map;

    public AttributesOutputSegment(Attributes attributes, boolean convertNamesToLowerCase) {
        this(attributes, attributes.getMap(convertNamesToLowerCase));
    }

    public AttributesOutputSegment(Attributes attributes, Map<String, String> map) {
        if (map == null || attributes == null) {
            throw new IllegalArgumentException("both arguments must be non-null");
        }
        this.begin = attributes.getBegin();
        this.end = attributes.getEnd();
        this.map = map;
    }

    @Override
    public int getBegin() {
        return this.begin;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    public Map<String, String> getMap() {
        return this.map;
    }

    @Override
    public void writeTo(Writer writer) throws IOException {
        Attributes.appendHTML(writer, this.map);
    }

    @Override
    public void appendTo(Appendable appendable) throws IOException {
        Attributes.appendHTML(appendable, this.map);
    }

    @Override
    public long getEstimatedMaximumOutputLength() {
        return (this.end - this.begin) * 2;
    }

    @Override
    public String toString() {
        return Attributes.generateHTML(this.map);
    }

    @Override
    public String getDebugInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("(p").append(this.begin).append("-p").append(this.end).append("):");
        try {
            this.appendTo(sb);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return sb.toString();
    }
}

