/*
 * Decompiled with CFR 0.152.
 */
package de.innosystec.unrar.unpack.ppm;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class AnalyzeHeapDump {
    public static void main(String[] argv) {
        long jlen;
        File cfile = new File("P:\\test\\heapdumpc");
        File jfile = new File("P:\\test\\heapdumpj");
        if (!cfile.exists()) {
            System.err.println("File not found: " + cfile.getAbsolutePath());
            return;
        }
        if (!jfile.exists()) {
            System.err.println("File not found: " + jfile.getAbsolutePath());
            return;
        }
        long clen = cfile.length();
        if (clen != (jlen = jfile.length())) {
            System.out.println("File size mismatch");
            System.out.println("clen = " + clen);
            System.out.println("jlen = " + jlen);
        }
        long len = Math.min(clen, jlen);
        InputStream cin = null;
        InputStream jin = null;
        int bufferLen = 262144;
        try {
            try {
                cin = new BufferedInputStream(new FileInputStream(cfile), bufferLen);
                jin = new BufferedInputStream(new FileInputStream(jfile), bufferLen);
                boolean matching = true;
                boolean mismatchFound = false;
                long startOff = 0L;
                long off = 0L;
                while (off < len) {
                    if (cin.read() != jin.read()) {
                        if (matching) {
                            startOff = off;
                            matching = false;
                            mismatchFound = true;
                        }
                    } else if (!matching) {
                        AnalyzeHeapDump.printMismatch(startOff, off);
                        matching = true;
                    }
                    ++off;
                }
                if (!matching) {
                    AnalyzeHeapDump.printMismatch(startOff, off);
                }
                if (!mismatchFound) {
                    System.out.println("Files are identical");
                }
                System.out.println("Done");
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    cin.close();
                    jin.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                cin.close();
                jin.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void printMismatch(long startOff, long bytesRead) {
        System.out.println("Mismatch: off=" + startOff + "(0x" + Long.toHexString(startOff) + "), len=" + (bytesRead - startOff));
    }
}

