/*
 * Decompiled with CFR 0.152.
 */
package de.innosystec.unrar.rarfile;

import de.innosystec.unrar.io.Raw;
import de.innosystec.unrar.rarfile.BaseBlock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlockHeader
extends BaseBlock {
    public static final short blockHeaderSize = 4;
    private Log logger = LogFactory.getLog((String)BlockHeader.class.getName());
    private int dataSize;
    private int packSize;

    public BlockHeader() {
    }

    public BlockHeader(BlockHeader bh) {
        super(bh);
        this.dataSize = this.packSize = bh.getDataSize();
        this.positionInFile = bh.getPositionInFile();
    }

    public BlockHeader(BaseBlock bb, byte[] blockHeader) {
        super(bb);
        this.dataSize = this.packSize = Raw.readIntLittleEndian(blockHeader, 0);
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public int getPackSize() {
        return this.packSize;
    }

    public void print() {
        super.print();
        String s = "DataSize: " + this.getDataSize() + " packSize: " + this.getPackSize();
        this.logger.info((Object)s);
    }
}

