/*
 * Decompiled with CFR 0.152.
 */
package de.innosystec.unrar.crc;

public class RarCRC {
    private static final int[] crcTab = new int[256];

    static {
        int i = 0;
        while (i < 256) {
            int c = i;
            int j = 0;
            while (j < 8) {
                if ((c & 1) != 0) {
                    c >>>= 1;
                    c ^= 0xEDB88320;
                } else {
                    c >>>= 1;
                }
                ++j;
            }
            RarCRC.crcTab[i] = c;
            ++i;
        }
    }

    private RarCRC() {
    }

    public static int checkCrc(int startCrc, byte[] data, int offset, int count) {
        int size = Math.min(data.length - offset, count);
        int i = 0;
        while (i < size) {
            startCrc = crcTab[(startCrc ^ data[offset + i]) & 0xFF] ^ startCrc >>> 8;
            ++i;
        }
        return startCrc;
    }

    public static short checkOldCrc(short startCrc, byte[] data, int count) {
        int n = Math.min(data.length, count);
        int i = 0;
        while (i < n) {
            startCrc = (short)((short)(startCrc + (short)(data[i] & 0xFF)) & 0xFFFFFFFF);
            startCrc = (short)((startCrc << 1 | startCrc >>> 15) & 0xFFFFFFFF);
            ++i;
        }
        return startCrc;
    }
}

