/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.recognition.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.ansj.domain.AnsjItem;
import org.ansj.domain.Result;
import org.ansj.domain.Term;
import org.ansj.domain.TermNature;
import org.ansj.domain.TermNatures;
import org.ansj.library.DATDictionary;
import org.ansj.library.DicLibrary;
import org.ansj.recognition.Recognition;
import org.ansj.recognition.arrimpl.ForeignPersonRecognition;
import org.ansj.splitWord.analysis.ToAnalysis;
import org.ansj.util.MathUtil;
import org.ansj.util.MyStaticValue;
import org.nlpcn.commons.lang.tire.domain.Forest;
import org.nlpcn.commons.lang.util.WordAlert;
import org.nlpcn.commons.lang.util.logging.Log;
import org.nlpcn.commons.lang.util.logging.LogFactory;

public class NatureRecognition
implements Recognition {
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getLog();
    private static final Forest SUFFIX_FOREST = new Forest();
    private Forest[] forests = null;
    private NatureTerm root = new NatureTerm(TermNature.BEGIN);
    private NatureTerm[] end = new NatureTerm[]{new NatureTerm(TermNature.END)};
    private List<Term> terms = null;
    private NatureTerm[][] natureTermTable = null;

    public NatureRecognition() {
        this.forests = new Forest[]{DicLibrary.get()};
    }

    public NatureRecognition(Forest ... forests) {
        this.forests = forests;
    }

    @Override
    public void recognition(Result result) {
        this.terms = result.getTerms();
        this.natureTermTable = new NatureTerm[this.terms.size() + 1][];
        this.natureTermTable[this.terms.size()] = this.end;
        int length = this.terms.size();
        for (int i = 0; i < length; ++i) {
            this.natureTermTable[i] = this.getNatureTermArr(this.terms.get((int)i).termNatures().termNatures);
        }
        this.walk();
    }

    public List<Term> recognition(List<String> words) {
        return this.recognition(words, 0);
    }

    public List<Term> recognition(List<String> words, int offe) {
        ArrayList<Term> terms = new ArrayList<Term>(words.size());
        int tempOffe = 0;
        for (String word : words) {
            TermNatures tn = this.getTermNatures(word);
            terms.add(new Term(word, offe + tempOffe, tn));
            tempOffe += word.length();
        }
        new NatureRecognition().recognition(new Result(terms));
        return terms;
    }

    public TermNatures getTermNatures(String word) {
        String[] params = null;
        AnsjItem ansjItem = DATDictionary.getItem(word);
        TermNatures tn = null;
        tn = ansjItem != AnsjItem.NULL ? ansjItem.termNatures : ((params = this.getParams(word)) != null ? new TermNatures(new TermNature(params[0], 1)) : (WordAlert.isEnglish((String)word) ? TermNatures.EN : (WordAlert.isNumber((String)word) ? TermNatures.M : TermNatures.NULL)));
        return tn;
    }

    public String[] getParams(String word) {
        for (Forest forest : this.forests) {
            if (forest == null) continue;
            Forest sf = forest;
            for (int i = 0; i < word.length(); ++i) {
                if ((sf = sf.get(word.charAt(i))) != null) continue;
                return null;
            }
            if (sf.getStatus() > 1) {
                return (String[])sf.getParam();
            }
            return null;
        }
        return null;
    }

    public static TermNatures guessNature(String word) {
        String nature = null;
        Forest smartForest = SUFFIX_FOREST;
        int len = 0;
        for (int i = word.length() - 1; i >= 0 && (smartForest = smartForest.get(word.charAt(i))) != null; --i) {
            ++len;
            if (smartForest.getStatus() == 2) {
                nature = ((String[])smartForest.getParam())[0];
                continue;
            }
            if (smartForest.getStatus() != 3) continue;
            nature = ((String[])smartForest.getParam())[0];
            break;
        }
        if ("nt".equals(nature) && (len > 1 || word.length() > 3)) {
            return TermNatures.NT;
        }
        if ("ns".equals(nature)) {
            return TermNatures.NS;
        }
        if (word.length() < 5) {
            Result parse = ToAnalysis.parse(word);
            for (Term term : parse.getTerms()) {
                if (!"nr".equals(term.getNatureStr())) continue;
                return TermNatures.NR;
            }
        } else if (ForeignPersonRecognition.isFName(word)) {
            return TermNatures.NRF;
        }
        return TermNatures.NW;
    }

    public void walk() {
        int length = this.natureTermTable.length - 1;
        this.setScore(this.root, this.natureTermTable[0]);
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this.natureTermTable[i].length; ++j) {
                this.setScore(this.natureTermTable[i][j], this.natureTermTable[i + 1]);
            }
        }
        this.optimalRoot();
    }

    private void setScore(NatureTerm natureTerm, NatureTerm[] natureTerms) {
        for (int i = 0; i < natureTerms.length; ++i) {
            natureTerms[i].setScore(natureTerm);
        }
    }

    private NatureTerm[] getNatureTermArr(TermNature[] termNatures) {
        NatureTerm[] natureTerms = new NatureTerm[termNatures.length];
        for (int i = 0; i < natureTerms.length; ++i) {
            natureTerms[i] = new NatureTerm(termNatures[i]);
        }
        return natureTerms;
    }

    private void optimalRoot() {
        NatureTerm to = this.end[0];
        NatureTerm from = null;
        int index = this.natureTermTable.length - 1;
        while ((from = to.from) != null && index > 0) {
            this.terms.get(--index).setNature(from.termNature.nature);
            to = from;
        }
    }

    static {
        try {
            BufferedReader reader = MyStaticValue.getNatureClassSuffix();
            Throwable throwable = null;
            try {
                String temp = null;
                while ((temp = reader.readLine()) != null) {
                    String[] split = temp.split("\t");
                    String word = split[0];
                    if (word.length() > 1) {
                        word = new StringBuffer(word).reverse().toString();
                    }
                    SUFFIX_FOREST.add(word, (Object)new String[]{split[1]});
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (IOException e) {
            logger.warn("IO\u5f02\u5e38", (Throwable)e);
        }
    }

    public class NatureTerm {
        public TermNature termNature;
        public double score = 0.0;
        public double selfScore;
        public NatureTerm from;

        protected NatureTerm(TermNature termNature) {
            this.termNature = termNature;
            this.selfScore = termNature.frequency + 1;
        }

        public void setScore(NatureTerm natureTerm) {
            double tempScore = MathUtil.compuNatureFreq(natureTerm, this);
            if (this.from == null || this.score < tempScore) {
                this.score = tempScore;
                this.from = natureTerm;
            }
        }

        public String toString() {
            return this.termNature.nature.natureStr + "/" + this.selfScore;
        }
    }
}

