/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.library;

import java.io.BufferedReader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ansj.dic.PathToStream;
import org.ansj.domain.KV;
import org.ansj.util.MyStaticValue;
import org.nlpcn.commons.lang.tire.domain.SmartForest;
import org.nlpcn.commons.lang.util.IOUtil;
import org.nlpcn.commons.lang.util.StringUtil;
import org.nlpcn.commons.lang.util.logging.Log;

public class SynonymsLibrary {
    private static final Log LOG = MyStaticValue.getLog(SynonymsLibrary.class);
    private static final Map<String, KV<String, SmartForest<List<String>>>> SYNONYMS = new HashMap<String, KV<String, SmartForest<List<String>>>>();
    public static final String DEFAULT = "synonyms";

    public static SmartForest<List<String>> get() {
        return SynonymsLibrary.get(DEFAULT);
    }

    public static SmartForest<List<String>> get(String key) {
        KV<String, SmartForest<List<String>>> kv = SYNONYMS.get(key);
        if (kv == null) {
            if (MyStaticValue.ENV.containsKey(key)) {
                SynonymsLibrary.putIfAbsent(key, MyStaticValue.ENV.get(key));
                return SynonymsLibrary.get(key);
            }
            LOG.warn("crf " + key + " not found in config ");
            return null;
        }
        SmartForest<List<String>> sw = kv.getV();
        if (sw == null) {
            sw = SynonymsLibrary.init(key, kv);
        }
        return sw;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static synchronized SmartForest<List<String>> init(String key, KV<String, SmartForest<List<String>>> kv) {
        SmartForest forest = kv.getV();
        if (forest != null) {
            return forest;
        }
        forest = new SmartForest();
        LOG.debug("begin init synonyms " + kv.getK());
        long start = System.currentTimeMillis();
        try {
            BufferedReader reader = IOUtil.getReader((InputStream)PathToStream.stream(kv.getK()), (String)"utf-8");
            Throwable throwable = null;
            try {
                String temp = null;
                while ((temp = reader.readLine()) != null) {
                    if (StringUtil.isBlank((CharSequence)temp)) continue;
                    String[] split = temp.split("\t");
                    ArrayList<String> list = new ArrayList<String>();
                    for (String word : split) {
                        if (StringUtil.isBlank((CharSequence)word)) continue;
                        list.add(word);
                    }
                    if (split.length <= 1) {
                        LOG.warn(temp + " in synonymsLibrary not in to library !");
                        continue;
                    }
                    for (int i = 0; i < split.length; ++i) {
                        forest.add(split[i], list);
                    }
                }
                kv.setV((SmartForest<List<String>>)forest);
                LOG.info("load synonyms use time:" + (System.currentTimeMillis() - start) + " path is : " + kv.getK());
                SmartForest smartForest = forest;
                return smartForest;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error("Init synonyms library error :" + e.getMessage() + ", path: " + kv.getK());
            SYNONYMS.remove(key);
            return null;
        }
    }

    public static void put(String key, String path) {
        SynonymsLibrary.put(key, path, null);
    }

    public static void put(String key, String path, SmartForest<List<String>> value) {
        SYNONYMS.put(key, KV.with(path, value));
    }

    public static KV<String, SmartForest<List<String>>> remove(String key) {
        return SYNONYMS.remove(key);
    }

    public static void reload(String key) {
        KV<String, SmartForest<List<String>>> kv = SYNONYMS.get(key);
        if (kv != null) {
            SYNONYMS.get(key).setV(null);
        }
    }

    public static Set<String> keys() {
        return SYNONYMS.keySet();
    }

    public static void putIfAbsent(String key, String path) {
        if (!SYNONYMS.containsKey(key)) {
            SYNONYMS.put(key, KV.with(path, null));
        }
    }

    public static void insert(String key, String[] words) {
        SmartForest<List<String>> synonyms = SynonymsLibrary.get(key);
        ArrayList<String> list = new ArrayList<String>();
        for (String word : words) {
            if (StringUtil.isBlank((CharSequence)word)) continue;
            list.add(word);
        }
        if (list.size() <= 1) {
            LOG.warn(Arrays.toString(words) + " not have any change because it less than 2 word");
            return;
        }
        Set<String> set = SynonymsLibrary.findAllWords(key, words);
        for (String word : list) {
            set.remove(word);
            synonyms.add(word, list);
        }
        for (String word : set) {
            synonyms.remove(word);
            synonyms.getBranch(word).setParam(null);
        }
    }

    private static Set<String> findAllWords(String key, String[] words) {
        SmartForest<List<String>> synonyms = SynonymsLibrary.get(key);
        HashSet<String> set = new HashSet<String>();
        for (String word : words) {
            List params;
            SmartForest branch = synonyms.getBranch(word);
            if (branch == null || (params = (List)branch.getParam()) == null) continue;
            set.addAll(params);
        }
        return set;
    }

    public static void append(String key, String[] words) {
        SmartForest<List<String>> synonyms = SynonymsLibrary.get(key);
        HashSet<String> set = new HashSet<String>();
        for (String word : words) {
            if (StringUtil.isBlank((CharSequence)word)) continue;
            set.add(word);
        }
        if (set.size() <= 1) {
            LOG.warn(Arrays.toString(words) + " not have any change because it less than 2 word");
            return;
        }
        set.addAll(SynonymsLibrary.findAllWords(key, words));
        ArrayList list = new ArrayList(set);
        for (String word : list) {
            synonyms.addBranch(word, list);
        }
    }

    public static void remove(String key, String word) {
        SmartForest<List<String>> synonyms = SynonymsLibrary.get(key);
        SmartForest branch = synonyms.getBranch(word);
        if (branch == null || branch.getStatus() < 2) {
            return;
        }
        List params = (List)branch.getParam();
        synonyms.remove(word);
        branch.setParam(null);
        params.remove(word);
        if (params.size() == 1) {
            synonyms.remove((String)params.get(0));
            params.remove(0);
        } else {
            params.remove(word);
        }
    }

    static {
        for (Map.Entry<String, String> entry : MyStaticValue.ENV.entrySet()) {
            if (!entry.getKey().startsWith(DEFAULT)) continue;
            SynonymsLibrary.put(entry.getKey(), entry.getValue());
        }
        SynonymsLibrary.putIfAbsent(DEFAULT, "library/synonyms.dic");
    }
}

