/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.motif;

import java.util.ArrayList;
import java.util.Collections;
import org.snpeff.motif.BaseSize;
import org.snpeff.motif.Pwm;
import org.snpeff.snpEffect.EffectType;

public class MotifLogo {
    static final int FAKE_COUNT_BASE = 1;
    static final int FAKE_COUNT_TOTAL = 4;
    static final double LOG2 = Math.log(2.0);
    Pwm pwm;

    public static double log2(double p) {
        return Math.log(p) / LOG2;
    }

    public MotifLogo(Pwm pwm) {
        this.pwm = pwm;
    }

    double baseFrecuency(char base, int position) {
        int total = this.sumCount(position);
        int count2 = this.pwm.getCount(base, position);
        return (double)(++count2) / (double)(total += 4);
    }

    double seqConserv(int position) {
        double sMax = 2.0;
        double sObs = 0.0;
        for (char base : Pwm.BASES) {
            double p = this.baseFrecuency(base, position);
            sObs += -p * MotifLogo.log2(p);
        }
        return (sMax - sObs) / sMax;
    }

    int sumCount(int position) {
        int total = 0;
        for (char b : Pwm.BASES) {
            total += this.pwm.getCount(b, position);
        }
        return total;
    }

    public String toStringHtml(int width, int maxHeight, EffectType efectType) {
        StringBuffer sb = new StringBuffer();
        sb.append("<table border=0>\n\t</tr>\n");
        for (int pos = 0; pos < this.pwm.size(); ++pos) {
            double seqConserv = this.seqConserv(pos);
            ArrayList<BaseSize> bases = new ArrayList<BaseSize>();
            for (char base : Pwm.BASES) {
                double p = this.baseFrecuency(base, pos);
                double size2 = seqConserv * p;
                BaseSize baseSize = new BaseSize(base, size2);
                bases.add(baseSize);
            }
            Collections.sort(bases, Collections.reverseOrder());
            int ppos = pos - this.pwm.size() / 2;
            String bgcolor = "";
            if (efectType == EffectType.SPLICE_SITE_DONOR && ppos <= 0) {
                bgcolor = "bgcolor=#cccccc";
            }
            if (efectType == EffectType.SPLICE_SITE_ACCEPTOR && ppos >= 0) {
                bgcolor = "bgcolor=#cccccc";
            }
            sb.append("\t\t<td valign=bottom " + bgcolor + ">\n\t\t\t<center>\n");
            for (BaseSize baseSize : bases) {
                int height = (int)((double)maxHeight * baseSize.size);
                sb.append("\t\t\t<img border=0 src=\"" + baseSize.base + ".png\" width=" + width + " height=" + height + "\"><br>\n");
            }
            sb.append("\t\t\t" + ppos + "<br>\n\t\t\t</center>\n");
            sb.append("\t\t</td>\n");
        }
        sb.append("\t</tr>\n</table>\n");
        return sb.toString();
    }
}

