/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.genBank;

import org.snpeff.fileIterator.LineFileIterator;
import org.snpeff.genBank.Features;

public class Embl
extends Features {
    public static final int FEATURE_NAME_LEN = 15;
    public static final int FEATURE_KEY_LEN = 5;

    public Embl(LineFileIterator lineFileIterator) {
        super(lineFileIterator);
    }

    public Embl(String fileName) {
        super(fileName);
    }

    @Override
    protected boolean isNewFeature(String line) {
        return !line.substring(0, 15).trim().isEmpty();
    }

    protected void parseFieldLine(String fkey, String valueOri, int fieldLineNum) {
        String value2 = valueOri.trim();
        if (!fkey.equals("XX")) {
            if (fkey.equals("ID")) {
                String[] subfields = value2.split("[;\\s]");
                this.locusName = subfields[0];
                if (subfields.length > 1) {
                    this.shape = subfields[1];
                }
                if (subfields.length > 2) {
                    this.moleculeType = subfields[2];
                }
            } else if (fkey.equals("DT")) {
                this.date = value2;
            } else if (fkey.equals("DT")) {
                this.date = value2;
            } else if (fkey.equals("DE")) {
                this.definition = this.definition + value2;
            } else if (fkey.equals("AC")) {
                this.accession = this.accession + value2;
            } else if (fkey.equals("KW")) {
                this.keywords = this.keywords + value2;
            } else if (fkey.equals("SQ")) {
                value2 = value2.replaceAll("\\s", "");
                if ((value2 = value2.replaceAll("\\d", "")).replaceAll("[acgtnACGTN]", "").isEmpty()) {
                    this.sequence.append(value2);
                } else if (this.sequence.length() > 0) {
                    System.err.println("Warning: Improper sequence value ignored:\n\t'" + valueOri + "'");
                }
            } else if (fkey.equals("OS") | fkey.equals("OC")) {
                this.organism = this.organism + value2;
            } else if (fkey.equals("FT")) {
                if (this.featuresStartLine < 0) {
                    this.featuresStartLine = fieldLineNum;
                }
                this.featuresStr.append(valueOri + "\n");
            } else if (!fkey.equals("//")) {
                if (fkey.startsWith("R")) {
                    if (fkey.equals("RN")) {
                        this.references.add(new StringBuffer());
                    }
                    ((StringBuffer)this.references.get(this.references.size() - 1)).append(value2 + "\n");
                } else if (!(fkey.equals("FH") | fkey.equals("PR") | fkey.equals("DR") | fkey.equals("CC") | fkey.equals("AH") | fkey.equals("AS") | fkey.equals("SQ"))) {
                    System.err.println("Unknown feature '" + fkey + "'");
                }
            }
        }
    }

    @Override
    public void readFile() {
        String fkeyPrev = "";
        for (String line : this.lineFileIterator) {
            if (line.equals("//")) break;
            String fkey = "";
            String value2 = "";
            if (line.length() < 5) {
                fkey = line;
            } else {
                fkey = line.substring(0, 5).trim();
                if (fkey.isEmpty()) {
                    fkey = fkeyPrev;
                }
                value2 = line.substring(5);
            }
            this.parseFieldLine(fkey, value2, this.lineFileIterator.getLineNum());
            fkeyPrev = fkey;
        }
        this.parseFeatures();
    }
}

