/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.akka.vcf;

import akka.actor.Props;
import org.snpeff.akka.Master;
import org.snpeff.akka.msg.StartMaster;
import org.snpeff.akka.vcf.StartMasterVcf;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.vcf.VcfEntry;

public class MasterVcf<T>
extends Master<VcfEntry, T> {
    protected boolean parseNow = true;
    protected boolean showHeader = true;
    protected String[] addHeader;
    protected VcfFileIterator vcfFileIterator;

    public MasterVcf(Props props, int numWorkers) {
        super(props, numWorkers);
    }

    @Override
    public boolean hasNext() {
        return this.vcfFileIterator.hasNext();
    }

    @Override
    public VcfEntry next() {
        return (VcfEntry)this.vcfFileIterator.next();
    }

    public void setAddHeader(String[] addHeader) {
        this.addHeader = addHeader;
    }

    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
    }

    @Override
    protected void startMaster(StartMaster startMaster) {
        try {
            super.startMaster(startMaster);
            StartMasterVcf startMasterVcf = (StartMasterVcf)startMaster;
            this.vcfFileIterator = new VcfFileIterator(startMasterVcf.vcfFileName, startMasterVcf.config.getGenome());
            this.vcfFileIterator.setParseNow(this.parseNow);
            if (this.showHeader) {
                String headerStr;
                this.vcfFileIterator.readHeader();
                if (this.addHeader != null) {
                    for (String add2 : this.addHeader) {
                        this.vcfFileIterator.getVcfHeader().addLine(add2);
                    }
                }
                if (!(headerStr = this.vcfFileIterator.getVcfHeader().toString()).isEmpty()) {
                    System.out.println(headerStr);
                }
            }
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            this.shutdown();
        }
    }
}

