/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.quaternary.io;

import java.util.List;
import org.biojava.bio.structure.PDBHeader;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureTools;
import org.biojava.bio.structure.align.util.AtomCache;
import org.biojava.bio.structure.io.FileParsingParameters;
import org.biojava.bio.structure.quaternary.ModelTransformationMatrix;
import org.biojava.bio.structure.quaternary.io.BioUnitDataProvider;
import org.biojava3.core.util.SoftHashMap;

public class PDBBioUnitDataProvider
implements BioUnitDataProvider {
    SoftHashMap<String, PDBHeader> headerCache = new SoftHashMap(0);
    Structure s = null;
    AtomCache cache = new AtomCache();

    public PDBHeader loadPDB(String pdbId) {
        FileParsingParameters params = null;
        if (this.cache == null) {
            this.cache = new AtomCache();
        }
        if ((params = this.cache.getFileParsingParams()) == null) {
            params = new FileParsingParameters();
        }
        params.setParseBioAssembly(true);
        params.setAlignSeqRes(true);
        PDBHeader header = null;
        try {
            this.s = this.cache.getStructure(pdbId);
            header = this.s.getPDBHeader();
            this.headerCache.put(this.s.getPDBCode(), header);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return header;
    }

    @Override
    public Structure getAsymUnit(String pdbId) {
        if (this.s == null || !this.s.getPDBCode().equalsIgnoreCase(pdbId)) {
            this.loadPDB(pdbId);
        }
        if (this.s.nrModels() > 1) {
            boolean isNMR = this.s.isNmr();
            this.s.setNmr(true);
            this.s = StructureTools.removeModels(this.s);
            this.s.setNmr(isNMR);
        }
        return this.s;
    }

    @Override
    public void setAsymUnit(Structure s) {
        this.s = s;
    }

    @Override
    public List<ModelTransformationMatrix> getBioUnitTransformationList(String pdbId, int biolAssemblyNr) {
        PDBHeader header = this.headerCache.get(pdbId);
        if (header == null) {
            header = this.loadPDB(pdbId);
        }
        return header.getBioUnitTranformationMap().get(biolAssemblyNr);
    }

    @Override
    public int getNrBiolAssemblies(String pdbId) {
        PDBHeader header = this.headerCache.get(pdbId);
        if (header == null) {
            header = this.loadPDB(pdbId);
        }
        return header.getNrBioAssemblies();
    }

    @Override
    public boolean hasBiolAssembly(String pdbId) {
        PDBHeader header = this.headerCache.get(pdbId);
        if (header == null) {
            header = this.loadPDB(pdbId);
        }
        return header.getNrBioAssemblies() > 0;
    }

    @Override
    public void setAtomCache(AtomCache cache) {
        this.cache = cache;
    }

    @Override
    public AtomCache getAtomCache() {
        return this.cache;
    }
}

