/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io.mmcif;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.biojava.bio.structure.AminoAcidImpl;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.AtomImpl;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.ChainImpl;
import org.biojava.bio.structure.Compound;
import org.biojava.bio.structure.DBRef;
import org.biojava.bio.structure.Element;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.HetatomImpl;
import org.biojava.bio.structure.NucleotideImpl;
import org.biojava.bio.structure.PDBHeader;
import org.biojava.bio.structure.ResidueNumber;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.StructureImpl;
import org.biojava.bio.structure.StructureTools;
import org.biojava.bio.structure.UnknownPdbAminoAcidException;
import org.biojava.bio.structure.io.FileParsingParameters;
import org.biojava.bio.structure.io.PDBParseException;
import org.biojava.bio.structure.io.SeqRes2AtomAligner;
import org.biojava.bio.structure.io.mmcif.ChemCompGroupFactory;
import org.biojava.bio.structure.io.mmcif.MMcifConsumer;
import org.biojava.bio.structure.io.mmcif.model.AtomSite;
import org.biojava.bio.structure.io.mmcif.model.AuditAuthor;
import org.biojava.bio.structure.io.mmcif.model.ChemComp;
import org.biojava.bio.structure.io.mmcif.model.ChemCompAtom;
import org.biojava.bio.structure.io.mmcif.model.ChemCompBond;
import org.biojava.bio.structure.io.mmcif.model.ChemCompDescriptor;
import org.biojava.bio.structure.io.mmcif.model.DatabasePDBremark;
import org.biojava.bio.structure.io.mmcif.model.DatabasePDBrev;
import org.biojava.bio.structure.io.mmcif.model.Entity;
import org.biojava.bio.structure.io.mmcif.model.EntityPolySeq;
import org.biojava.bio.structure.io.mmcif.model.EntitySrcGen;
import org.biojava.bio.structure.io.mmcif.model.EntitySrcNat;
import org.biojava.bio.structure.io.mmcif.model.EntitySrcSyn;
import org.biojava.bio.structure.io.mmcif.model.Exptl;
import org.biojava.bio.structure.io.mmcif.model.PdbxChemCompDescriptor;
import org.biojava.bio.structure.io.mmcif.model.PdbxChemCompIdentifier;
import org.biojava.bio.structure.io.mmcif.model.PdbxEntityNonPoly;
import org.biojava.bio.structure.io.mmcif.model.PdbxNonPolyScheme;
import org.biojava.bio.structure.io.mmcif.model.PdbxPolySeqScheme;
import org.biojava.bio.structure.io.mmcif.model.PdbxStructAssembly;
import org.biojava.bio.structure.io.mmcif.model.PdbxStructAssemblyGen;
import org.biojava.bio.structure.io.mmcif.model.PdbxStructOperList;
import org.biojava.bio.structure.io.mmcif.model.Refine;
import org.biojava.bio.structure.io.mmcif.model.Struct;
import org.biojava.bio.structure.io.mmcif.model.StructAsym;
import org.biojava.bio.structure.io.mmcif.model.StructKeywords;
import org.biojava.bio.structure.io.mmcif.model.StructRef;
import org.biojava.bio.structure.io.mmcif.model.StructRefSeq;
import org.biojava.bio.structure.quaternary.BiologicalAssemblyBuilder;
import org.biojava.bio.structure.quaternary.ModelTransformationMatrix;

public class SimpleMMcifConsumer
implements MMcifConsumer {
    boolean DEBUG = false;
    Structure structure;
    Chain current_chain;
    Group current_group;
    int atomCount;
    List<Chain> current_model;
    List<Entity> entities;
    List<StructRef> strucRefs;
    List<Chain> seqResChains;
    List<Chain> entityChains;
    List<StructAsym> structAsyms;
    List<PdbxStructOperList> structOpers;
    List<PdbxStructAssembly> strucAssemblies;
    List<PdbxStructAssemblyGen> strucAssemblyGens;
    List<EntitySrcGen> entitySrcGens;
    List<EntitySrcNat> entitySrcNats;
    List<EntitySrcSyn> entitySrcSyns;
    Map<String, String> asymStrandId;
    String current_nmr_model;
    FileParsingParameters params = new FileParsingParameters();
    public static Logger logger = Logger.getLogger("org.biojava.bio.structure");

    public SimpleMMcifConsumer() {
        this.documentStart();
    }

    @Override
    public void newEntity(Entity entity) {
        if (this.DEBUG) {
            System.out.println(entity);
        }
        this.entities.add(entity);
    }

    @Override
    public void newPdbxStructOperList(PdbxStructOperList structOper) {
        this.structOpers.add(structOper);
    }

    @Override
    public void newStructAsym(StructAsym sasym) {
        this.structAsyms.add(sasym);
    }

    private Entity getEntity(String entity_id) {
        for (Entity e : this.entities) {
            if (!e.getId().equals(entity_id)) continue;
            return e;
        }
        return null;
    }

    @Override
    public void newStructKeywords(StructKeywords kw) {
        PDBHeader header = this.structure.getPDBHeader();
        if (header == null) {
            header = new PDBHeader();
        }
        header.setDescription(kw.getPdbx_keywords());
        header.setClassification(kw.getPdbx_keywords());
        Map<String, Object> h = this.structure.getHeader();
        h.put("classification", kw.getPdbx_keywords());
    }

    @Override
    public void setStruct(Struct struct) {
        PDBHeader header = this.structure.getPDBHeader();
        if (header == null) {
            header = new PDBHeader();
        }
        header.setTitle(struct.getTitle());
        header.setIdCode(struct.getEntry_id());
        Map<String, Object> h = this.structure.getHeader();
        h.put("title", struct.getTitle());
        this.structure.setPDBHeader(header);
        this.structure.setPDBCode(struct.getEntry_id());
    }

    private Group getNewGroup(String recordName, Character aminoCode1, long seq_id, String groupCode3) {
        HetatomImpl group;
        Group g;
        if (this.params.isLoadChemCompInfo() && (g = ChemCompGroupFactory.getGroupFromChemCompDictionary(groupCode3)) != null) {
            if (g instanceof AminoAcidImpl) {
                AminoAcidImpl aa = (AminoAcidImpl)g;
                aa.setId(seq_id);
            } else if (g instanceof NucleotideImpl) {
                NucleotideImpl nuc = (NucleotideImpl)g;
                nuc.setId(seq_id);
            } else if (g instanceof HetatomImpl) {
                HetatomImpl het = (HetatomImpl)g;
                het.setId(seq_id);
            }
            return g;
        }
        if (recordName.equals("ATOM")) {
            if (aminoCode1 == null) {
                NucleotideImpl nu;
                group = nu = new NucleotideImpl();
                nu.setId(seq_id);
            } else if (aminoCode1 == StructureTools.UNKNOWN_GROUP_LABEL) {
                HetatomImpl h = new HetatomImpl();
                h.setId(seq_id);
                group = h;
            } else {
                AminoAcidImpl aa = new AminoAcidImpl();
                aa.setAminoType(aminoCode1);
                aa.setId(seq_id);
                group = aa;
            }
        } else {
            HetatomImpl h = new HetatomImpl();
            h.setId(seq_id);
            group = h;
        }
        return group;
    }

    private Chain isKnownChain(String chainID, List<Chain> chains) {
        for (int i = 0; i < chains.size(); ++i) {
            Chain testchain = chains.get(i);
            if (!chainID.equals(testchain.getChainID())) continue;
            return testchain;
        }
        return null;
    }

    private String fixFullAtomName(String name) {
        if (name.equals("N")) {
            return " N  ";
        }
        if (name.equals("CA")) {
            return " CA ";
        }
        if (name.equals("C")) {
            return " C  ";
        }
        if (name.equals("O")) {
            return " O  ";
        }
        if (name.equals("CB")) {
            return " CB ";
        }
        if (name.equals("CG")) {
            return " CG ";
        }
        if (name.length() == 2) {
            return " " + name + " ";
        }
        if (name.length() == 1) {
            return " " + name + "  ";
        }
        if (name.length() == 3) {
            return " " + name;
        }
        return name;
    }

    @Override
    public void newAtomSite(AtomSite atom) {
        boolean startOfNewChain = false;
        String chain_id = atom.getLabel_asym_id();
        String fullname = this.fixFullAtomName(atom.getLabel_atom_id());
        String recordName = atom.getGroup_PDB();
        String residueNumberS = atom.getAuth_seq_id();
        Integer residueNrInt = Integer.parseInt(residueNumberS);
        String groupCode3 = atom.getLabel_comp_id();
        if (groupCode3.length() == 1) {
            groupCode3 = "  " + groupCode3;
        }
        if (groupCode3.length() == 2) {
            groupCode3 = " " + groupCode3;
        }
        Character aminoCode1 = null;
        if (recordName.equals("ATOM")) {
            aminoCode1 = StructureTools.get1LetterCode(groupCode3);
        } else {
            aminoCode1 = StructureTools.get1LetterCode(groupCode3);
            if (aminoCode1 != null && aminoCode1.equals(StructureTools.UNKNOWN_GROUP_LABEL)) {
                aminoCode1 = null;
            }
        }
        String insCodeS = atom.getPdbx_PDB_ins_code();
        Character insCode = null;
        if (!insCodeS.equals("?")) {
            insCode = Character.valueOf(insCodeS.charAt(0));
        }
        long seq_id = -1L;
        try {
            seq_id = Long.parseLong(atom.getLabel_seq_id());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        String nmrModel = atom.getPdbx_PDB_model_num();
        if (this.current_nmr_model == null) {
            this.current_nmr_model = nmrModel;
        }
        if (!this.current_nmr_model.equals(nmrModel)) {
            this.current_nmr_model = nmrModel;
            if (this.current_chain != null) {
                this.current_chain.addGroup(this.current_group);
            }
            this.structure.setNmr(true);
            this.structure.addModel(this.current_model);
            this.current_model = new ArrayList<Chain>();
            this.current_chain = null;
            this.current_group = null;
        }
        if (this.current_chain == null) {
            this.current_chain = new ChainImpl();
            this.current_chain.setChainID(chain_id);
            this.current_model.add(this.current_chain);
            startOfNewChain = true;
        }
        if (!chain_id.equals(this.current_chain.getChainID())) {
            startOfNewChain = true;
            this.current_chain.addGroup(this.current_group);
            Chain testchain = this.isKnownChain(this.current_chain.getChainID(), this.current_model);
            if (testchain == null || !testchain.getChainID().equals(chain_id)) {
                testchain = this.isKnownChain(chain_id, this.current_model);
            }
            if (testchain == null) {
                this.current_chain = new ChainImpl();
                this.current_chain.setChainID(chain_id);
            } else {
                this.current_chain = testchain;
            }
            if (!this.current_model.contains(this.current_chain)) {
                this.current_model.add(this.current_chain);
            }
        }
        ResidueNumber residueNumber = new ResidueNumber(chain_id, residueNrInt, insCode);
        if (this.current_group == null) {
            this.current_group = this.getNewGroup(recordName, aminoCode1, seq_id, groupCode3);
            this.current_group.setResidueNumber(residueNumber);
            try {
                this.current_group.setPDBName(groupCode3);
            }
            catch (PDBParseException e) {
                System.err.println(e.getMessage());
            }
        }
        if (startOfNewChain) {
            this.current_group = this.getNewGroup(recordName, aminoCode1, seq_id, groupCode3);
            this.current_group.setResidueNumber(residueNumber);
            try {
                this.current_group.setPDBName(groupCode3);
            }
            catch (PDBParseException e) {
                e.printStackTrace();
            }
        }
        Group altGroup = null;
        String altLocS = atom.getLabel_alt_id();
        Character altLoc = Character.valueOf(' ');
        if (altLocS.length() > 0 && (altLoc = Character.valueOf(altLocS.charAt(0))).equals(Character.valueOf('.'))) {
            altLoc = Character.valueOf(' ');
        }
        if (!residueNumber.equals(this.current_group.getResidueNumber())) {
            this.current_chain.addGroup(this.current_group);
            this.current_group = this.getNewGroup(recordName, aminoCode1, seq_id, groupCode3);
            try {
                this.current_group.setPDBName(groupCode3);
            }
            catch (PDBParseException e) {
                e.printStackTrace();
            }
            this.current_group.setResidueNumber(residueNumber);
        } else if (!altLoc.equals(Character.valueOf(' ')) && !altLoc.equals(Character.valueOf('.'))) {
            altGroup = this.getCorrectAltLocGroup(altLoc, recordName, aminoCode1, groupCode3, seq_id);
        }
        if (this.params.isHeaderOnly()) {
            return;
        }
        ++this.atomCount;
        if (this.params.isParseCAOnly() && !fullname.equals(" CA ")) {
            --this.atomCount;
            return;
        }
        Atom a = this.convertAtom(atom);
        if (altGroup != null) {
            altGroup.addAtom(a);
            altGroup = null;
        } else {
            this.current_group.addAtom(a);
        }
    }

    private Atom convertAtom(AtomSite atom) {
        AtomImpl a = new AtomImpl();
        a.setPDBserial(Integer.parseInt(atom.getId()));
        a.setName(atom.getLabel_atom_id());
        a.setFullName(this.fixFullAtomName(atom.getLabel_atom_id()));
        double x2 = Double.parseDouble(atom.getCartn_x());
        double y = Double.parseDouble(atom.getCartn_y());
        double z = Double.parseDouble(atom.getCartn_z());
        a.setX(x2);
        a.setY(y);
        a.setZ(z);
        double occupancy = Double.parseDouble(atom.getOccupancy());
        a.setOccupancy(occupancy);
        double temp = Double.parseDouble(atom.getB_iso_or_equiv());
        a.setTempFactor(temp);
        String alt = atom.getLabel_alt_id();
        if (alt != null && alt.length() > 0 && !alt.equals(".")) {
            a.setAltLoc(new Character(alt.charAt(0)));
        } else {
            a.setAltLoc(new Character(' '));
        }
        Element element = Element.R;
        try {
            element = Element.valueOfIgnoreCase(atom.getType_symbol());
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        a.setElement(element);
        return a;
    }

    private Group getCorrectAltLocGroup(Character altLoc, String recordName, Character aminoCode1, String groupCode3, long seq_id) {
        Group altLocG;
        Atom a1;
        List<Atom> atoms = this.current_group.getAtoms();
        if (atoms.size() > 0 && (a1 = atoms.get(0)).getAltLoc().equals(altLoc)) {
            return this.current_group;
        }
        List<Group> altLocs = this.current_group.getAltLocs();
        for (Group altLocG2 : altLocs) {
            atoms = altLocG2.getAtoms();
            if (atoms.size() <= 0) continue;
            for (Atom a12 : atoms) {
                if (!a12.getAltLoc().equals(altLoc)) continue;
                return altLocG2;
            }
        }
        if (groupCode3.equals(this.current_group.getPDBName())) {
            if (this.current_group.getAtoms().size() == 0) {
                return this.current_group;
            }
            altLocG = (Group)this.current_group.clone();
            this.current_group.addAltLoc(altLocG);
            return altLocG;
        }
        altLocG = this.getNewGroup(recordName, aminoCode1, seq_id, groupCode3);
        try {
            altLocG.setPDBName(groupCode3);
        }
        catch (PDBParseException e) {
            e.printStackTrace();
        }
        altLocG.setResidueNumber(this.current_group.getResidueNumber());
        this.current_group.addAltLoc(altLocG);
        return altLocG;
    }

    @Override
    public void documentStart() {
        this.structure = new StructureImpl();
        this.current_chain = null;
        this.current_group = null;
        this.current_nmr_model = null;
        this.atomCount = 0;
        this.current_model = new ArrayList<Chain>();
        this.entities = new ArrayList<Entity>();
        this.strucRefs = new ArrayList<StructRef>();
        this.seqResChains = new ArrayList<Chain>();
        this.entityChains = new ArrayList<Chain>();
        this.structAsyms = new ArrayList<StructAsym>();
        this.asymStrandId = new HashMap<String, String>();
        this.structOpers = new ArrayList<PdbxStructOperList>();
        this.strucAssemblies = new ArrayList<PdbxStructAssembly>();
        this.strucAssemblyGens = new ArrayList<PdbxStructAssemblyGen>();
        this.entitySrcGens = new ArrayList<EntitySrcGen>();
        this.entitySrcNats = new ArrayList<EntitySrcNat>();
        this.entitySrcSyns = new ArrayList<EntitySrcSyn>();
    }

    @Override
    public void documentEnd() {
        if (this.current_chain != null) {
            this.current_chain.addGroup(this.current_group);
            if (this.isKnownChain(this.current_chain.getChainID(), this.current_model) == null) {
                this.current_model.add(this.current_chain);
            }
        } else if (this.DEBUG) {
            System.err.println("current chain is null at end of document.");
        }
        this.structure.addModel(this.current_model);
        for (StructAsym asym : this.structAsyms) {
            List<Compound> compounds;
            Compound c;
            String eId;
            if (this.DEBUG) {
                System.out.println("entity " + asym.getEntity_id() + " matches asym id:" + asym.getId());
            }
            Chain s = this.getEntityChain(asym.getEntity_id());
            Chain seqres = (Chain)s.clone();
            seqres.setChainID(asym.getId());
            this.seqResChains.add(seqres);
            if (this.DEBUG) {
                System.out.println(" seqres: " + asym.getId() + " " + seqres + "<");
            }
            for (EntitySrcGen esg : this.entitySrcGens) {
                eId = esg.getEntity_id();
                if (!eId.equals(asym.getEntity_id())) continue;
                c = this.structure.getCompoundById(eId);
                if (c == null) {
                    c = this.createNewCompoundFromESG(esg, eId);
                    compounds = this.structure.getCompounds();
                    compounds.add(c);
                    this.structure.setCompounds(compounds);
                }
                c.addChain(s);
            }
            for (EntitySrcNat esn : this.entitySrcNats) {
                eId = esn.getEntity_id();
                if (!eId.equals(asym.getEntity_id())) continue;
                c = this.structure.getCompoundById(eId);
                if (c == null) {
                    c = this.createNewCompoundFromESN(esn, eId);
                    compounds = this.structure.getCompounds();
                    compounds.add(c);
                    this.structure.setCompounds(compounds);
                }
                c.addChain(s);
            }
            for (EntitySrcSyn ess : this.entitySrcSyns) {
                eId = ess.getEntity_id();
                if (!eId.equals(asym.getEntity_id())) continue;
                c = this.structure.getCompoundById(eId);
                if (c == null) {
                    c = this.createNewCompoundFromESS(ess, eId);
                    compounds = this.structure.getCompounds();
                    compounds.add(c);
                    this.structure.setCompounds(compounds);
                }
                c.addChain(s);
            }
        }
        if (this.params.isAlignSeqRes()) {
            SeqRes2AtomAligner aligner = new SeqRes2AtomAligner();
            List<Chain> atomList = this.structure.getModel(0);
            for (Chain seqResChain : this.seqResChains) {
                try {
                    Chain atomChain = aligner.getMatchingAtomRes(seqResChain, atomList);
                    List<Group> seqResGroups = seqResChain.getAtomGroups();
                    for (int seqResPos = 0; seqResPos < seqResGroups.size(); ++seqResPos) {
                        Group seqresG = seqResGroups.get(seqResPos);
                        boolean found = false;
                        for (Group atomG : atomChain.getAtomGroups()) {
                            int internalNr = this.getInternalNr(atomG);
                            if (seqresG.getResidueNumber().getSeqNum() != internalNr) continue;
                            seqResGroups.set(seqResPos, atomG);
                            found = true;
                            break;
                        }
                        if (found) continue;
                        seqresG.setResidueNumber(null);
                    }
                    atomChain.setSeqResGroups(seqResGroups);
                }
                catch (StructureException e) {
                    e.printStackTrace();
                }
            }
        }
        Set<String> asymIds = this.asymStrandId.keySet();
        for (int i = 0; i < this.structure.nrModels(); ++i) {
            List<Chain> model = this.structure.getModel(i);
            ArrayList<Chain> pdbChains = new ArrayList<Chain>();
            block10: for (Chain chain2 : model) {
                for (String asym : asymIds) {
                    if (!chain2.getChainID().equals(asym)) continue;
                    if (this.DEBUG) {
                        System.out.println("renaming " + asym + " to : " + this.asymStrandId.get(asym));
                    }
                    chain2.setChainID(this.asymStrandId.get(asym));
                    chain2.setInternalChainID(asym);
                    Chain known = this.isKnownChain(chain2.getChainID(), pdbChains);
                    if (known == null) {
                        pdbChains.add(chain2);
                        continue block10;
                    }
                    for (Group g : chain2.getAtomGroups()) {
                        known.addGroup(g);
                    }
                    continue block10;
                }
            }
            this.structure.setModel(i, pdbChains);
        }
        PDBHeader header = this.structure.getPDBHeader();
        header.setNrBioAssemblies(this.strucAssemblies.size());
        HashMap<Integer, List<ModelTransformationMatrix>> transformationMap = new HashMap<Integer, List<ModelTransformationMatrix>>();
        int total = this.strucAssemblies.size();
        for (int defaultBioAssembly = 1; defaultBioAssembly <= total; ++defaultBioAssembly) {
            PdbxStructAssembly psa = this.strucAssemblies.get(defaultBioAssembly - 1);
            ArrayList<PdbxStructAssemblyGen> psags = new ArrayList<PdbxStructAssemblyGen>(1);
            for (PdbxStructAssemblyGen psag : this.strucAssemblyGens) {
                if (!psag.getAssembly_id().equals(defaultBioAssembly + "")) continue;
                psags.add(psag);
            }
            BiologicalAssemblyBuilder builder = new BiologicalAssemblyBuilder();
            ArrayList<ModelTransformationMatrix> transformations = builder.getBioUnitTransformationList(psa, psags, this.structOpers);
            transformationMap.put(defaultBioAssembly, transformations);
        }
        this.structure.getPDBHeader().setBioUnitTranformationMap(transformationMap);
    }

    private int getInternalNr(Group atomG) {
        if (atomG.getType().equals("amino")) {
            AminoAcidImpl aa = (AminoAcidImpl)atomG;
            return new Long(aa.getId()).intValue();
        }
        if (atomG.getType().equals("nucleotide")) {
            NucleotideImpl nu = (NucleotideImpl)atomG;
            return new Long(nu.getId()).intValue();
        }
        HetatomImpl he = (HetatomImpl)atomG;
        return new Long(he.getId()).intValue();
    }

    private Compound createNewCompoundFromESG(EntitySrcGen esg, String eId) {
        Entity e = this.getEntity(eId);
        Compound c = new Compound();
        c.setMolId(eId);
        if (e != null) {
            c.setMolName(e.getPdbx_description());
        }
        c.setAtcc(esg.getPdbx_gene_src_atcc());
        c.setCell(esg.getPdbx_gene_src_cell());
        c.setOrganismCommon(esg.getGene_src_common_name());
        c.setOrganismScientific(esg.getPdbx_gene_src_scientific_name());
        c.setOrganismTaxId(esg.getPdbx_gene_src_ncbi_taxonomy_id());
        c.setExpressionSystemTaxId(esg.getPdbx_host_org_ncbi_taxonomy_id());
        c.setExpressionSystem(esg.getPdbx_host_org_scientific_name());
        return c;
    }

    private Compound createNewCompoundFromESN(EntitySrcNat esn, String eId) {
        Entity e = this.getEntity(eId);
        Compound c = new Compound();
        c.setMolId(eId);
        if (e != null) {
            c.setMolName(e.getPdbx_description());
        }
        c.setAtcc(esn.getPdbx_atcc());
        c.setCell(esn.getPdbx_cell());
        c.setOrganismCommon(esn.getCommon_name());
        c.setOrganismScientific(esn.getPdbx_organism_scientific());
        c.setOrganismTaxId(esn.getPdbx_ncbi_taxonomy_id());
        return c;
    }

    private Compound createNewCompoundFromESS(EntitySrcSyn ess, String eId) {
        Entity e = this.getEntity(eId);
        Compound c = new Compound();
        c.setMolId(eId);
        if (e != null) {
            c.setMolName(e.getPdbx_description());
        }
        c.setOrganismCommon(ess.getOrganism_common_name());
        c.setOrganismScientific(ess.getOrganism_scientific());
        c.setOrganismTaxId(ess.getNcbi_taxonomy_id());
        return c;
    }

    public Structure getStructure() {
        return this.structure;
    }

    @Override
    public void newDatabasePDBrev(DatabasePDBrev dbrev) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        PDBHeader header = this.structure.getPDBHeader();
        Map<String, Object> h = this.structure.getHeader();
        if (header == null) {
            header = new PDBHeader();
        }
        if (dbrev.getNum().equals("1")) {
            try {
                String date = dbrev.getDate_original();
                Date dep = dateFormat.parse(date);
                header.setDepDate(dep);
                h.put("depDate", date);
                Date mod = dateFormat.parse(dbrev.getDate());
                header.setModDate(mod);
                h.put("revDate", dbrev.getDate());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else {
            try {
                Date mod = dateFormat.parse(dbrev.getDate());
                header.setModDate(mod);
                h.put("revDate", dbrev.getDate());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        this.structure.setPDBHeader(header);
    }

    @Override
    public void newDatabasePDBremark(DatabasePDBremark remark) {
        String line;
        int i;
        String id = remark.getId();
        if (id.equals("2") && (i = (line = remark.getText()).indexOf("ANGSTROM")) > 5) {
            String resolution = line.substring(i - 5, i).trim();
            float res = 99.0f;
            try {
                res = Float.parseFloat(resolution);
            }
            catch (NumberFormatException e) {
                System.err.println(e.getMessage());
                System.err.println("could not parse resolution from line and ignoring it " + line);
                return;
            }
            Map<String, Object> header = this.structure.getHeader();
            header.put("resolution", new Float(res));
            this.structure.setHeader(header);
            PDBHeader pdbHeader = this.structure.getPDBHeader();
            pdbHeader.setResolution(res);
        }
    }

    @Override
    public void newRefine(Refine r) {
        PDBHeader pdbHeader = this.structure.getPDBHeader();
        try {
            pdbHeader.setResolution(Float.parseFloat(r.getLs_d_res_high()));
        }
        catch (NumberFormatException e) {
            logger.warning("could not parse resolution from " + r.getLs_d_res_high() + " " + e.getMessage());
        }
        Map<String, Object> header = this.structure.getHeader();
        header.put("resolution", Float.valueOf(pdbHeader.getResolution()));
    }

    @Override
    public void newAuditAuthor(AuditAuthor aa) {
        String name = aa.getName();
        StringBuffer famName = new StringBuffer();
        StringBuffer initials = new StringBuffer();
        boolean afterComma = false;
        for (char c : name.toCharArray()) {
            if (c == ' ') continue;
            if (c == ',') {
                afterComma = true;
                continue;
            }
            if (afterComma) {
                initials.append(c);
                continue;
            }
            famName.append(c);
        }
        StringBuffer newaa = new StringBuffer();
        newaa.append(initials);
        newaa.append(famName);
        PDBHeader header = this.structure.getPDBHeader();
        String auth = header.getAuthors();
        if (auth == null) {
            header.setAuthors(newaa.toString());
        } else {
            auth = auth + "," + newaa.toString();
            header.setAuthors(auth);
        }
    }

    @Override
    public void newExptl(Exptl exptl) {
        PDBHeader pdbHeader = this.structure.getPDBHeader();
        String method = exptl.getMethod();
        String old = pdbHeader.getTechnique();
        if (old != null && !old.equals("")) {
            method = old + "; " + method;
        }
        pdbHeader.setTechnique(method);
        Map<String, Object> header = this.structure.getHeader();
        header.put("technique", method);
    }

    @Override
    public void newStructRef(StructRef sref) {
        if (this.DEBUG) {
            System.out.println(sref);
        }
        this.strucRefs.add(sref);
    }

    private StructRef getStructRef(String ref_id) {
        for (StructRef structRef : this.strucRefs) {
            if (!structRef.getId().equals(ref_id)) continue;
            return structRef;
        }
        return null;
    }

    @Override
    public void newStructRefSeq(StructRefSeq sref) {
        DBRef r = new DBRef();
        r.setIdCode(sref.getPdbx_PDB_id_code());
        r.setDbAccession(sref.getPdbx_db_accession());
        r.setDbIdCode(sref.getPdbx_db_accession());
        r.setChainId(sref.getPdbx_strand_id());
        StructRef structRef = this.getStructRef(sref.getRef_id());
        if (structRef == null) {
            logger.warning("could not find StructRef " + sref.getRef_id() + " for StructRefSeq " + sref);
        } else {
            r.setDatabase(structRef.getDb_name());
            r.setDbIdCode(structRef.getDb_code());
        }
        int seqbegin = Integer.parseInt(sref.getPdbx_auth_seq_align_beg());
        int seqend = Integer.parseInt(sref.getPdbx_auth_seq_align_end());
        Character begin_ins_code = new Character(sref.getPdbx_seq_align_beg_ins_code().charAt(0));
        Character end_ins_code = new Character(sref.getPdbx_seq_align_end_ins_code().charAt(0));
        if (begin_ins_code.charValue() == '?') {
            begin_ins_code = Character.valueOf(' ');
        }
        if (end_ins_code.charValue() == '?') {
            end_ins_code = Character.valueOf(' ');
        }
        r.setSeqBegin(seqbegin);
        r.setInsertBegin(begin_ins_code.charValue());
        r.setSeqEnd(seqend);
        r.setInsertEnd(end_ins_code.charValue());
        int dbseqbegin = Integer.parseInt(sref.getDb_align_beg());
        int dbseqend = Integer.parseInt(sref.getDb_align_end());
        Character db_begin_in_code = new Character(sref.getPdbx_db_align_beg_ins_code().charAt(0));
        Character db_end_in_code = new Character(sref.getPdbx_db_align_end_ins_code().charAt(0));
        if (db_begin_in_code.charValue() == '?') {
            db_begin_in_code = Character.valueOf(' ');
        }
        if (db_end_in_code.charValue() == '?') {
            db_end_in_code = Character.valueOf(' ');
        }
        r.setDbSeqBegin(dbseqbegin);
        r.setIdbnsBegin(db_begin_in_code.charValue());
        r.setDbSeqEnd(dbseqend);
        r.setIdbnsEnd(db_end_in_code.charValue());
        List<DBRef> dbrefs = this.structure.getDBRefs();
        if (dbrefs == null) {
            dbrefs = new ArrayList<DBRef>();
        }
        dbrefs.add(r);
        if (this.DEBUG) {
            System.out.println(r.toPDB());
        }
        this.structure.setDBRefs(dbrefs);
    }

    private Chain getChainFromList(List<Chain> chains, String name) {
        for (Chain chain2 : chains) {
            if (!chain2.getChainID().equals(name)) continue;
            return chain2;
        }
        ChainImpl chain3 = new ChainImpl();
        chain3.setChainID(name);
        chains.add(chain3);
        return chain3;
    }

    private Chain getEntityChain(String entity_id) {
        return this.getChainFromList(this.entityChains, entity_id);
    }

    @Override
    public void newEntitySrcGen(EntitySrcGen entitySrcGen) {
        this.entitySrcGens.add(entitySrcGen);
    }

    @Override
    public void newEntitySrcNat(EntitySrcNat entitySrcNat) {
        this.entitySrcNats.add(entitySrcNat);
    }

    @Override
    public void newEntitySrcSyn(EntitySrcSyn entitySrcSyn) {
        this.entitySrcSyns.add(entitySrcSyn);
    }

    @Override
    public void newEntityPolySeq(EntityPolySeq epolseq) {
        Entity e;
        if (this.DEBUG) {
            System.out.println("NEW entity poly seq " + epolseq);
        }
        if ((e = this.getEntity(epolseq.getEntity_id())) == null) {
            System.err.println("could not find entity " + epolseq.getEntity_id() + ". Can not match sequence to it.");
            return;
        }
        Chain entityChain = this.getEntityChain(epolseq.getEntity_id());
        AminoAcidImpl g = new AminoAcidImpl();
        g.setRecordType("SEQRES");
        try {
            g.setPDBName(epolseq.getMon_id());
            Character code1 = StructureTools.convert_3code_1code(epolseq.getMon_id());
            g.setAminoType(code1);
            g.setResidueNumber(ResidueNumber.fromString(epolseq.getNum()));
            entityChain.addGroup(g);
        }
        catch (PDBParseException ex) {
            if (StructureTools.isNucleotide(epolseq.getMon_id())) {
                NucleotideImpl n = new NucleotideImpl();
                n.setResidueNumber(ResidueNumber.fromString(epolseq.getNum()));
                try {
                    n.setPDBName(epolseq.getMon_id());
                }
                catch (PDBParseException pex) {
                    pex.printStackTrace();
                }
                entityChain.addGroup(n);
            }
            logger.warning(ex.getMessage() + " creating a hetatom called XXX ");
            HetatomImpl h = new HetatomImpl();
            try {
                h.setPDBName(epolseq.getMon_id());
                h.setResidueNumber(ResidueNumber.fromString(epolseq.getNum()));
                entityChain.addGroup(h);
            }
            catch (PDBParseException exc) {
                System.err.println("this is a helpless case and I am dropping group " + epolseq.getMon_id());
            }
        }
        catch (UnknownPdbAminoAcidException ex) {
            HetatomImpl h = new HetatomImpl();
            try {
                h.setPDBName(epolseq.getMon_id());
                h.setResidueNumber(ResidueNumber.fromString(epolseq.getNum()));
                entityChain.addGroup(h);
            }
            catch (PDBParseException exc) {
                System.err.println("this is a helpless case and I am dropping group " + epolseq.getMon_id() + " " + ex.getMessage());
            }
        }
    }

    private List<Chain> getChainsFromAllModels(String chainId) {
        ArrayList<Chain> chains = new ArrayList<Chain>();
        for (int i = 0; i < this.structure.nrModels(); ++i) {
            List<Chain> model = this.structure.getModel(i);
            for (Chain c : model) {
                if (!c.getChainID().equals(chainId)) continue;
                chains.add(c);
            }
        }
        return chains;
    }

    private void replaceGroupSeqPos(PdbxPolySeqScheme ppss) {
        if (ppss.getAuth_seq_num().equals("?")) {
            return;
        }
        List<Chain> matchinChains = this.getChainsFromAllModels(ppss.getAsym_id());
        long sid = Long.parseLong(ppss.getSeq_id());
        for (Chain c : matchinChains) {
            Group target = null;
            for (Group g : c.getAtomGroups()) {
                HetatomImpl h;
                if (g instanceof AminoAcidImpl) {
                    AminoAcidImpl aa = (AminoAcidImpl)g;
                    if (aa.getId() != sid) continue;
                    target = g;
                    break;
                }
                if (g instanceof NucleotideImpl) {
                    NucleotideImpl n = (NucleotideImpl)g;
                    if (n.getId() != sid) continue;
                    target = g;
                    break;
                }
                if (!(g instanceof HetatomImpl) || (h = (HetatomImpl)g).getId() != sid) continue;
                target = h;
                break;
            }
            if (target == null) {
                logger.info("could not find group at seq. position " + ppss.getSeq_id() + " in internal chain " + c.getChainID() + ". " + ppss);
                continue;
            }
            if (!target.getPDBName().trim().equals(ppss.getMon_id())) {
                logger.info("could not match PdbxPolySeqScheme to chain:" + target.getPDBName() + " " + ppss);
                continue;
            }
            Integer pdbResNum = Integer.parseInt(ppss.getAuth_seq_num());
            String insCodeS = ppss.getPdb_ins_code();
            Character insCode = null;
            if (insCodeS != null && !insCodeS.equals(".") && insCodeS.length() > 0) {
                insCode = Character.valueOf(insCodeS.charAt(0));
            }
            ResidueNumber residueNumber = new ResidueNumber(null, pdbResNum, insCode);
            target.setResidueNumber(residueNumber);
        }
    }

    @Override
    public void newPdbxPolySeqScheme(PdbxPolySeqScheme ppss) {
        this.replaceGroupSeqPos(ppss);
        if (this.asymStrandId.containsKey(ppss.getAsym_id())) {
            return;
        }
        if (ppss.getPdb_strand_id() == null) {
            this.asymStrandId.put(ppss.getAsym_id(), ppss.getAuth_mon_id());
            return;
        }
        this.asymStrandId.put(ppss.getAsym_id(), ppss.getPdb_strand_id());
    }

    @Override
    public void newPdbxNonPolyScheme(PdbxNonPolyScheme ppss) {
        if (this.asymStrandId.containsKey(ppss.getAsym_id())) {
            return;
        }
        if (ppss.getPdb_strand_id() == null) {
            this.asymStrandId.put(ppss.getAsym_id(), ppss.getAsym_id());
            return;
        }
        this.asymStrandId.put(ppss.getAsym_id(), ppss.getPdb_strand_id());
    }

    @Override
    public void newPdbxEntityNonPoly(PdbxEntityNonPoly pen) {
    }

    @Override
    public void newChemComp(ChemComp c) {
    }

    @Override
    public void newGenericData(String category, List<String> loopFields, List<String> lineData) {
        if (this.DEBUG) {
            System.err.println("unhandled category so far: " + category);
        }
    }

    @Override
    public FileParsingParameters getFileParsingParameters() {
        return this.params;
    }

    @Override
    public void setFileParsingParameters(FileParsingParameters params) {
        this.params = params;
    }

    @Override
    public void newChemCompDescriptor(ChemCompDescriptor ccd) {
    }

    public List<PdbxStructOperList> getStructOpers() {
        return this.structOpers;
    }

    @Override
    public void newPdbxStrucAssembly(PdbxStructAssembly strucAssembly) {
        this.strucAssemblies.add(strucAssembly);
    }

    public List<PdbxStructAssembly> getStructAssemblies() {
        return this.strucAssemblies;
    }

    @Override
    public void newPdbxStrucAssemblyGen(PdbxStructAssemblyGen strucAssembly) {
        this.strucAssemblyGens.add(strucAssembly);
    }

    public List<PdbxStructAssemblyGen> getStructAssemblyGens() {
        return this.strucAssemblyGens;
    }

    @Override
    public void newChemCompAtom(ChemCompAtom atom) {
    }

    @Override
    public void newPdbxChemCompIndentifier(PdbxChemCompIdentifier id) {
    }

    @Override
    public void newChemCompBond(ChemCompBond bond) {
    }

    @Override
    public void newPdbxChemCompDescriptor(PdbxChemCompDescriptor desc) {
    }
}

