/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.align;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.concurrent.Callable;
import java.util.zip.GZIPOutputStream;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureTools;
import org.biojava.bio.structure.align.StructureAlignment;
import org.biojava.bio.structure.align.StructureAlignmentFactory;
import org.biojava.bio.structure.align.ce.ConfigStrucAligParams;
import org.biojava.bio.structure.align.client.PdbPair;
import org.biojava.bio.structure.align.model.AFPChain;
import org.biojava.bio.structure.align.util.AtomCache;
import org.biojava.bio.structure.align.util.SynchronizedOutFile;
import org.biojava.bio.structure.align.xml.AFPChainXMLConverter;

public class CallableStructureAlignment
implements Callable<AFPChain> {
    PdbPair pair;
    AtomCache cache;
    SynchronizedOutFile outFile;
    Atom[] ca1;
    private File outFileDir;
    private String algorithmName;
    private ConfigStrucAligParams params;

    @Override
    public AFPChain call() throws Exception {
        StructureAlignment algorithm = StructureAlignmentFactory.getAlgorithm(this.algorithmName);
        algorithm.setParameters(this.params);
        AFPChain afpChain = null;
        try {
            if (this.ca1 == null) {
                Structure structure1 = this.cache.getStructure(this.pair.getName1());
                this.ca1 = StructureTools.getAtomCAArray(structure1);
            } else {
                this.ca1 = StructureTools.cloneCAArray(this.ca1);
            }
            Structure structure2 = this.cache.getStructure(this.pair.getName2());
            Atom[] ca2 = StructureTools.getAtomCAArray(structure2);
            afpChain = algorithm.align(this.ca1, ca2);
            afpChain.setName1(this.pair.getName1());
            afpChain.setName2(this.pair.getName2());
            String desc2 = structure2.getPDBHeader().getDescription();
            if (desc2 == null) {
                desc2 = "";
            }
            afpChain.setDescription2(desc2);
            String result2 = afpChain.toDBSearchResult();
            System.out.print(result2);
            this.outFile.write(result2);
            String xml = AFPChainXMLConverter.toXML(afpChain, this.ca1, ca2);
            this.writeXML(this.outFileDir, this.pair.getName1(), this.pair.getName2(), xml);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public PdbPair getPair() {
        return this.pair;
    }

    public void setPair(PdbPair pair2) {
        this.pair = pair2;
    }

    public AtomCache getCache() {
        return this.cache;
    }

    public void setCache(AtomCache cache) {
        this.cache = cache;
    }

    public SynchronizedOutFile getOutFile() {
        return this.outFile;
    }

    public void setOutFile(SynchronizedOutFile outFile) {
        this.outFile = outFile;
    }

    public Atom[] getCa1() {
        return this.ca1;
    }

    public void setCa1(Atom[] ca1) {
        this.ca1 = ca1;
    }

    private void writeXML(File outFileF, String name1, String name2, String xml) {
        try {
            File newF = new File(outFileF, "dbsearch_" + name1 + "_" + name2 + ".xml.gz");
            FileOutputStream fstream = new FileOutputStream(newF);
            GZIPOutputStream gz = new GZIPOutputStream(fstream);
            OutputStreamWriter writer = new OutputStreamWriter(gz);
            writer.write(xml);
            writer.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public void setOutputDir(File outFileF) {
        this.outFileDir = outFileF;
    }

    public void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public void setParameters(ConfigStrucAligParams parameters) {
        this.params = parameters;
    }
}

