/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive;

import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.stat.descriptive.UnivariateStatistic;

public abstract class AbstractUnivariateStatistic
implements UnivariateStatistic {
    private double[] storedData;

    public void setData(double[] values2) {
        this.storedData = values2 == null ? null : (double[])values2.clone();
    }

    public double[] getData() {
        return this.storedData == null ? null : (double[])this.storedData.clone();
    }

    protected double[] getDataRef() {
        return this.storedData;
    }

    public void setData(double[] values2, int begin, int length) throws MathIllegalArgumentException {
        if (values2 == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        if (begin < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.START_POSITION, begin);
        }
        if (length < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.LENGTH, length);
        }
        if (begin + length > values2.length) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.SUBARRAY_ENDS_AFTER_ARRAY_END, (Number)(begin + length), values2.length, true);
        }
        this.storedData = new double[length];
        System.arraycopy(values2, begin, this.storedData, 0, length);
    }

    public double evaluate() throws MathIllegalArgumentException {
        return this.evaluate(this.storedData);
    }

    public double evaluate(double[] values2) throws MathIllegalArgumentException {
        this.test(values2, 0, 0);
        return this.evaluate(values2, 0, values2.length);
    }

    public abstract double evaluate(double[] var1, int var2, int var3) throws MathIllegalArgumentException;

    public abstract UnivariateStatistic copy();

    protected boolean test(double[] values2, int begin, int length) throws MathIllegalArgumentException {
        return this.test(values2, begin, length, false);
    }

    protected boolean test(double[] values2, int begin, int length, boolean allowEmpty) throws MathIllegalArgumentException {
        if (values2 == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        if (begin < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.START_POSITION, begin);
        }
        if (length < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.LENGTH, length);
        }
        if (begin + length > values2.length) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.SUBARRAY_ENDS_AFTER_ARRAY_END, (Number)(begin + length), values2.length, true);
        }
        return length != 0 || allowEmpty;
    }

    protected boolean test(double[] values2, double[] weights, int begin, int length) throws MathIllegalArgumentException {
        return this.test(values2, weights, begin, length, false);
    }

    protected boolean test(double[] values2, double[] weights, int begin, int length, boolean allowEmpty) throws MathIllegalArgumentException {
        if (weights == null || values2 == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        if (weights.length != values2.length) {
            throw new DimensionMismatchException(weights.length, values2.length);
        }
        boolean containsPositiveWeight = false;
        for (int i = begin; i < begin + length; ++i) {
            if (Double.isNaN(weights[i])) {
                throw new MathIllegalArgumentException(LocalizedFormats.NAN_ELEMENT_AT_INDEX, i);
            }
            if (Double.isInfinite(weights[i])) {
                throw new MathIllegalArgumentException(LocalizedFormats.INFINITE_ARRAY_ELEMENT, weights[i], i);
            }
            if (weights[i] < 0.0) {
                throw new MathIllegalArgumentException(LocalizedFormats.NEGATIVE_ELEMENT_AT_INDEX, i, weights[i]);
            }
            if (containsPositiveWeight || !(weights[i] > 0.0)) continue;
            containsPositiveWeight = true;
        }
        if (!containsPositiveWeight) {
            throw new MathIllegalArgumentException(LocalizedFormats.WEIGHT_AT_LEAST_ONE_NON_ZERO, new Object[0]);
        }
        return this.test(values2, begin, length, allowEmpty);
    }
}

