/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.tabix;

import java.util.Iterator;
import net.sf.samtools.tabix.TPair64;
import net.sf.samtools.tabix.TabixInterval;
import net.sf.samtools.tabix.TabixReader;
import org.snpeff.util.Gpr;

public class TabixIterator
implements Iterator<String>,
Iterable<String> {
    boolean debug;
    TabixReader tabixReader;
    private int i = -1;
    private int tid;
    private int beg;
    private int end;
    private TPair64[] offsets;
    private long currentOffset = 0L;
    private boolean isEof = false;
    private String next = null;
    private boolean showHeader = false;
    private boolean readBlock = false;

    public TabixIterator(TabixReader tabixReader, int _tid, int _beg, int _end, TPair64[] _off) {
        this.offsets = _off;
        this.tid = _tid;
        this.beg = _beg;
        this.end = _end;
        this.tabixReader = tabixReader;
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            this.next = this.readNext();
        }
        return this.next != null;
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    @Override
    public String next() {
        if (this.hasNext()) {
            String ret = this.next;
            this.next = null;
            return ret;
        }
        return null;
    }

    private String readNext() {
        try {
            block23: {
                block24: {
                    String s;
                    if (this.isEof) {
                        if (this.debug) {
                            Gpr.debug("readNext return: EOF");
                        }
                        return null;
                    }
                    while (true) {
                        if (this.currentOffset == 0L || !TPair64.less64(this.currentOffset, this.offsets[this.i].v)) {
                            if (this.i == this.offsets.length - 1) {
                                if (this.debug) {
                                    Gpr.debug("readNext break: No more chunks");
                                }
                                break block23;
                            }
                            if (this.i >= 0) assert (this.currentOffset == this.offsets[this.i].v);
                            if (this.i < 0 || this.offsets[this.i].v != this.offsets[this.i + 1].u) {
                                long pos = this.offsets[this.i + 1].u;
                                this.tabixReader.seek(pos);
                                this.currentOffset = this.tabixReader.getFilePointer();
                                if (this.debug) {
                                    Gpr.debug("readNext seek: " + this.offsets[this.i + 1].u + "\tcurr_off: " + this.currentOffset);
                                }
                            }
                            ++this.i;
                        }
                        if ((s = this.tabixReader.readLine()) == null) break block24;
                        if (this.debug) {
                            Gpr.debug("reding line: " + s);
                        }
                        char[] str = s.toCharArray();
                        this.currentOffset = this.tabixReader.getFilePointer();
                        if (str.length == 0) {
                            if (!this.debug) continue;
                            Gpr.debug("readNext continue, empty line");
                            continue;
                        }
                        if (str[0] == this.tabixReader.getmMeta()) {
                            if (!this.showHeader) {
                                if (!this.debug) continue;
                                Gpr.debug("readNext continue, header line: " + s);
                                continue;
                            }
                            if (this.debug) {
                                Gpr.debug("readNext return, line: " + s);
                            }
                            return s;
                        }
                        if (this.readBlock) {
                            if (this.debug) {
                                Gpr.debug("readNext return (block), line: " + s);
                            }
                            return s;
                        }
                        TabixInterval latestIntv = new TabixInterval(this.tabixReader, s);
                        if (this.tid >= 0 && latestIntv.tid != this.tid || latestIntv.beg >= this.end) {
                            if (this.debug) {
                                Gpr.debug("readNext break: Interval from file after query:\n\tQuery        :\ttid: " + this.tid + ", start: " + this.beg + ", end: " + this.end + "\n\tFile interval:\t" + latestIntv);
                            }
                            break block23;
                        }
                        if (latestIntv.end > this.beg && latestIntv.beg < this.end) break;
                    }
                    if (this.debug) {
                        Gpr.debug("readNext return, line: " + s);
                    }
                    return s;
                }
                if (this.debug) {
                    Gpr.debug("readNext break: End of file");
                }
            }
            this.isEof = true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.debug) {
            Gpr.debug("readNext return, line: null");
        }
        return null;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Unimplemented!");
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setReadBlock(boolean readBlock) {
        this.readBlock = readBlock;
    }

    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("tid:" + this.tid + "\tbeg:" + this.beg + "\tend:" + this.end);
        for (TPair64 tp : this.offsets) {
            sb.append("\t" + tp + "\n");
        }
        return sb.toString();
    }

    public String toStringBlocks() {
        StringBuilder sb = new StringBuilder();
        for (TPair64 tp : this.offsets) {
            sb.append(tp.toStringRor16() + "\n");
        }
        return sb.toString();
    }
}

