/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.samtools.BAMFileConstants;
import net.sf.samtools.BAMFileSpan;
import net.sf.samtools.BAMIndex;
import net.sf.samtools.BAMRecordCodec;
import net.sf.samtools.CachingBAMFileIndex;
import net.sf.samtools.Chunk;
import net.sf.samtools.DiskBasedBAMFileIndex;
import net.sf.samtools.SAMException;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileSource;
import net.sf.samtools.SAMFileSpan;
import net.sf.samtools.SAMFormatException;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordFactory;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.SAMTextHeaderCodec;
import net.sf.samtools.SAMUtils;
import net.sf.samtools.SAMValidationError;
import net.sf.samtools.seekablestream.SeekableStream;
import net.sf.samtools.util.BinaryCodec;
import net.sf.samtools.util.BlockCompressedInputStream;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.CoordMath;
import net.sf.samtools.util.StringLineReader;

class BAMFileReader
extends SAMFileReader.ReaderImplementation {
    private boolean mIsSeekable = false;
    private BinaryCodec mStream = null;
    private final BlockCompressedInputStream mCompressedInputStream;
    private SAMFileHeader mFileHeader = null;
    private File mIndexFile = null;
    private SeekableStream mIndexStream = null;
    private BAMIndex mIndex = null;
    private long mFirstRecordPointer = 0L;
    private CloseableIterator<SAMRecord> mCurrentIterator = null;
    private final boolean eagerDecode;
    private SAMFileReader.ValidationStringency mValidationStringency;
    private SAMRecordFactory samRecordFactory;
    private boolean mEnableIndexCaching = false;
    private boolean mEnableIndexMemoryMapping = true;
    private SAMFileReader mFileReader = null;

    BAMFileReader(InputStream stream, File indexFile, boolean eagerDecode, SAMFileReader.ValidationStringency validationStringency, SAMRecordFactory factory) throws IOException {
        this.mIndexFile = indexFile;
        this.mIsSeekable = false;
        this.mCompressedInputStream = new BlockCompressedInputStream(stream);
        this.mStream = new BinaryCodec(new DataInputStream(this.mCompressedInputStream));
        this.eagerDecode = eagerDecode;
        this.mValidationStringency = validationStringency;
        this.samRecordFactory = factory;
        this.readHeader(null);
    }

    BAMFileReader(File file, File indexFile, boolean eagerDecode, SAMFileReader.ValidationStringency validationStringency, SAMRecordFactory factory) throws IOException {
        this(new BlockCompressedInputStream(file), indexFile != null ? indexFile : BAMFileReader.findIndexFile(file), eagerDecode, file.getAbsolutePath(), validationStringency, factory);
        if (this.mIndexFile != null && this.mIndexFile.lastModified() < file.lastModified()) {
            System.err.println("WARNING: BAM index file " + this.mIndexFile.getAbsolutePath() + " is older than BAM " + file.getAbsolutePath());
        }
        this.mStream.setInputFileName(file.getAbsolutePath());
    }

    BAMFileReader(SeekableStream strm, File indexFile, boolean eagerDecode, SAMFileReader.ValidationStringency validationStringency, SAMRecordFactory factory) throws IOException {
        this(new BlockCompressedInputStream(strm), indexFile, eagerDecode, strm.getSource(), validationStringency, factory);
    }

    BAMFileReader(SeekableStream strm, SeekableStream indexStream, boolean eagerDecode, SAMFileReader.ValidationStringency validationStringency, SAMRecordFactory factory) throws IOException {
        this(new BlockCompressedInputStream(strm), indexStream, eagerDecode, strm.getSource(), validationStringency, factory);
    }

    private BAMFileReader(BlockCompressedInputStream compressedInputStream, File indexFile, boolean eagerDecode, String source, SAMFileReader.ValidationStringency validationStringency, SAMRecordFactory factory) throws IOException {
        this.mIndexFile = indexFile;
        this.mIsSeekable = true;
        this.mCompressedInputStream = compressedInputStream;
        this.mStream = new BinaryCodec(new DataInputStream(this.mCompressedInputStream));
        this.eagerDecode = eagerDecode;
        this.mValidationStringency = validationStringency;
        this.samRecordFactory = factory;
        this.readHeader(source);
        this.mFirstRecordPointer = this.mCompressedInputStream.getFilePointer();
    }

    private BAMFileReader(BlockCompressedInputStream compressedInputStream, SeekableStream indexStream, boolean eagerDecode, String source, SAMFileReader.ValidationStringency validationStringency, SAMRecordFactory factory) throws IOException {
        this.mIndexStream = indexStream;
        this.mIsSeekable = true;
        this.mCompressedInputStream = compressedInputStream;
        this.mStream = new BinaryCodec(new DataInputStream(this.mCompressedInputStream));
        this.eagerDecode = eagerDecode;
        this.mValidationStringency = validationStringency;
        this.samRecordFactory = factory;
        this.readHeader(source);
        this.mFirstRecordPointer = this.mCompressedInputStream.getFilePointer();
    }

    @Override
    void enableFileSource(SAMFileReader reader, boolean enabled) {
        this.mFileReader = enabled ? reader : null;
    }

    @Override
    public void enableIndexCaching(boolean enabled) {
        if (this.mIndex != null) {
            throw new SAMException("Unable to turn on index caching; index file has already been loaded.");
        }
        this.mEnableIndexCaching = enabled;
    }

    @Override
    public void enableIndexMemoryMapping(boolean enabled) {
        if (this.mIndex != null) {
            throw new SAMException("Unable to change index memory mapping; index file has already been loaded.");
        }
        this.mEnableIndexMemoryMapping = enabled;
    }

    @Override
    void enableCrcChecking(boolean enabled) {
        this.mCompressedInputStream.setCheckCrcs(enabled);
    }

    @Override
    void setSAMRecordFactory(SAMRecordFactory factory) {
        this.samRecordFactory = factory;
    }

    @Override
    public boolean hasIndex() {
        return this.mIndexFile != null || this.mIndexStream != null;
    }

    @Override
    public BAMIndex getIndex() {
        if (!this.hasIndex()) {
            throw new SAMException("No index is available for this BAM file.");
        }
        if (this.mIndex == null) {
            this.mIndex = this.mIndexFile != null ? (this.mEnableIndexCaching ? new CachingBAMFileIndex(this.mIndexFile, this.getFileHeader().getSequenceDictionary(), this.mEnableIndexMemoryMapping) : new DiskBasedBAMFileIndex(this.mIndexFile, this.getFileHeader().getSequenceDictionary(), this.mEnableIndexMemoryMapping)) : (this.mEnableIndexCaching ? new CachingBAMFileIndex(this.mIndexStream, this.getFileHeader().getSequenceDictionary()) : new DiskBasedBAMFileIndex(this.mIndexStream, this.getFileHeader().getSequenceDictionary()));
        }
        return this.mIndex;
    }

    @Override
    void close() {
        if (this.mStream != null) {
            this.mStream.close();
        }
        if (this.mIndex != null) {
            this.mIndex.close();
        }
        this.mStream = null;
        this.mFileHeader = null;
        this.mIndex = null;
    }

    @Override
    SAMFileHeader getFileHeader() {
        return this.mFileHeader;
    }

    @Override
    void setValidationStringency(SAMFileReader.ValidationStringency validationStringency) {
        this.mValidationStringency = validationStringency;
    }

    @Override
    SAMFileReader.ValidationStringency getValidationStringency() {
        return this.mValidationStringency;
    }

    @Override
    CloseableIterator<SAMRecord> getIterator() {
        if (this.mStream == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.mCurrentIterator != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        if (this.mIsSeekable) {
            try {
                this.mCompressedInputStream.seek(this.mFirstRecordPointer);
            }
            catch (IOException exc) {
                throw new RuntimeException(exc.getMessage(), exc);
            }
        }
        this.mCurrentIterator = new BAMFileIterator();
        return this.mCurrentIterator;
    }

    @Override
    CloseableIterator<SAMRecord> getIterator(SAMFileSpan chunks) {
        if (this.mStream == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.mCurrentIterator != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        if (!(chunks instanceof BAMFileSpan)) {
            throw new IllegalStateException("BAMFileReader cannot handle this type of file span.");
        }
        this.mCurrentIterator = new BAMFileIndexIterator(((BAMFileSpan)chunks).toCoordinateArray());
        return this.mCurrentIterator;
    }

    @Override
    SAMFileSpan getFilePointerSpanningReads() {
        return new BAMFileSpan(new Chunk(this.mFirstRecordPointer, Long.MAX_VALUE));
    }

    @Override
    CloseableIterator<SAMRecord> query(String sequence2, int start, int end, boolean contained) {
        if (this.mStream == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.mCurrentIterator != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        if (!this.mIsSeekable) {
            throw new UnsupportedOperationException("Cannot query stream-based BAM file");
        }
        int referenceIndex = this.mFileHeader.getSequenceIndex(sequence2);
        if (referenceIndex == -1) {
            this.mCurrentIterator = new EmptyBamIterator();
        } else {
            SAMFileReader.QueryInterval[] queryIntervals = new SAMFileReader.QueryInterval[]{new SAMFileReader.QueryInterval(referenceIndex, start, end)};
            this.mCurrentIterator = this.createIndexIterator(queryIntervals, contained);
        }
        return this.mCurrentIterator;
    }

    @Override
    CloseableIterator<SAMRecord> query(SAMFileReader.QueryInterval[] intervals, boolean contained) {
        if (this.mStream == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.mCurrentIterator != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        if (!this.mIsSeekable) {
            throw new UnsupportedOperationException("Cannot query stream-based BAM file");
        }
        this.mCurrentIterator = this.createIndexIterator(intervals, contained);
        return this.mCurrentIterator;
    }

    @Override
    CloseableIterator<SAMRecord> queryAlignmentStart(String sequence2, int start) {
        if (this.mStream == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.mCurrentIterator != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        if (!this.mIsSeekable) {
            throw new UnsupportedOperationException("Cannot query stream-based BAM file");
        }
        int referenceIndex = this.mFileHeader.getSequenceIndex(sequence2);
        this.mCurrentIterator = referenceIndex == -1 ? new EmptyBamIterator() : this.createStartingAtIndexIterator(referenceIndex, start);
        return this.mCurrentIterator;
    }

    @Override
    public CloseableIterator<SAMRecord> queryUnmapped() {
        if (this.mStream == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.mCurrentIterator != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        if (!this.mIsSeekable) {
            throw new UnsupportedOperationException("Cannot query stream-based BAM file");
        }
        try {
            long startOfLastLinearBin = this.getIndex().getStartOfLastLinearBin();
            if (startOfLastLinearBin != -1L) {
                this.mCompressedInputStream.seek(startOfLastLinearBin);
            } else {
                this.mCompressedInputStream.seek(this.mFirstRecordPointer);
            }
            this.mCurrentIterator = new BAMFileIndexUnmappedIterator();
            return this.mCurrentIterator;
        }
        catch (IOException e) {
            throw new RuntimeException("IOException seeking to unmapped reads", e);
        }
    }

    private void readHeader(String source) throws IOException {
        byte[] buffer = new byte[4];
        this.mStream.readBytes(buffer);
        if (!Arrays.equals(buffer, BAMFileConstants.BAM_MAGIC)) {
            throw new IOException("Invalid BAM file header");
        }
        int headerTextLength = this.mStream.readInt();
        String textHeader = this.mStream.readString(headerTextLength);
        SAMTextHeaderCodec headerCodec = new SAMTextHeaderCodec();
        headerCodec.setValidationStringency(this.mValidationStringency);
        this.mFileHeader = headerCodec.decode(new StringLineReader(textHeader), source);
        int sequenceCount = this.mStream.readInt();
        if (this.mFileHeader.getSequenceDictionary().size() > 0) {
            if (sequenceCount != this.mFileHeader.getSequenceDictionary().size()) {
                throw new SAMFormatException("Number of sequences in text header (" + this.mFileHeader.getSequenceDictionary().size() + ") != number of sequences in binary header (" + sequenceCount + ") for file " + source);
            }
            for (int i = 0; i < sequenceCount; ++i) {
                SAMSequenceRecord binarySequenceRecord = this.readSequenceRecord(source);
                SAMSequenceRecord sequenceRecord = this.mFileHeader.getSequence(i);
                if (!sequenceRecord.getSequenceName().equals(binarySequenceRecord.getSequenceName())) {
                    throw new SAMFormatException("For sequence " + i + ", text and binary have different names in file " + source);
                }
                if (sequenceRecord.getSequenceLength() == binarySequenceRecord.getSequenceLength()) continue;
                throw new SAMFormatException("For sequence " + i + ", text and binary have different lengths in file " + source);
            }
        } else {
            ArrayList<SAMSequenceRecord> sequences = new ArrayList<SAMSequenceRecord>(sequenceCount);
            for (int i = 0; i < sequenceCount; ++i) {
                sequences.add(this.readSequenceRecord(source));
            }
            this.mFileHeader.setSequenceDictionary(new SAMSequenceDictionary(sequences));
        }
    }

    private SAMSequenceRecord readSequenceRecord(String source) {
        int nameLength = this.mStream.readInt();
        if (nameLength <= 1) {
            throw new SAMFormatException("Invalid BAM file header: missing sequence name in file " + source);
        }
        String sequenceName = this.mStream.readString(nameLength - 1);
        this.mStream.readByte();
        int sequenceLength = this.mStream.readInt();
        return new SAMSequenceRecord(SAMSequenceRecord.truncateSequenceName(sequenceName), sequenceLength);
    }

    private CloseableIterator<SAMRecord> createStartingAtIndexIterator(int referenceIndex, int start) {
        BAMIndex fileIndex = this.getIndex();
        BAMFileSpan fileSpan = fileIndex.getSpanOverlapping(referenceIndex, start, 0);
        long[] filePointers = fileSpan != null ? fileSpan.toCoordinateArray() : null;
        BAMFileIndexIterator iterator2 = new BAMFileIndexIterator(filePointers);
        return new BAMQueryFilteringIterator(iterator2, new BAMStartingAtIteratorFilter(referenceIndex, start));
    }

    private void assertIntervalsOptimized(SAMFileReader.QueryInterval[] intervals) {
        if (intervals.length == 0) {
            return;
        }
        for (int i = 1; i < intervals.length; ++i) {
            SAMFileReader.QueryInterval prev = intervals[i - 1];
            SAMFileReader.QueryInterval thisInterval = intervals[i];
            if (prev.compareTo(thisInterval) >= 0) {
                throw new IllegalArgumentException(String.format("List of intervals is not sorted: %s >= %s", prev, thisInterval));
            }
            if (prev.overlaps(thisInterval)) {
                throw new IllegalArgumentException(String.format("List of intervals is not optimized: %s intersects %s", prev, thisInterval));
            }
            if (!prev.abuts(thisInterval)) continue;
            throw new IllegalArgumentException(String.format("List of intervals is not optimized: %s abuts %s", prev, thisInterval));
        }
    }

    private CloseableIterator<SAMRecord> createIndexIterator(SAMFileReader.QueryInterval[] intervals, boolean contained) {
        this.assertIntervalsOptimized(intervals);
        BAMFileSpan[] inputSpans = new BAMFileSpan[intervals.length];
        BAMIndex fileIndex = this.getIndex();
        for (int i = 0; i < intervals.length; ++i) {
            BAMFileSpan span2;
            SAMFileReader.QueryInterval interval = intervals[i];
            inputSpans[i] = span2 = fileIndex.getSpanOverlapping(interval.referenceIndex, interval.start, interval.end);
        }
        long[] filePointers = inputSpans.length > 0 ? BAMFileSpan.merge(inputSpans).toCoordinateArray() : null;
        BAMFileIndexIterator iterator2 = new BAMFileIndexIterator(filePointers);
        return new BAMQueryFilteringIterator(iterator2, new BAMQueryMultipleIntervalsIteratorFilter(intervals, contained));
    }

    private static File findIndexFile(File dataFile) {
        File indexFile;
        String bamExtension = ".bam";
        String fileName = dataFile.getName();
        if (fileName.endsWith(".bam")) {
            String bai = fileName.substring(0, fileName.length() - ".bam".length()) + ".bai";
            indexFile = new File(dataFile.getParent(), bai);
            if (indexFile.exists()) {
                return indexFile;
            }
        }
        if ((indexFile = new File(dataFile.getParent(), dataFile.getName() + ".bai")).exists()) {
            return indexFile;
        }
        return null;
    }

    private static enum FilteringIteratorState {
        MATCHES_FILTER,
        STOP_ITERATION,
        CONTINUE_ITERATION;

    }

    private static enum IntervalComparison {
        BEFORE,
        AFTER,
        OVERLAPPING,
        CONTAINED;

    }

    private class BAMQueryMultipleIntervalsIteratorFilter
    implements BAMIteratorFilter {
        final SAMFileReader.QueryInterval[] intervals;
        final boolean contained;
        int intervalIndex = 0;

        public BAMQueryMultipleIntervalsIteratorFilter(SAMFileReader.QueryInterval[] intervals, boolean contained) {
            this.contained = contained;
            this.intervals = intervals;
        }

        @Override
        public FilteringIteratorState compareToFilter(SAMRecord record) {
            while (this.intervalIndex < this.intervals.length) {
                IntervalComparison comparison = this.compareIntervalToRecord(this.intervals[this.intervalIndex], record);
                switch (comparison) {
                    case BEFORE: {
                        ++this.intervalIndex;
                        break;
                    }
                    case AFTER: {
                        return FilteringIteratorState.CONTINUE_ITERATION;
                    }
                    case CONTAINED: {
                        return FilteringIteratorState.MATCHES_FILTER;
                    }
                    case OVERLAPPING: {
                        return this.contained ? FilteringIteratorState.CONTINUE_ITERATION : FilteringIteratorState.MATCHES_FILTER;
                    }
                }
            }
            return FilteringIteratorState.STOP_ITERATION;
        }

        private IntervalComparison compareIntervalToRecord(SAMFileReader.QueryInterval interval, SAMRecord record) {
            int intervalEnd;
            int n = intervalEnd = interval.end <= 0 ? Integer.MAX_VALUE : interval.end;
            if (interval.referenceIndex < record.getReferenceIndex()) {
                return IntervalComparison.BEFORE;
            }
            if (interval.referenceIndex > record.getReferenceIndex()) {
                return IntervalComparison.AFTER;
            }
            if (intervalEnd < record.getAlignmentStart()) {
                return IntervalComparison.BEFORE;
            }
            if (record.getAlignmentEnd() < interval.start) {
                return IntervalComparison.AFTER;
            }
            if (CoordMath.encloses(interval.start, intervalEnd, record.getAlignmentStart(), record.getAlignmentEnd())) {
                return IntervalComparison.CONTAINED;
            }
            return IntervalComparison.OVERLAPPING;
        }
    }

    private class BAMFileIndexUnmappedIterator
    extends BAMFileIterator {
        private BAMFileIndexUnmappedIterator() {
            while (this.hasNext() && this.peek().getReferenceIndex() != -1) {
                this.advance();
            }
        }
    }

    private class BAMStartingAtIteratorFilter
    implements BAMIteratorFilter {
        private final int mReferenceIndex;
        private final int mRegionStart;

        public BAMStartingAtIteratorFilter(int referenceIndex, int start) {
            this.mReferenceIndex = referenceIndex;
            this.mRegionStart = start;
        }

        @Override
        public FilteringIteratorState compareToFilter(SAMRecord record) {
            int referenceIndex = record.getReferenceIndex();
            if (referenceIndex < 0 || referenceIndex > this.mReferenceIndex) {
                return FilteringIteratorState.STOP_ITERATION;
            }
            if (referenceIndex < this.mReferenceIndex) {
                return FilteringIteratorState.CONTINUE_ITERATION;
            }
            int alignmentStart = record.getAlignmentStart();
            if (alignmentStart > this.mRegionStart) {
                return FilteringIteratorState.STOP_ITERATION;
            }
            if (alignmentStart == this.mRegionStart) {
                return FilteringIteratorState.MATCHES_FILTER;
            }
            return FilteringIteratorState.CONTINUE_ITERATION;
        }
    }

    static interface BAMIteratorFilter {
        public FilteringIteratorState compareToFilter(SAMRecord var1);
    }

    public class BAMQueryFilteringIterator
    extends AbstractBamIterator {
        protected final CloseableIterator<SAMRecord> wrappedIterator;
        protected SAMRecord mNextRecord;
        private final BAMIteratorFilter iteratorFilter;

        public BAMQueryFilteringIterator(CloseableIterator<SAMRecord> iterator2, BAMIteratorFilter iteratorFilter) {
            this.wrappedIterator = iterator2;
            this.iteratorFilter = iteratorFilter;
            this.mNextRecord = this.advance();
        }

        @Override
        public boolean hasNext() {
            this.assertOpen();
            return this.mNextRecord != null;
        }

        @Override
        public SAMRecord next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("BAMQueryFilteringIterator: no next element available");
            }
            SAMRecord currentRead = this.mNextRecord;
            this.mNextRecord = this.advance();
            return currentRead;
        }

        SAMRecord advance() {
            block5: while (true) {
                if (!this.wrappedIterator.hasNext()) {
                    return null;
                }
                SAMRecord record = (SAMRecord)this.wrappedIterator.next();
                switch (this.iteratorFilter.compareToFilter(record)) {
                    case MATCHES_FILTER: {
                        return record;
                    }
                    case STOP_ITERATION: {
                        return null;
                    }
                    case CONTINUE_ITERATION: {
                        continue block5;
                    }
                }
                break;
            }
            throw new SAMException("Unexpected return from compareToFilter");
        }
    }

    private class BAMFileIndexIterator
    extends BAMFileIterator {
        private long[] mFilePointers;
        private int mFilePointerIndex;
        private long mFilePointerLimit;

        BAMFileIndexIterator(long[] filePointers) {
            super(false);
            this.mFilePointers = null;
            this.mFilePointerIndex = 0;
            this.mFilePointerLimit = -1L;
            this.mFilePointers = filePointers;
            this.advance();
        }

        @Override
        SAMRecord getNextRecord() throws IOException {
            while (BAMFileReader.this.mCompressedInputStream.getFilePointer() >= this.mFilePointerLimit) {
                if (this.mFilePointers == null || this.mFilePointerIndex >= this.mFilePointers.length) {
                    return null;
                }
                long startOffset = this.mFilePointers[this.mFilePointerIndex++];
                long endOffset = this.mFilePointers[this.mFilePointerIndex++];
                BAMFileReader.this.mCompressedInputStream.seek(startOffset);
                this.mFilePointerLimit = endOffset;
            }
            return super.getNextRecord();
        }
    }

    private class BAMFileIterator
    extends AbstractBamIterator {
        private SAMRecord mNextRecord;
        private final BAMRecordCodec bamRecordCodec;
        private long samRecordIndex;

        BAMFileIterator() {
            this(true);
        }

        BAMFileIterator(boolean advance) {
            this.mNextRecord = null;
            this.samRecordIndex = 0L;
            this.bamRecordCodec = new BAMRecordCodec(BAMFileReader.this.getFileHeader(), BAMFileReader.this.samRecordFactory);
            this.bamRecordCodec.setInputStream(BAMFileReader.this.mStream.getInputStream(), BAMFileReader.this.mStream.getInputFileName());
            if (advance) {
                this.advance();
            }
        }

        @Override
        public boolean hasNext() {
            this.assertOpen();
            return this.mNextRecord != null;
        }

        @Override
        public SAMRecord next() {
            this.assertOpen();
            SAMRecord result2 = this.mNextRecord;
            this.advance();
            return result2;
        }

        void advance() {
            try {
                this.mNextRecord = this.getNextRecord();
                if (this.mNextRecord != null) {
                    ++this.samRecordIndex;
                    this.mNextRecord.setValidationStringency(BAMFileReader.this.mValidationStringency);
                    if (BAMFileReader.this.mValidationStringency != SAMFileReader.ValidationStringency.SILENT) {
                        List<SAMValidationError> validationErrors = this.mNextRecord.isValid();
                        SAMUtils.processValidationErrors(validationErrors, this.samRecordIndex, BAMFileReader.this.getValidationStringency());
                    }
                }
                if (BAMFileReader.this.eagerDecode && this.mNextRecord != null) {
                    this.mNextRecord.eagerDecode();
                }
            }
            catch (IOException exc) {
                throw new RuntimeException(exc.getMessage(), exc);
            }
        }

        SAMRecord getNextRecord() throws IOException {
            long startCoordinate = BAMFileReader.this.mCompressedInputStream.getFilePointer();
            SAMRecord next2 = this.bamRecordCodec.decode();
            long stopCoordinate = BAMFileReader.this.mCompressedInputStream.getFilePointer();
            if (BAMFileReader.this.mFileReader != null && next2 != null) {
                next2.setFileSource(new SAMFileSource(BAMFileReader.this.mFileReader, new BAMFileSpan(new Chunk(startCoordinate, stopCoordinate))));
            }
            return next2;
        }

        protected SAMRecord peek() {
            return this.mNextRecord;
        }
    }

    private class EmptyBamIterator
    extends AbstractBamIterator {
        private EmptyBamIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public SAMRecord next() {
            throw new NoSuchElementException("next called on empty iterator");
        }
    }

    private abstract class AbstractBamIterator
    implements CloseableIterator<SAMRecord> {
        private boolean isClosed = false;

        private AbstractBamIterator() {
        }

        @Override
        public void close() {
            if (!this.isClosed) {
                if (BAMFileReader.this.mCurrentIterator != null && this != BAMFileReader.this.mCurrentIterator) {
                    throw new IllegalStateException("Attempt to close non-current iterator");
                }
                BAMFileReader.this.mCurrentIterator = null;
                this.isClosed = true;
            }
        }

        protected void assertOpen() {
            if (this.isClosed) {
                throw new AssertionError((Object)"Iterator has been closed");
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported: remove");
        }
    }
}

