/*
 * Decompiled with CFR 0.152.
 */
package DistLib;

import DistLib.beta;
import DistLib.misc;

public class noncentral_beta {
    public static double density(double x2, double a, double b, double lambda) {
        double eps = 1.0E-14;
        int maxiter = 200;
        if (Double.isNaN(x2) || Double.isNaN(a) || Double.isNaN(b) || Double.isNaN(lambda)) {
            return x2 + a + b + lambda;
        }
        if (lambda < 0.0 || a <= 0.0 || b <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (Double.isInfinite(a) || Double.isInfinite(b) || Double.isInfinite(lambda)) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 <= 0.0) {
            return 0.0;
        }
        double term = beta.density(x2, a, b);
        if (lambda == 0.0) {
            return term;
        }
        double lambda2 = 0.5 * lambda;
        double weight = Math.exp(-lambda2);
        double sum2 = weight * term;
        double psum = weight;
        double k = 1.0;
        while (k <= 200.0) {
            weight = weight * lambda2 / k;
            term = term * x2 * (a + b) / a;
            sum2 += weight * term;
            a += 1.0;
            if (1.0 - (psum += weight) < 1.0E-14) break;
            k += 1.0;
        }
        return sum2;
    }

    public static double cumulative(double x2, double a, double b, double lambda) {
        double errbd;
        double zero2 = 0.0;
        double one = 1.0;
        double half = 0.5;
        double ualpha = 5.0;
        double errmax = 1.0E-6;
        int itrmax = 100;
        if (Double.isNaN(x2) || Double.isNaN(a) || Double.isNaN(b) || Double.isNaN(lambda)) {
            return x2 + a + b + lambda;
        }
        if (lambda < 0.0 || a <= 0.0 || b <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 <= 0.0) {
            return 0.0;
        }
        if (x2 >= 1.0) {
            return 1.0;
        }
        double c = lambda * 0.5;
        double x0 = Math.floor(Math.max(c - 5.0 * Math.sqrt(c), 0.0));
        double a0 = a + x0;
        double lbeta = misc.lgammafn(a0) + misc.lgammafn(b) - misc.lgammafn(a0 + b);
        double temp = beta.cumulative(x2, a0, b);
        double gx = Math.exp(a0 * Math.log(x2) + b * Math.log(1.0 - x2) - lbeta - Math.log(a0));
        double q = a0 > a ? Math.exp(-c + x0 * Math.log(c) - misc.lgammafn(x0 + 1.0)) : Math.exp(-c);
        double ax = q * temp;
        double sumq = 1.0 - q;
        double ans = ax;
        int j = 0;
        do {
            ax = (temp += -(gx *= x2 * (a + b + (double)(++j) - 1.0) / (a + (double)j))) * q;
            ans += ax;
        } while ((errbd = (temp - gx) * (sumq += -(q *= c / (double)j))) > 1.0E-6 && j < 100);
        if (errbd > 1.0E-6) {
            throw new ArithmeticException("Math Error: PRECISION");
        }
        return ans;
    }
}

