/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.commandLine.SnpEffCmdEff;
import org.snpeff.snpEffect.testCases.integration.TestCasesIntegrationBase;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.EffFormatVersion;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;

public class TestCasesIntegrationDup
extends TestCasesIntegrationBase {
    @Test
    public void test_01_dup() {
        Gpr.debug("Test");
        String genome = "testHg19Chr8";
        String vcf = "tests/dup_01.vcf";
        String[] args = new String[]{genome, vcf};
        SnpEffCmdEff snpeff = new SnpEffCmdEff();
        snpeff.parseArgs(args);
        snpeff.setDebug(this.debug);
        snpeff.setVerbose(this.verbose);
        snpeff.setSupressOutput(!this.verbose);
        snpeff.setFormatVersion(EffFormatVersion.FORMAT_ANN_1);
        snpeff.setUpDownStreamLength(0);
        List<VcfEntry> results = snpeff.run(true);
        VcfEntry ve = results.get(0);
        boolean found = false;
        for (VcfEffect veff : ve.getVcfEffects()) {
            if (this.verbose) {
                System.out.println("\t" + (Object)((Object)veff.getEffectType()) + "\t" + veff);
            }
            if (veff.getEffectType() != EffectType.CHROMOSOME_LARGE_DUPLICATION) continue;
            found |= veff.getGeneName().contains("FGFR1");
        }
        Assert.assertTrue("Gene FGFR1 not found in <DUP>", found);
    }
}

