/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.commandLine.eff;

import org.snpeff.akka.vcfStr.WorkerVcfStr;
import org.snpeff.interval.Variant;
import org.snpeff.interval.tree.IntervalForest;
import org.snpeff.outputFormatter.OutputFormatter;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.snpEffect.commandLine.SnpEffCmdEff;
import org.snpeff.vcf.VcfEntry;

public class WorkerEff
extends WorkerVcfStr {
    SnpEffCmdEff snpEffCmdEff;
    SnpEffectPredictor snpEffectPredictor;
    OutputFormatter outputFormatter;
    IntervalForest filterIntervals;

    public WorkerEff(SnpEffCmdEff snpEffCmdEff, SnpEffectPredictor snpEffectPredictor, OutputFormatter outputFormatter, IntervalForest filterIntervals) {
        this.snpEffCmdEff = snpEffCmdEff;
        this.snpEffectPredictor = snpEffectPredictor;
        this.outputFormatter = outputFormatter;
        this.filterIntervals = filterIntervals;
    }

    @Override
    public String calculate(VcfEntry vcfEntry) {
        if (vcfEntry == null) {
            return null;
        }
        try {
            vcfEntry.parse();
            if (this.filterIntervals != null && this.filterIntervals.query(vcfEntry).isEmpty()) {
                return null;
            }
            this.outputFormatter.startSection(vcfEntry);
            for (Variant variant : vcfEntry.variants()) {
                if (!variant.isVariant()) continue;
                VariantEffects variantEffects = this.snpEffectPredictor.variantEffect(variant);
                this.outputFormatter.startSection(variant);
                for (VariantEffect changeEffect : variantEffects) {
                    this.outputFormatter.add(changeEffect);
                }
                this.outputFormatter.endSection(variant);
            }
            this.outputFormatter.endSection(vcfEntry);
        }
        catch (Throwable t2) {
            this.snpEffCmdEff.error(t2, "Error while processing VCF entry (line " + vcfEntry.getLineNum() + ") :\n\t" + vcfEntry);
            t2.printStackTrace();
        }
        return vcfEntry.toString();
    }
}

