/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.scop;

import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.structure.scop.BerkeleyScopInstallation;
import org.biojava.bio.structure.scop.RemoteScopInstallation;
import org.biojava.bio.structure.scop.ScopDatabase;
import org.biojava.bio.structure.scop.ScopInstallation;

public class ScopFactory {
    private static ScopDatabase scop = new RemoteScopInstallation();
    public static final String VERSION_1_75A = "1.75A";
    public static final String VERSION_1_75B = "1.75B";
    public static final String VERSION_1_75 = "1.75";
    static Map<String, ScopDatabase> versionedScopDBs = new HashMap<String, ScopDatabase>();

    public static ScopDatabase getSCOP() {
        return scop;
    }

    public static void setScopDatabase(String s) {
        ScopFactory.setScopDatabase(ScopFactory.getSCOP(s));
    }

    public static void setScopDatabase(ScopDatabase s) {
        System.out.println("Setting ScopDatabase to type: " + s.getClass().getName());
        scop = s;
    }

    public static ScopDatabase getSCOP(String version, boolean useLocalData) {
        if (useLocalData) {
            if (version.equalsIgnoreCase(VERSION_1_75A)) {
                return ScopFactory.getBerkeley_1_75A();
            }
            if (version.equalsIgnoreCase(VERSION_1_75B)) {
                return ScopFactory.getBerkeley_1_75B();
            }
            if (version.equalsIgnoreCase(VERSION_1_75)) {
                ScopFactory.getScop_1_75();
            } else {
                ScopFactory.getScop_1_75();
            }
        } else {
            return scop;
        }
        return scop;
    }

    private static ScopDatabase getScop_1_75() {
        ScopInstallation scop = (ScopInstallation)versionedScopDBs.get(VERSION_1_75);
        if (scop == null) {
            scop = new ScopInstallation();
            scop.setScopVersion(VERSION_1_75);
            versionedScopDBs.put(VERSION_1_75, scop);
        }
        return scop;
    }

    public static ScopDatabase getSCOP(String version) {
        if (version.equalsIgnoreCase(VERSION_1_75A)) {
            return ScopFactory.getBerkeley_1_75A();
        }
        if (version.equalsIgnoreCase(VERSION_1_75B)) {
            return ScopFactory.getBerkeley_1_75B();
        }
        if (version.equalsIgnoreCase(VERSION_1_75)) {
            return ScopFactory.getScop_1_75();
        }
        System.err.println("Unknown SCOP version " + version + " . Returning default");
        return scop;
    }

    private static ScopDatabase getBerkeley_1_75A() {
        BerkeleyScopInstallation berkeley_1_75A = (BerkeleyScopInstallation)versionedScopDBs.get(VERSION_1_75A);
        if (berkeley_1_75A == null) {
            berkeley_1_75A = new BerkeleyScopInstallation();
            berkeley_1_75A.setScopVersion(VERSION_1_75A);
            versionedScopDBs.put(VERSION_1_75A, berkeley_1_75A);
        }
        return berkeley_1_75A;
    }

    private static ScopDatabase getBerkeley_1_75B() {
        BerkeleyScopInstallation berkeley_1_75B = (BerkeleyScopInstallation)versionedScopDBs.get(VERSION_1_75B);
        if (berkeley_1_75B == null) {
            berkeley_1_75B = new BerkeleyScopInstallation();
            berkeley_1_75B.setScopVersion(VERSION_1_75B);
            versionedScopDBs.put(VERSION_1_75B, berkeley_1_75B);
        }
        return berkeley_1_75B;
    }
}

