/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.exception;

import org.apache.commons.math3.exception.MathIllegalNumberException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.MathArrays;

public class NonMonotonicSequenceException
extends MathIllegalNumberException {
    private static final long serialVersionUID = 3596849179428944575L;
    private final MathArrays.OrderDirection direction;
    private final boolean strict;
    private final int index;
    private final Number previous;

    public NonMonotonicSequenceException(Number wrong, Number previous, int index2) {
        this(wrong, previous, index2, MathArrays.OrderDirection.INCREASING, true);
    }

    public NonMonotonicSequenceException(Number wrong, Number previous, int index2, MathArrays.OrderDirection direction, boolean strict) {
        super((Localizable)(direction == MathArrays.OrderDirection.INCREASING ? (strict ? LocalizedFormats.NOT_STRICTLY_INCREASING_SEQUENCE : LocalizedFormats.NOT_INCREASING_SEQUENCE) : (strict ? LocalizedFormats.NOT_STRICTLY_DECREASING_SEQUENCE : LocalizedFormats.NOT_DECREASING_SEQUENCE)), wrong, previous, index2, index2 - 1);
        this.direction = direction;
        this.strict = strict;
        this.index = index2;
        this.previous = previous;
    }

    public MathArrays.OrderDirection getDirection() {
        return this.direction;
    }

    public boolean getStrict() {
        return this.strict;
    }

    public int getIndex() {
        return this.index;
    }

    public Number getPrevious() {
        return this.previous;
    }
}

