/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.charts4j.parameters;

import com.googlecode.charts4j.Data;
import com.googlecode.charts4j.DataEncoding;
import com.googlecode.charts4j.collect.Lists;
import com.googlecode.charts4j.parameters.AbstractParameter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;

final class DataParameter
extends AbstractParameter {
    private static final String URL_PARAMETER_KEY = "chd";
    private final DecimalFormat decimalFormatter = new DecimalFormat("##0.0", new DecimalFormatSymbols(Locale.US));
    private static final char[] EXTENDED_ENCODING_CHARS;
    private static final char[] SIMPLE_ENCODING_CHARS;
    private static final String[] EXTENDED_ENCODING;
    private static final String[] SIMPLE_ENCODING;
    private final List<Data> datas = Lists.newLinkedList();
    private DataEncoding dataEncoding = DataEncoding.EXTENDED;

    DataParameter() {
    }

    void addData(Data data2) {
        this.datas.add(data2);
    }

    DataEncoding getDataEncoding() {
        return this.dataEncoding;
    }

    void setDataEncoding(DataEncoding dataEncoding) {
        this.dataEncoding = dataEncoding;
    }

    private String extendedEncoding(double[] data2) {
        if (data2 == null || data2.length == 0) {
            return "";
        }
        StringBuilder encodedData = new StringBuilder();
        for (double datum : data2) {
            int index = (int)(datum >= 0.0 && datum <= 100.0 ? Math.round(datum / 100.0 * (double)(EXTENDED_ENCODING.length - 1)) : -1L);
            encodedData.append(index < 0 || index > EXTENDED_ENCODING.length - 1 ? "__" : EXTENDED_ENCODING[index]);
        }
        return encodedData.toString();
    }

    private String simpleEncoding(double[] data2) {
        if (data2 == null || data2.length == 0) {
            return "";
        }
        StringBuilder encodedData = new StringBuilder();
        for (double datum : data2) {
            int index = (int)(datum >= 0.0 && datum <= 100.0 ? Math.round(datum / 100.0 * (double)(SIMPLE_ENCODING.length - 1)) : -1L);
            encodedData.append(index < 0 || index > SIMPLE_ENCODING.length - 1 ? "_" : SIMPLE_ENCODING[index]);
        }
        return encodedData.toString();
    }

    private String textEncoding(double[] data2) {
        if (data2 == null || data2.length == 0) {
            return "";
        }
        StringBuilder encodedData = new StringBuilder();
        int count2 = 0;
        for (double datum : data2) {
            encodedData.append(count2++ > 0 ? "," : "").append(datum >= 0.0 && datum <= 100.0 ? this.decimalFormatter.format(datum) : "-1");
        }
        return encodedData.toString();
    }

    public String getKey() {
        return URL_PARAMETER_KEY;
    }

    public String getValue() {
        StringBuilder sb = new StringBuilder((Object)((Object)this.dataEncoding) + "");
        String seperator = this.dataEncoding.equals((Object)DataEncoding.TEXT) ? "|" : ",";
        int cnt = 0;
        for (Data data2 : this.datas) {
            String dataString = this.dataEncoding.equals((Object)DataEncoding.SIMPLE) ? this.simpleEncoding(data2.getData()) : (this.dataEncoding.equals((Object)DataEncoding.TEXT) ? this.textEncoding(data2.getData()) : this.extendedEncoding(data2.getData()));
            sb.append(cnt++ > 0 ? seperator : "").append(dataString);
        }
        return sb.toString();
    }

    static {
        int i;
        EXTENDED_ENCODING_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '.'};
        SIMPLE_ENCODING_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        EXTENDED_ENCODING = new String[4096];
        SIMPLE_ENCODING = new String[62];
        int cnt = 0;
        for (i = 0; i < EXTENDED_ENCODING_CHARS.length; ++i) {
            for (int j = 0; j < EXTENDED_ENCODING_CHARS.length; ++j) {
                DataParameter.EXTENDED_ENCODING[cnt++] = EXTENDED_ENCODING_CHARS[i] + "" + EXTENDED_ENCODING_CHARS[j];
            }
        }
        cnt = 0;
        for (i = 0; i < SIMPLE_ENCODING_CHARS.length; ++i) {
            DataParameter.SIMPLE_ENCODING[cnt++] = SIMPLE_ENCODING_CHARS[i] + "";
        }
    }
}

