/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.vcf;

import org.snpeff.util.Gpr;

public class LineChrPos
implements Comparable<LineChrPos> {
    String chr;
    int chrNum;
    int pos;
    byte[] line;

    public LineChrPos(String str) {
        this.line = str.getBytes();
        this.parse(str);
    }

    @Override
    public int compareTo(LineChrPos lp) {
        int cmp = 0;
        if (this.chrNum > 0 && lp.chrNum > 0) {
            cmp = this.chrNum - lp.chrNum;
        } else {
            if (this.chrNum > 0) {
                return -1;
            }
            if (lp.chrNum > 0) {
                return 1;
            }
            cmp = this.chr.compareTo(lp.chr);
        }
        if (cmp != 0) {
            return cmp;
        }
        return this.pos - lp.pos;
    }

    public String getLine() {
        return new String(this.line);
    }

    void parse(String str) {
        String[] fields = str.split("\t", 3);
        if (fields.length < 2) {
            throw new RuntimeException("Cannot parse line:\t" + str);
        }
        this.chr = fields[0];
        this.chrNum = Gpr.parseIntSafe(fields[0]);
        this.pos = Gpr.parseIntSafe(fields[1]);
    }

    public String toString() {
        return (this.chrNum > 0 ? this.chrNum + "[number]" : this.chr + "[string]") + ":" + this.pos + "\t" + new String(this.line);
    }
}

