/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.Install;
import installer.InstallThread;
import installer.OperatingSystem;
import installer.Page;
import installer.Progress;
import installer.Wizard;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class SwingInstall
extends JFrame {
    private Install installer;
    private Wizard wizard;
    private OperatingSystem.ScriptParameters scriptParams;
    private SelectProgramPackages selectPackages;

    public SwingInstall() {
        System.out.print("Loading installer...");
        this.installer = new Install();
        this.scriptParams = new OperatingSystem.ScriptParameters();
        System.out.print(".");
        this.setTitle("jPicEdt " + this.installer.getVersion() + " installer");
        System.out.print(".");
        this.wizard = new InstallWizard();
        this.getContentPane().add("Center", this.wizard);
        System.out.print(".");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        System.out.print(".");
        Dimension screen = this.getToolkit().getScreenSize();
        this.pack();
        System.out.println(".");
        this.setLocation((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2);
        this.show();
    }

    private class SwingProgress
    extends Page
    implements ActionListener,
    Progress {
        private JLabel messageLBL;
        private JProgressBar progressPB;
        private JButton stopBT;
        private InstallThread thread;

        public SwingProgress() {
            super(new BorderLayout());
            System.out.print(".");
            this.setBorder(new EmptyBorder(12, 12, 12, 12));
            this.messageLBL = new JLabel("Installing JPicEdt ...");
            this.messageLBL.setBorder(new EmptyBorder(0, 0, 12, 0));
            this.add("North", this.messageLBL);
            this.progressPB = new JProgressBar();
            this.progressPB.setStringPainted(true);
            this.add("Center", this.progressPB);
            this.stopBT = new JButton("Stop");
            this.stopBT.addActionListener(this);
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 0));
            panel.setBorder(new EmptyBorder(12, 0, 0, 0));
            panel.add(Box.createGlue());
            panel.add(this.stopBT);
            panel.add(Box.createGlue());
            this.add("South", panel);
        }

        public void madeVisible() {
            Vector<String> components = new Vector<String>();
            int size = 0;
            JPanel comp = ((SwingInstall)SwingInstall.this).selectPackages.comp;
            for (int i = 0; i < comp.getComponentCount(); ++i) {
                if (!((JCheckBox)comp.getComponent(i)).getModel().isSelected()) continue;
                size += SwingInstall.this.installer.getIntProperty("comp." + i + ".size");
                components.addElement(SwingInstall.this.installer.getProperty("comp." + i + ".fileset"));
            }
            InstallThread thread = new InstallThread(SwingInstall.this.installer, this, SwingInstall.this.scriptParams, size, components);
            this.setThread(thread);
            thread.start();
        }

        public boolean canPreviousPage() {
            return false;
        }

        public String getNextButtonLabel() {
            return "View readme file";
        }

        public void showMessage(String msg) {
            SwingUtilities.invokeLater(new Runnable(this, msg){
                private final /* synthetic */ String val$msg;
                private final /* synthetic */ SwingProgress this$1;
                {
                    this.this$1 = this$1;
                    this.val$msg = val$msg;
                }

                public void run() {
                    SwingProgress.access$400(this.this$1).setText(this.val$msg);
                }
            });
        }

        public void setMaximum(int max) {
            SwingUtilities.invokeLater(new Runnable(this, max){
                private final /* synthetic */ int val$max;
                private final /* synthetic */ SwingProgress this$1;
                {
                    this.this$1 = this$1;
                    this.val$max = val$max;
                }

                public void run() {
                    SwingProgress.access$500(this.this$1).setMaximum(this.val$max);
                }
            });
        }

        public void advance(int value) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(this, value){
                    private final /* synthetic */ int val$value;
                    private final /* synthetic */ SwingProgress this$1;
                    {
                        this.this$1 = this$1;
                        this.val$value = val$value;
                    }

                    public void run() {
                        SwingProgress.access$500(this.this$1).setValue(SwingProgress.access$500(this.this$1).getValue() + this.val$value);
                    }
                });
                Thread.yield();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void done() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ SwingProgress this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    this.this$1.showMessage("jPicEdt was installed successfully.\n");
                    SwingProgress.access$600(this.this$1).setText("Finish");
                }
            });
        }

        public void error(String message) {
            SwingUtilities.invokeLater(new Runnable(this, message){
                private final /* synthetic */ String val$message;
                private final /* synthetic */ SwingProgress this$1;
                {
                    this.this$1 = this$1;
                    this.val$message = val$message;
                }

                public void run() {
                    SwingProgress.access$700(this.this$1).dispose();
                    JOptionPane.showMessageDialog(null, this.val$message, "Installation aborted", 0);
                    System.exit(1);
                }
            });
        }

        public void setThread(InstallThread thread) {
            this.thread = thread;
        }

        public void actionPerformed(ActionEvent evt) {
            if (this.stopBT.getText().equals("Stop")) {
                this.stopBT.getModel().setEnabled(false);
                this.thread.kill();
                SwingInstall.this.dispose();
                JOptionPane.showMessageDialog(null, "Installation aborted.", "Installation aborted", 0);
                System.exit(1);
            } else {
                SwingInstall.this.dispose();
                System.exit(0);
            }
        }

        static /* synthetic */ JLabel access$400(SwingProgress x0) {
            return x0.messageLBL;
        }

        static /* synthetic */ JProgressBar access$500(SwingProgress x0) {
            return x0.progressPB;
        }

        static /* synthetic */ JButton access$600(SwingProgress x0) {
            return x0.stopBT;
        }

        static /* synthetic */ SwingInstall access$700(SwingProgress x0) {
            return x0.SwingInstall.this;
        }
    }

    private class SelectProgramPackages
    extends Page
    implements ActionListener {
        JPanel comp;
        JLabel sizeLabel;

        SelectProgramPackages() {
            super(new BorderLayout());
            JLabel caption = new JLabel("Program components to install:");
            Font font = caption.getFont();
            caption.setFont(new Font(font.getFamily(), font.getStyle(), 18));
            this.add("North", caption);
            Box box = new Box(1);
            box.add(Box.createGlue());
            this.comp = this.createCompPanel();
            box.add(this.comp);
            box.add(Box.createGlue());
            this.add("Center", box);
            this.sizeLabel = new JLabel("", 2);
            this.add("South", this.sizeLabel);
            this.updateSize();
        }

        public String getNextButtonLabel() {
            return "Install";
        }

        public void actionPerformed(ActionEvent evt) {
            this.updateSize();
        }

        private JPanel createCompPanel() {
            int count = SwingInstall.this.installer.getIntProperty("comp.count");
            JPanel panel = new JPanel(new GridLayout(count, 1));
            for (int i = 0; i < count; ++i) {
                JCheckBox checkBox = new JCheckBox(SwingInstall.this.installer.getProperty("comp." + i + ".name") + " (" + SwingInstall.this.installer.getProperty("comp." + i + ".size") + "Kb)");
                checkBox.getModel().setSelected(true);
                checkBox.setToolTipText(SwingInstall.this.installer.getProperty("comp." + i + ".tooltip"));
                checkBox.addActionListener(this);
                checkBox.setRequestFocusEnabled(false);
                panel.add(checkBox);
            }
            Dimension dim = panel.getPreferredSize();
            dim.width = Integer.MAX_VALUE;
            panel.setMaximumSize(dim);
            return panel;
        }

        private void updateSize() {
            int size = 0;
            for (int i = 0; i < this.comp.getComponentCount(); ++i) {
                if (!((JCheckBox)this.comp.getComponent(i)).getModel().isSelected()) continue;
                size += SwingInstall.this.installer.getIntProperty("comp." + i + ".size");
            }
            this.sizeLabel.setText("Estimated disk usage of selected components: " + size + "Kb");
        }
    }

    private class ChooseDirectory
    extends Page
    implements ActionListener {
        private JTextField installDirTF;
        private JTextField binDirTF;
        private JButton chooseInstallBT;
        private JButton chooseBinBT;
        private JLabel osLBL;

        ChooseDirectory() {
            super(new BorderLayout());
            JLabel caption = new JLabel("jPicEdt installation directories...");
            Font font = caption.getFont();
            caption.setFont(new Font(font.getFamily(), font.getStyle(), 18));
            this.add("North", caption);
            Box box = new Box(1);
            this.osLBL = new JLabel("Operating System : " + OperatingSystem.getOperatingSystem());
            box.add(this.osLBL);
            JPanel directoryPanel = new JPanel();
            GridBagLayout layout = new GridBagLayout();
            directoryPanel.setLayout(layout);
            GridBagConstraints cons = new GridBagConstraints();
            cons.anchor = 17;
            cons.fill = 2;
            cons.gridy = 1;
            cons.insets = new Insets(0, 0, 6, 0);
            JLabel label = new JLabel("Install program in: ", 4);
            label.setBorder(new EmptyBorder(0, 0, 0, 12));
            layout.setConstraints(label, cons);
            directoryPanel.add(label);
            cons.weightx = 1.0;
            this.installDirTF = new JTextField();
            this.installDirTF.setText(OperatingSystem.getOperatingSystem().getInstallDirectory(SwingInstall.this.installer.getVersion()));
            layout.setConstraints(this.installDirTF, cons);
            directoryPanel.add(this.installDirTF);
            String binDir = OperatingSystem.getOperatingSystem().getShortcutDirectory(SwingInstall.this.installer.getVersion());
            if (binDir != null) {
                cons.gridy = 2;
                cons.weightx = 0.0;
                cons.insets = new Insets(0, 0, 0, 0);
                label = new JLabel("Install shortcut in: ", 4);
                label.setBorder(new EmptyBorder(0, 0, 0, 12));
                layout.setConstraints(label, cons);
                directoryPanel.add(label);
                cons.weightx = 1.0;
                this.binDirTF = new JTextField(binDir);
                layout.setConstraints(this.binDirTF, cons);
                directoryPanel.add(this.binDirTF);
            }
            box.add(directoryPanel);
            Box buttons = new Box(0);
            this.chooseInstallBT = new JButton("Choose Install Directory...");
            this.chooseInstallBT.setRequestFocusEnabled(false);
            this.chooseInstallBT.addActionListener(this);
            buttons.add(this.chooseInstallBT);
            if (binDir != null) {
                buttons.add(Box.createHorizontalStrut(6));
                this.chooseBinBT = new JButton("Choose Shortcut Directory...");
                this.chooseBinBT.setRequestFocusEnabled(false);
                this.chooseBinBT.addActionListener(this);
                buttons.add(this.chooseBinBT);
            }
            box.add(buttons);
            box.add(Box.createGlue());
            this.add("Center", box);
        }

        public void actionPerformed(ActionEvent evt) {
            JTextField field = evt.getSource() == this.chooseInstallBT ? this.installDirTF : this.binDirTF;
            File directory = new File(field.getText());
            JFileChooser chooser = new JFileChooser(directory.getParent());
            chooser.setFileSelectionMode(1);
            chooser.setSelectedFile(directory);
            if (chooser.showOpenDialog(SwingInstall.this) == 0) {
                String s = chooser.getSelectedFile().getPath();
                if (evt.getSource() == this.chooseInstallBT) {
                    s = s + File.separator + "jpicedt" + File.separator + SwingInstall.this.installer.getVersion();
                }
                field.setText(s);
            }
        }

        public void madeVisible() {
            this.osLBL.setText("Operating System : " + OperatingSystem.getOperatingSystem());
            this.installDirTF.setText(OperatingSystem.getOperatingSystem().getInstallDirectory(SwingInstall.this.installer.getVersion()));
            String binDir = OperatingSystem.getOperatingSystem().getShortcutDirectory(SwingInstall.this.installer.getVersion());
            if (binDir != null) {
                this.binDirTF.setText(binDir);
            }
        }

        public void validatePageData() {
            if (SwingInstall.this.scriptParams == null) {
                SwingInstall.this.scriptParams = OperatingSystem.getOperatingSystem().createScriptParameters(SwingInstall.this.installer.getVersion());
            }
            SwingInstall.this.scriptParams.setDirectories(this.installDirTF.getText(), this.binDirTF.getText());
        }
    }

    private class ConfigureJava
    extends Page
    implements ActionListener {
        JComboBox osListCB;
        JTextField javaHomeTF;
        JTextField javaHeapTF;

        ConfigureJava() {
            super(new BorderLayout());
            JLabel caption = new JLabel("Java parameters...");
            Font font = caption.getFont();
            caption.setFont(new Font(font.getFamily(), font.getStyle(), 18));
            this.add("North", caption);
            Box box = new Box(1);
            JPanel centerPane = new JPanel();
            GridBagLayout layout = new GridBagLayout();
            centerPane.setLayout(layout);
            GridBagConstraints cons = new GridBagConstraints();
            cons.anchor = 17;
            cons.fill = 2;
            cons.gridy = 1;
            cons.insets = new Insets(0, 0, 6, 0);
            JLabel osLabel = new JLabel("Operating system: ", 4);
            osLabel.setBorder(new EmptyBorder(0, 0, 0, 12));
            osLabel.setToolTipText("Change this setting if your operating system is not properly reported");
            layout.setConstraints(osLabel, cons);
            centerPane.add(osLabel);
            cons.weightx = 1.0;
            OperatingSystem[] availOS = OperatingSystem.getAvailableOperatingSystems();
            this.osListCB = new JComboBox<OperatingSystem>(availOS);
            this.osListCB.setSelectedItem(OperatingSystem.getOperatingSystem());
            this.osListCB.addActionListener(this);
            layout.setConstraints(this.osListCB, cons);
            centerPane.add(this.osListCB);
            cons.gridy = 2;
            cons.weightx = 0.0;
            cons.insets = new Insets(0, 0, 0, 0);
            JLabel javaHomeLBL = new JLabel("Java home: ", 4);
            javaHomeLBL.setBorder(new EmptyBorder(0, 0, 0, 12));
            javaHomeLBL.setToolTipText("Change this setting if this directory does not match your current Java installation");
            layout.setConstraints(javaHomeLBL, cons);
            centerPane.add(javaHomeLBL);
            cons.weightx = 1.0;
            String javaHome = System.getProperty("java.home");
            this.javaHomeTF = new JTextField(javaHome);
            layout.setConstraints(this.javaHomeTF, cons);
            centerPane.add(this.javaHomeTF);
            cons.gridy = 3;
            cons.weightx = 0.0;
            cons.insets = new Insets(0, 0, 0, 0);
            JLabel javaHeapLBL = new JLabel("Java heap size (Mb): ", 4);
            javaHeapLBL.setBorder(new EmptyBorder(0, 0, 0, 12));
            javaHeapLBL.setToolTipText("Amount of memory that will be available to jPicEdt (at least 32Mb; 96Mb is optimal)");
            layout.setConstraints(javaHeapLBL, cons);
            centerPane.add(javaHeapLBL);
            cons.weightx = 1.0;
            this.javaHeapTF = new JTextField("96");
            layout.setConstraints(this.javaHeapTF, cons);
            centerPane.add(this.javaHeapTF);
            box.add(centerPane);
            box.add(Box.createGlue());
            this.add("Center", box);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.osListCB) {
                OperatingSystem selOS = (OperatingSystem)this.osListCB.getSelectedItem();
                OperatingSystem.setOperatingSystem(selOS);
            }
        }

        public void validatePageData() {
            if (SwingInstall.this.scriptParams == null) {
                SwingInstall.this.scriptParams = OperatingSystem.getOperatingSystem().createScriptParameters(SwingInstall.this.installer.getVersion());
            }
            ((SwingInstall)SwingInstall.this).scriptParams.javaHome = this.javaHomeTF.getText();
            ((SwingInstall)SwingInstall.this).scriptParams.javaHeap = Integer.parseInt(this.javaHeapTF.getText());
        }
    }

    private class License
    extends ShowFile
    implements ActionListener {
        private JCheckBox cb = new JCheckBox("I approve this license agreement.");

        License() {
            super("app.license");
            this.cb.addActionListener(this);
            this.add("South", this.cb);
        }

        public boolean canNextPage() {
            return this.cb.isSelected();
        }

        public void actionPerformed(ActionEvent evt) {
            ((SwingInstall)SwingInstall.this).wizard.nextButton.setEnabled(this.cb.isSelected());
        }
    }

    private class Readme
    extends ShowFile {
        Readme() {
            super("app.readme");
        }

        public String getNextButtonLabel() {
            return "Done";
        }

        public boolean canPreviousPage() {
            return false;
        }
    }

    private class About
    extends ShowFile {
        About() {
            super("app.intro");
        }
    }

    private class ShowFile
    extends Page {
        ShowFile(String key) {
            super(new BorderLayout());
            JLabel caption = new JLabel("jPicEdt " + SwingInstall.this.installer.getVersion());
            caption.setBorder(new EmptyBorder(0, 0, 12, 0));
            Font font = caption.getFont();
            caption.setFont(new Font(font.getFamily(), font.getStyle(), 18));
            this.add("North", caption);
            JEditorPane text = new JEditorPane();
            String content = SwingInstall.this.installer.getProperty(key);
            try {
                text.setText("Loading '" + content + "'...");
                text.setPage(this.getClass().getResource(content));
            }
            catch (IOException io) {
                text.setText("Error loading '" + content + "'");
                io.printStackTrace();
            }
            text.setEditable(false);
            JScrollPane scrollPane = new JScrollPane(text);
            Dimension dim = new Dimension();
            dim.height = 250;
            scrollPane.setPreferredSize(dim);
            this.add("Center", scrollPane);
        }
    }

    private class InstallWizard
    extends Wizard {
        InstallWizard() {
            System.out.print(".");
            SwingInstall.this.selectPackages = new SelectProgramPackages();
            System.out.print(".");
            Page[] pages = new Page[]{new About(), new License(), new ConfigureJava(), new ChooseDirectory(), SwingInstall.this.selectPackages, new SwingProgress(), new Readme()};
            System.out.print(".");
            this.setPages(pages);
        }

        protected void cancelCallback() {
            System.exit(0);
        }

        protected void finishCallback() {
            System.exit(0);
        }
    }
}

