/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh.instructions.add;

import edsim51sh.Memory;
import edsim51sh.instructions.Instruction;
import edsim51sh.instructions.add.AddAaddress;
import edsim51sh.instructions.add.AddAatReg;
import edsim51sh.instructions.add.AddAdata;
import edsim51sh.instructions.add.AddAreg;
import edsim51sh.instructions.add.AddcAaddress;
import edsim51sh.instructions.add.AddcAatReg;
import edsim51sh.instructions.add.AddcAdata;
import edsim51sh.instructions.add.AddcAreg;

public class Add
extends Instruction {
    public Add() {
        this.mneumonic = "ADD";
    }

    @Override
    public Instruction getInstruction(String mneumonic) {
        if (mneumonic.startsWith("ADD A,")) {
            int registerNumber;
            if (mneumonic.startsWith("ADD A,#")) {
                return new AddAdata();
            }
            if (mneumonic.length() == 8) {
                registerNumber = mneumonic.charAt(7) - 48;
                if (mneumonic.startsWith("ADD A,R") && mneumonic.charAt(7) >= '0' && mneumonic.charAt(7) <= '7') {
                    return new AddAreg(registerNumber);
                }
            }
            if (mneumonic.length() >= 9) {
                registerNumber = mneumonic.charAt(8) - 48;
                if (mneumonic.equals("ADD A,@R0") || mneumonic.equals("ADD A,@R1")) {
                    return new AddAatReg(registerNumber);
                }
            }
            return new AddAaddress();
        }
        if (mneumonic.startsWith("ADDC A,")) {
            int registerNumber;
            if (mneumonic.startsWith("ADDC A,#")) {
                return new AddcAdata();
            }
            if (mneumonic.length() == 9) {
                registerNumber = mneumonic.charAt(8) - 48;
                if (mneumonic.startsWith("ADDC A,R") && mneumonic.charAt(8) >= '0' && mneumonic.charAt(8) <= '7') {
                    return new AddcAreg(registerNumber);
                }
            }
            if (mneumonic.length() >= 10) {
                registerNumber = mneumonic.charAt(9) - 48;
                if (mneumonic.equals("ADDC A,@R0") || mneumonic.equals("ADDC A,@R1")) {
                    return new AddcAatReg(registerNumber);
                }
            }
            return new AddcAaddress();
        }
        return null;
    }

    @Override
    public int execute(Memory ram, int pc) throws Exception {
        return 0;
    }

    @Override
    public int getOpcode() {
        return -1;
    }

    public void addToA(Memory ram, int data, int carry) throws Exception {
        int a = ram.readByte(224);
        int result = a + data + carry;
        if (result > 255) {
            result -= 256;
            ram.setBit(215);
        } else {
            ram.clearBit(215);
        }
        ram.writeByte(224, result);
        int signedResult = ram.toSignedNumber(a) + ram.toSignedNumber(data) + carry;
        if (signedResult > 127 || signedResult < -128) {
            ram.setBit(210);
        } else {
            ram.clearBit(210);
        }
        int aLowNibble = a & 0xF;
        int dataLowNibble = data & 0xF;
        if (aLowNibble + dataLowNibble + carry > 15) {
            ram.setBit(214);
        } else {
            ram.clearBit(214);
        }
    }

    public void addToAPlusC(Memory ram, int data) throws Exception {
        this.addToA(ram, data, ram.getBit(215));
    }
}

