/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh;

import edsim51sh.Serial;
import edsim51sh.TargetBoard;
import edsim51sh.Timer0;
import edsim51sh.Timer1;
import edsim51sh.exceptions.AddressAccessException;
import edsim51sh.exceptions.BitAddressAccessException;
import edsim51sh.instructions.InstructionInfo;
import edsim51sh.ports.Port;
import edsim51sh.ports.Port0;
import edsim51sh.ports.Port1;
import edsim51sh.ports.Port2;
import edsim51sh.ports.Port3;
import java.util.Vector;

public class Memory {
    public InstructionInfo[] codeMemory;
    private TargetBoard targetBoard = null;
    private int[] memory = new int[256];
    private boolean retiJustExecuted = false;
    private boolean isrNested = false;
    private int interruptLevel = -1;
    public Port0 port0 = new Port0(this);
    public Port1 port1 = new Port1(this);
    public Port2 port2 = new Port2(this);
    public Port3 port3 = new Port3(this);
    public Timer0 timer0 = new Timer0(this);
    public Timer1 timer1 = new Timer1(this);
    public Serial serial = new Serial(this);

    public Memory() {
        this.reset();
        this.codeMemory = new InstructionInfo[65536];
        for (int i = 0; i < 65536; ++i) {
            InstructionInfo ii;
            this.codeMemory[i] = ii = new InstructionInfo("NOP", 0);
        }
    }

    public void setTargetBoard(TargetBoard targetBoard) {
        this.targetBoard = targetBoard;
    }

    public TargetBoard getTargetBoard() {
        return this.targetBoard;
    }

    public InstructionInfo[] getCodeMemory() {
        return this.codeMemory;
    }

    public void setCodeMemory(InstructionInfo[] codeMemory) {
        this.codeMemory = codeMemory;
    }

    public Vector getMemoryWindow(boolean isRam) {
        return this.getMemoryWindow(isRam, 0);
    }

    public synchronized Vector getMemoryWindow(boolean isRam, int startAddress) {
        int[] columnAddresses = new int[16];
        int[] rowAddresses = new int[8];
        int[] data = new int[128];
        if (isRam) {
            int i;
            for (i = 0; i < 16; ++i) {
                columnAddresses[i] = i;
            }
            for (i = 0; i < 8; ++i) {
                rowAddresses[i] = i * 16;
            }
            for (i = 0; i < 128; ++i) {
                data[i] = this.memory[i];
            }
        } else {
            if (startAddress < 0) {
                startAddress = 0;
            } else if (startAddress > 65408) {
                startAddress = 65408;
            }
            int columnIndex = 0;
            for (int i = startAddress; i < startAddress + 16; ++i) {
                columnAddresses[columnIndex] = i & 0xF;
                ++columnIndex;
            }
            int rowIndex = 0;
            for (int i = startAddress; i < startAddress + 8; ++i) {
                rowAddresses[rowIndex] = i + rowIndex * 15;
                ++rowIndex;
            }
            int dataIndex = 0;
            for (int i = startAddress; i < startAddress + 128; ++i) {
                data[dataIndex] = this.codeMemory[i].getCode();
                ++dataIndex;
            }
        }
        Vector<int[]> v = new Vector<int[]>();
        v.addElement(columnAddresses);
        v.addElement(rowAddresses);
        v.addElement(data);
        return v;
    }

    public boolean hasRetiJustBeenExecuted() {
        return this.retiJustExecuted;
    }

    public void setRetiJustExecuted(boolean b) {
        this.retiJustExecuted = b;
    }

    public void setIsrNested(boolean b) {
        this.isrNested = b;
    }

    public boolean isIsrNested() {
        return this.isrNested;
    }

    public void setInterruptLevel(int i) {
        this.interruptLevel = i;
    }

    public int getInterruptLevel() {
        return this.interruptLevel;
    }

    public synchronized void reset() {
        this.interruptLevel = -1;
        this.memory[224] = 0;
        this.memory[240] = 0;
        this.memory[208] = 0;
        this.memory[129] = 7;
        this.memory[131] = 0;
        this.memory[130] = 0;
        this.memory[184] = 0;
        this.memory[168] = 0;
        this.memory[136] = 0;
        this.memory[137] = 0;
        this.memory[140] = 0;
        this.memory[138] = 0;
        this.memory[141] = 0;
        this.memory[139] = 0;
        this.memory[152] = 0;
        this.memory[153] = 0;
        this.memory[135] = 0;
        this.memory[128] = 255;
        this.memory[144] = 255;
        this.memory[160] = 255;
        this.memory[176] = 255;
        this.retiJustExecuted = false;
        this.updatePortPins();
        this.timer0 = new Timer0(this);
        this.timer1 = new Timer1(this);
        this.serial = new Serial(this);
    }

    public synchronized int readSbufWriteOnly() {
        return this.memory[153];
    }

    public synchronized void writeRegister(int registerNumber, int data) throws Exception {
        if (registerNumber < 0 || registerNumber > 7) {
            throw new AddressAccessException(registerNumber);
        }
        int address = 8 * this.getRegiserBankNumber() + registerNumber;
        this.writeByte(address, data);
    }

    public synchronized int readRegister(int registerNumber) throws AddressAccessException {
        if (registerNumber < 0 || registerNumber > 7) {
            throw new AddressAccessException(registerNumber);
        }
        int address = this.getRegisterAddress(registerNumber);
        return this.readByte(address);
    }

    public synchronized int getRegisterAddress(int registerNumber) throws AddressAccessException {
        if (registerNumber < 0 || registerNumber > 7) {
            throw new AddressAccessException(registerNumber);
        }
        return 8 * this.getRegiserBankNumber() + registerNumber;
    }

    public synchronized String getRegisterName(int address) {
        int register0Address = 0;
        try {
            register0Address = this.getRegisterAddress(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int registerNumber = address - register0Address;
        if (registerNumber >= 0 && registerNumber <= 7) {
            return "R" + registerNumber;
        }
        return null;
    }

    public synchronized void writeByte(int address, int data) throws Exception {
        if (this.isChangingSerialMode(address &= 0xFF, data &= 0xFF, true)) {
            this.serial.reset();
        }
        this.memory[address] = data;
        if (address == 224 || address == 208) {
            this.updateParity();
        } else if (address == 153) {
            this.serial.setDataToSend();
        } else if (address == 128) {
            this.port0.updatePortPins();
        } else if (address == 144) {
            this.port1.updatePortPins();
        } else if (address == 160) {
            this.port2.updatePortPins();
        } else if (address == 176) {
            this.port3.updatePortPins();
        }
    }

    public synchronized int getRegiserBankNumber() {
        try {
            return this.getBit(211) + (this.getBit(212) << 1);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public synchronized boolean updatePortPin(int portNumber, int pinNumber, boolean high) throws BitAddressAccessException {
        Port port = null;
        if (portNumber == 0) {
            port = this.port0;
        } else if (portNumber == 1) {
            port = this.port1;
        } else if (portNumber == 2) {
            port = this.port2;
        } else if (portNumber == 3) {
            port = this.port3;
        }
        if (high) {
            return port.internalSetPortPin(pinNumber);
        }
        port.internalClearPortPin(pinNumber);
        return true;
    }

    public synchronized void updatePortPins() {
        try {
            this.port0.updatePortPins();
            this.port1.updatePortPins();
            this.port2.updatePortPins();
            this.port3.updatePortPins();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.targetBoard != null) {
            this.targetBoard.updatePortPins();
        }
    }

    public synchronized int readPortLatches(int address) throws AddressAccessException {
        if (address == 128) {
            return this.memory[128];
        }
        if (address == 144) {
            return this.memory[144];
        }
        if (address == 160) {
            return this.memory[160];
        }
        if (address == 176) {
            return this.memory[176];
        }
        throw new AddressAccessException(address);
    }

    public synchronized int readPortLatch(int bitAddress) throws BitAddressAccessException {
        if (bitAddress >= 128 && bitAddress <= 135 || bitAddress >= 144 && bitAddress <= 151 || bitAddress >= 160 && bitAddress <= 167 || bitAddress >= 176 && bitAddress <= 183) {
            int bit = bitAddress % 8;
            int byteAddress = bitAddress - bit;
            int data = this.memory[byteAddress];
            data >>= bit;
            return data &= 1;
        }
        throw new BitAddressAccessException(bitAddress);
    }

    public synchronized int readPortLatch(int portNumber, int pinNumber) throws BitAddressAccessException {
        int address = this.getPortAddress(portNumber);
        return this.readPortLatch(address += pinNumber);
    }

    public synchronized int readByteForLogicInstruction(int address) throws Exception {
        if (address == 128 || address == 144 || address == 160 || address == 176) {
            return this.readPortLatches(address);
        }
        return this.readByte(address);
    }

    public synchronized int readByte(int address) throws AddressAccessException {
        if ((address &= 0xFF) < 0 || address > 255) {
            throw new AddressAccessException(address);
        }
        if (address == 128) {
            return this.port0.getPortPins();
        }
        if (address == 144) {
            return this.port1.getPortPins();
        }
        if (address == 160) {
            return this.port2.getPortPins();
        }
        if (address == 176) {
            return this.port3.getPortPins();
        }
        if (address == 153) {
            return this.serial.getSbufReadOnly();
        }
        return this.memory[address];
    }

    public synchronized int getBit(int bitAddress) throws AddressAccessException {
        if (bitAddress < 0 || bitAddress > 255) {
            throw new BitAddressAccessException(bitAddress);
        }
        if (bitAddress <= 127) {
            return this.getBit(bitAddress / 8 + 32, bitAddress % 8);
        }
        return this.getBit(bitAddress - bitAddress % 8, bitAddress % 8);
    }

    private synchronized int getBit(int address, int bit) throws AddressAccessException {
        if (Memory.isBitAddressable(address)) {
            int data = this.readByte(address);
            data >>= bit;
            return data &= 1;
        }
        BitAddressAccessException ex = new BitAddressAccessException(address);
        ex.isBitAddressableError(true);
        throw ex;
    }

    public synchronized void setBit(int bitAddress) throws AddressAccessException {
        if (bitAddress < 0 || bitAddress > 255) {
            throw new BitAddressAccessException(bitAddress);
        }
        if (bitAddress == 208) {
            return;
        }
        if (this.isChangingSerialMode(bitAddress, 1, false)) {
            this.serial.reset();
        }
        if (bitAddress <= 127) {
            this.setBit(bitAddress / 8 + 32, bitAddress % 8);
        } else {
            this.setBit(bitAddress - bitAddress % 8, bitAddress % 8);
        }
    }

    public synchronized void setBit(int address, int bit) throws AddressAccessException {
        if (Memory.isBitAddressable(address)) {
            if (address == 208 && bit == 0) {
                return;
            }
            int data = this.memory[address];
            int mask = 1;
            this.memory[address] = data |= (mask <<= bit);
            if (address == 224) {
                this.updateParity();
            }
        } else {
            BitAddressAccessException ex = new BitAddressAccessException(address);
            ex.isBitAddressableError(true);
            throw ex;
        }
    }

    public synchronized void clearBit(int bitAddress) throws AddressAccessException {
        if (bitAddress < 0 || bitAddress > 255) {
            throw new BitAddressAccessException(bitAddress);
        }
        if (bitAddress == 208) {
            return;
        }
        if (this.isChangingSerialMode(bitAddress, 0, false)) {
            this.serial.reset();
        }
        if (bitAddress <= 127) {
            this.clearBit(bitAddress / 8 + 32, bitAddress % 8);
        } else {
            this.clearBit(bitAddress - bitAddress % 8, bitAddress % 8);
        }
    }

    public synchronized void clearBit(int address, int bit) throws AddressAccessException {
        if (Memory.isBitAddressable(address)) {
            if (address == 208 && bit == 0) {
                return;
            }
            int data = this.memory[address];
            int mask = 1;
            mask = ~(mask << bit);
            this.memory[address] = data &= mask;
            if (address == 224) {
                this.updateParity();
            }
        } else {
            BitAddressAccessException ex = new BitAddressAccessException(address);
            ex.isBitAddressableError(true);
            throw ex;
        }
    }

    public synchronized void invertBit(int bitAddress) throws AddressAccessException {
        if (bitAddress < 0 || bitAddress > 255) {
            throw new BitAddressAccessException(bitAddress);
        }
        if (bitAddress == 208) {
            return;
        }
        int bit = this.getBit(bitAddress);
        bit = bit == 1 ? 0 : 1;
        if (this.isChangingSerialMode(bitAddress, bit, false)) {
            this.serial.reset();
        }
        if (bitAddress <= 127) {
            this.invertBit(bitAddress / 8 + 32, bitAddress % 8);
        } else {
            this.invertBit(bitAddress - bitAddress % 8, bitAddress % 8);
        }
    }

    private synchronized void invertBit(int address, int bit) throws AddressAccessException {
        if (Memory.isBitAddressable(address)) {
            if (address == 208 && bit == 0) {
                return;
            }
            int data = this.memory[address];
            int mask = 1;
            this.memory[address] = data ^= (mask <<= bit);
            if (address == 224) {
                this.updateParity();
            }
        } else {
            BitAddressAccessException ex = new BitAddressAccessException(address);
            ex.isBitAddressableError(true);
            throw ex;
        }
    }

    public static boolean isBitAddressable(int address) {
        return address >= 32 && address <= 47 || address >= 128 && address % 8 == 0;
    }

    private synchronized void updateParity() {
        int psw = this.memory[208];
        if (this.evenNumberOfOnesInAcc()) {
            if (psw % 2 != 0) {
                this.memory[208] = psw - 1;
            }
        } else if (psw % 2 != 1) {
            this.memory[208] = psw + 1;
        }
    }

    private synchronized boolean evenNumberOfOnesInAcc() {
        int count = 0;
        for (int i = 0; i < 8; ++i) {
            try {
                count += this.getBit(224 + i);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return count % 2 == 0;
    }

    private synchronized int getPortAddress(int portNumber) {
        if (portNumber == 0) {
            return 128;
        }
        if (portNumber == 1) {
            return 144;
        }
        if (portNumber == 2) {
            return 160;
        }
        if (portNumber == 3) {
            return 176;
        }
        return -1;
    }

    public synchronized Port getPort(int portNumber) {
        if ((portNumber &= 3) == 0) {
            return this.port0;
        }
        if (portNumber == 1) {
            return this.port1;
        }
        if (portNumber == 2) {
            return this.port2;
        }
        return this.port3;
    }

    private synchronized boolean isChangingSerialMode(int address, int data, boolean isByteAddress) {
        try {
            if (isByteAddress) {
                if (address == 152) {
                    int currentMode = this.readByte(152) >> 6;
                    return data >> 6 != currentMode;
                }
            } else {
                if (address == 159) {
                    return this.getBit(159) != data;
                }
                if (address == 158) {
                    return this.getBit(158) != data;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public synchronized int toSignedNumber(int unsignedData) {
        if (unsignedData >= 0 && unsignedData <= 127) {
            return unsignedData;
        }
        return unsignedData - 256;
    }
}

