/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import java.util.Iterator;
import org.antlr.tool.CompositeGrammar;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;
import org.antlr.tool.Rule;

public class GrammarReport2 {
    public static final String newline = System.getProperty("line.separator");
    public Grammar root;

    public GrammarReport2(Grammar rootGrammar) {
        this.root = rootGrammar;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.stats(this.root, buf);
        CompositeGrammar composite = this.root.composite;
        Iterator<Grammar> i$ = composite.getDelegates(this.root).iterator();
        while (i$.hasNext()) {
            Grammar g = i$.next();
            this.stats(g, buf);
        }
        return buf.toString();
    }

    void stats(Grammar g, StringBuilder buf) {
        int numDec = g.getNumberOfDecisions();
        for (int decision = 1; decision <= numDec; ++decision) {
            Grammar.Decision d = g.getDecision(decision);
            if (d.dfa == null) continue;
            int k = d.dfa.getMaxLookaheadDepth();
            Rule enclosingRule = d.dfa.decisionNFAStartState.enclosingRule;
            if (enclosingRule.isSynPred) continue;
            buf.append(g.name + "." + enclosingRule.name + ":" + "");
            GrammarAST decisionAST = d.dfa.decisionNFAStartState.associatedASTNode;
            buf.append(decisionAST.getLine());
            buf.append(":");
            buf.append(decisionAST.getCharPositionInLine());
            buf.append(" decision " + decision + ":");
            if (d.dfa.isCyclic()) {
                buf.append(" cyclic");
            }
            if (k != Integer.MAX_VALUE) {
                buf.append(" k=" + k);
            }
            if (d.dfa.hasSynPred()) {
                buf.append(" backtracks");
            }
            if (d.dfa.hasSemPred()) {
                buf.append(" sempred");
            }
            this.nl(buf);
        }
    }

    void nl(StringBuilder buf) {
        buf.append(newline);
    }
}

