/*
 * Decompiled with CFR 0.152.
 */
package org.forester.ws.seqdb;

import java.io.IOException;

public final class UniprotData {
    final String _id;
    final String _entry;
    final String _entry_name;
    final String _status;
    final String _protein_names;
    final String _gene_names;
    final String _organism;
    final int _length;

    public UniprotData(String string) throws IOException {
        String[] stringArray = string.split("\t");
        if (stringArray.length != 9) {
            throw new IOException("line has illegal format: " + string);
        }
        this._id = stringArray[0];
        this._entry = stringArray[2];
        this._entry_name = stringArray[3];
        this._status = stringArray[4];
        this._protein_names = stringArray[5];
        this._gene_names = stringArray[6];
        this._organism = stringArray[7];
        try {
            this._length = Integer.parseInt(stringArray[8]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("could not parse length from " + stringArray[8]);
        }
    }

    public String getId() {
        return this._id;
    }

    public String getEntry() {
        return this._entry;
    }

    public String getEntryName() {
        return this._entry_name;
    }

    public String getStatus() {
        return this._status;
    }

    public String getProteinNames() {
        return this._protein_names;
    }

    public String getGeneNames() {
        return this._gene_names;
    }

    public String getOrganism() {
        return this._organism;
    }

    public int getLength() {
        return this._length;
    }
}

