/*
 * Decompiled with CFR 0.152.
 */
package org.forester.clade_analysis;

import java.io.File;
import org.forester.clade_analysis.AnalysisMulti;
import org.forester.clade_analysis.AnalysisSingle;
import org.forester.clade_analysis.ResultMulti;
import org.forester.clade_analysis.ResultSingle;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.util.ForesterUtil;

public class CladeAnalysisTest {
    private static final String PATH_TO_TEST_DATA = System.getProperty("user.dir") + ForesterUtil.getFileSeparator() + "test_data" + ForesterUtil.getFileSeparator();

    public static void main(String[] stringArray) {
        boolean bl = false;
        if (!CladeAnalysisTest.testCladeAnalysis1()) {
            System.out.println("Clade analysis 1 failed");
            bl = true;
        }
        if (!CladeAnalysisTest.testCladeAnalysis2()) {
            System.out.println("Clade analysis 2 failed");
            bl = true;
        }
        if (!CladeAnalysisTest.testCladeAnalysis3()) {
            System.out.println("Clade analysis 3 failed");
            bl = true;
        }
        if (!CladeAnalysisTest.testCladeAnalysis4()) {
            System.out.println("Clade analysis 4 failed");
            bl = true;
        }
        if (!bl) {
            System.out.println("OK");
        } else {
            System.out.println("NOT OK");
        }
    }

    public static boolean test() {
        if (!CladeAnalysisTest.testCladeAnalysis1()) {
            return false;
        }
        if (!CladeAnalysisTest.testCladeAnalysis2()) {
            return false;
        }
        if (!CladeAnalysisTest.testCladeAnalysis3()) {
            return false;
        }
        return CladeAnalysisTest.testCladeAnalysis4();
    }

    private static boolean testCladeAnalysis1() {
        try {
            File file = new File(PATH_TO_TEST_DATA + "clade_analysis_test_1.xml");
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(file, true);
            Phylogeny phylogeny = phylogenyFactory.create(file, phylogenyParser)[0];
            ResultSingle resultSingle = AnalysisSingle.execute(phylogeny, "A.1.1.1", ".");
            if (!resultSingle.getGreatestCommonPrefix().equals("A.1")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixDown().equals("A.1.1")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixUp().equals("A.1.2.1")) {
                return false;
            }
            if (resultSingle.getLeastEncompassingCladeSize() != 4) {
                return false;
            }
            if (resultSingle.getTreeSize() != 25) {
                return false;
            }
            if (resultSingle.getWarnings().size() != 0) {
                return false;
            }
            resultSingle = AnalysisSingle.execute(phylogeny, "A.1.1.2", ".");
            if (!resultSingle.getGreatestCommonPrefix().equals("A.1")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixDown().equals("A.1.1")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixUp().equals("A.1.2.1")) {
                return false;
            }
            if (resultSingle.getLeastEncompassingCladeSize() != 4) {
                return false;
            }
            if (resultSingle.getTreeSize() != 25) {
                return false;
            }
            if (resultSingle.getWarnings().size() != 0) {
                return false;
            }
            resultSingle = AnalysisSingle.execute(phylogeny, "A.1.1.3", ".");
            if (!resultSingle.getGreatestCommonPrefix().equals("A.1")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixDown().equals("A.1.1")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixUp().equals("A.1.2.1")) {
                return false;
            }
            if (resultSingle.getLeastEncompassingCladeSize() != 4) {
                return false;
            }
            if (resultSingle.getTreeSize() != 25) {
                return false;
            }
            if (resultSingle.getWarnings().size() != 0) {
                return false;
            }
            resultSingle = AnalysisSingle.execute(phylogeny, "A.1.1.4", ".");
            if (!resultSingle.getGreatestCommonPrefix().equals("A.1.1")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixDown().equals("A.1.1")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixUp().equals("A.1.1")) {
                return false;
            }
            if (resultSingle.getLeastEncompassingCladeSize() != 3) {
                return false;
            }
            if (resultSingle.getTreeSize() != 25) {
                return false;
            }
            if (resultSingle.getWarnings().size() != 0) {
                return false;
            }
            resultSingle = AnalysisSingle.execute(phylogeny, "A.1.2.1", ".");
            if (!resultSingle.getGreatestCommonPrefix().equals("A")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixDown().equals("A.1.1")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixUp().equals("A")) {
                return false;
            }
            if (resultSingle.getLeastEncompassingCladeSize() != 17) {
                return false;
            }
            if (resultSingle.getTreeSize() != 25) {
                return false;
            }
            if (resultSingle.getWarnings().size() != 0) {
                return false;
            }
            resultSingle = AnalysisSingle.execute(phylogeny, "A.2.1.1", ".");
            if (!resultSingle.getGreatestCommonPrefix().equals("A")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixDown().equals("A.2.1.2")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixUp().equals("A")) {
                return false;
            }
            if (resultSingle.getLeastEncompassingCladeSize() != 17) {
                return false;
            }
            if (resultSingle.getTreeSize() != 25) {
                return false;
            }
            if (resultSingle.getWarnings().size() != 0) {
                return false;
            }
            resultSingle = AnalysisSingle.execute(phylogeny, "A.2.1.2", ".");
            if (!resultSingle.getGreatestCommonPrefix().equals("A")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixDown().equals("A.2.1.1")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixUp().equals("A")) {
                return false;
            }
            if (resultSingle.getLeastEncompassingCladeSize() != 17) {
                return false;
            }
            if (resultSingle.getTreeSize() != 25) {
                return false;
            }
            if (resultSingle.getWarnings().size() != 0) {
                return false;
            }
            resultSingle = AnalysisSingle.execute(phylogeny, "A.3.1.1", ".");
            if (!resultSingle.getGreatestCommonPrefix().equals("A.3")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixDown().equals("A.3.1.2")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixUp().equals("A.3.2.1")) {
                return false;
            }
            if (resultSingle.getLeastEncompassingCladeSize() != 2) {
                return false;
            }
            if (resultSingle.getTreeSize() != 25) {
                return false;
            }
            if (resultSingle.getWarnings().size() != 0) {
                return false;
            }
            resultSingle = AnalysisSingle.execute(phylogeny, "A.3.1.2", ".");
            if (!resultSingle.getGreatestCommonPrefix().equals("A.3")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixDown().equals("A.3.1.1")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixUp().equals("A.3.2.1")) {
                return false;
            }
            if (resultSingle.getLeastEncompassingCladeSize() != 2) {
                return false;
            }
            if (resultSingle.getTreeSize() != 25) {
                return false;
            }
            if (resultSingle.getWarnings().size() != 0) {
                return false;
            }
            resultSingle = AnalysisSingle.execute(phylogeny, "A.3.2.1", ".");
            if (!resultSingle.getGreatestCommonPrefix().equals("A.3")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixDown().equals("A.3.1")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixUp().equals("A.3.3.1")) {
                return false;
            }
            if (resultSingle.getLeastEncompassingCladeSize() != 3) {
                return false;
            }
            if (resultSingle.getTreeSize() != 25) {
                return false;
            }
            if (resultSingle.getWarnings().size() != 0) {
                return false;
            }
            resultSingle = AnalysisSingle.execute(phylogeny, "A.3.3.1", ".");
            if (!resultSingle.getGreatestCommonPrefix().equals("A")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixDown().equals("A.3")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixUp().equals("A")) {
                return false;
            }
            if (resultSingle.getLeastEncompassingCladeSize() != 10) {
                return false;
            }
            if (resultSingle.getTreeSize() != 25) {
                return false;
            }
            if (resultSingle.getWarnings().size() != 0) {
                return false;
            }
            resultSingle = AnalysisSingle.execute(phylogeny, "A.4.1.1", ".");
            if (!resultSingle.getGreatestCommonPrefix().equals("A.4.1")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixDown().equals("A.4.1.1.a")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixUp().equals("A.4.1.2")) {
                return false;
            }
            if (resultSingle.getLeastEncompassingCladeSize() != 3) {
                return false;
            }
            if (resultSingle.getTreeSize() != 25) {
                return false;
            }
            if (resultSingle.getWarnings().size() != 0) {
                return false;
            }
            resultSingle = AnalysisSingle.execute(phylogeny, "A.4.1.1.a", ".");
            if (!resultSingle.getGreatestCommonPrefix().equals("A.4.1")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixDown().equals("A.4.1.1")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixUp().equals("A.4.1.2")) {
                return false;
            }
            if (resultSingle.getLeastEncompassingCladeSize() != 3) {
                return false;
            }
            if (resultSingle.getTreeSize() != 25) {
                return false;
            }
            if (resultSingle.getWarnings().size() != 0) {
                return false;
            }
            resultSingle = AnalysisSingle.execute(phylogeny, "A.4.1.2", ".");
            resultSingle = AnalysisSingle.execute(phylogeny, "A.4.1.2.a", ".");
            resultSingle = AnalysisSingle.execute(phylogeny, "A.5.1.1", ".");
            if (!resultSingle.getGreatestCommonPrefix().equals("A")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixDown().equals("A.5.1.2")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixUp().equals("A")) {
                return false;
            }
            if (resultSingle.getLeastEncompassingCladeSize() != 10) {
                return false;
            }
            if (resultSingle.getTreeSize() != 25) {
                return false;
            }
            if (resultSingle.getWarnings().size() != 0) {
                return false;
            }
            resultSingle = AnalysisSingle.execute(phylogeny, "A.5.1.2", ".");
            if (!resultSingle.getGreatestCommonPrefix().equals("A")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixDown().equals("A.5.1.1")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixUp().equals("A")) {
                return false;
            }
            if (resultSingle.getLeastEncompassingCladeSize() != 10) {
                return false;
            }
            if (resultSingle.getTreeSize() != 25) {
                return false;
            }
            if (resultSingle.getWarnings().size() != 0) {
                return false;
            }
            resultSingle = AnalysisSingle.execute(phylogeny, "A.6.3.12", ".");
            if (!resultSingle.getGreatestCommonPrefix().equals("A")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixDown().equals("A")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixUp().equals("A")) {
                return false;
            }
            if (resultSingle.getLeastEncompassingCladeSize() != 17) {
                return false;
            }
            if (resultSingle.getTreeSize() != 25) {
                return false;
            }
            if (resultSingle.getWarnings().size() != 0) {
                return false;
            }
            resultSingle = AnalysisSingle.execute(phylogeny, "B.1.1.1", ".");
            if (!resultSingle.getGreatestCommonPrefix().equals("")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixDown().equals("B.1.234.3")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixUp().equals("")) {
                return false;
            }
            if (resultSingle.getLeastEncompassingCladeSize() != 25) {
                return false;
            }
            if (resultSingle.getTreeSize() != 25) {
                return false;
            }
            if (resultSingle.getWarnings().size() != 2) {
                return false;
            }
            resultSingle = AnalysisSingle.execute(phylogeny, "B.1.234.3", ".");
            if (!resultSingle.getGreatestCommonPrefix().equals("")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixDown().equals("B.1.1.1")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixUp().equals("")) {
                return false;
            }
            if (resultSingle.getLeastEncompassingCladeSize() != 25) {
                return false;
            }
            if (resultSingle.getTreeSize() != 25) {
                return false;
            }
            if (resultSingle.getWarnings().size() != 2) {
                return false;
            }
            resultSingle = AnalysisSingle.execute(phylogeny, "C.1.1.1", ".");
            if (!resultSingle.getGreatestCommonPrefix().equals("C.1")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixDown().equals("C.1.1.2")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixUp().equals("C.1.2.1")) {
                return false;
            }
            if (resultSingle.getLeastEncompassingCladeSize() != 2) {
                return false;
            }
            if (resultSingle.getTreeSize() != 25) {
                return false;
            }
            if (resultSingle.getWarnings().size() != 0) {
                return false;
            }
            resultSingle = AnalysisSingle.execute(phylogeny, "C.1.1.2", ".");
            if (!resultSingle.getGreatestCommonPrefix().equals("C.1")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixDown().equals("C.1.1.1")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixUp().equals("C.1.2.1")) {
                return false;
            }
            if (resultSingle.getLeastEncompassingCladeSize() != 2) {
                return false;
            }
            if (resultSingle.getTreeSize() != 25) {
                return false;
            }
            if (resultSingle.getWarnings().size() != 0) {
                return false;
            }
            resultSingle = AnalysisSingle.execute(phylogeny, "C.1.2.1", ".");
            if (!resultSingle.getGreatestCommonPrefix().equals("C")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixDown().equals("C.1.1")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixUp().equals("C.2.1")) {
                return false;
            }
            if (resultSingle.getLeastEncompassingCladeSize() != 3) {
                return false;
            }
            if (resultSingle.getTreeSize() != 25) {
                return false;
            }
            if (resultSingle.getWarnings().size() != 0) {
                return false;
            }
            resultSingle = AnalysisSingle.execute(phylogeny, "C.2.1", ".");
            if (!resultSingle.getGreatestCommonPrefix().equals("C")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixDown().equals("C.1")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixUp().equals("C.3")) {
                return false;
            }
            if (resultSingle.getLeastEncompassingCladeSize() != 4) {
                return false;
            }
            if (resultSingle.getTreeSize() != 25) {
                return false;
            }
            if (resultSingle.getWarnings().size() != 0) {
                return false;
            }
            resultSingle = AnalysisSingle.execute(phylogeny, "C.3", ".");
            if (!resultSingle.getGreatestCommonPrefix().equals("")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixDown().equals("C")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixUp().equals("QE.1.1.1.2.1")) {
                return false;
            }
            if (resultSingle.getLeastEncompassingCladeSize() != 5) {
                return false;
            }
            if (resultSingle.getTreeSize() != 25) {
                return false;
            }
            if (resultSingle.getWarnings().size() != 1) {
                return false;
            }
            resultSingle = AnalysisSingle.execute(phylogeny, "QE.1.1.1.2.1", ".");
            if (!resultSingle.getGreatestCommonPrefix().equals("")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixDown().equals("C")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixUp().equals("")) {
                return false;
            }
            if (resultSingle.getLeastEncompassingCladeSize() != 25) {
                return false;
            }
            if (resultSingle.getTreeSize() != 25) {
                return false;
            }
            if (resultSingle.getWarnings().size() != 2) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testCladeAnalysis2() {
        try {
            File file = new File(PATH_TO_TEST_DATA + "clade_analysis_test_2.xml");
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(file, true);
            Phylogeny phylogeny = phylogenyFactory.create(file, phylogenyParser)[0];
            ResultSingle resultSingle = AnalysisSingle.execute(phylogeny, "6_DQ278891", null);
            if (!resultSingle.getGreatestCommonPrefix().equals("6_")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixDown().equals("6_DQ278893")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixUp().equals("6_JX183550")) {
                return false;
            }
            if (resultSingle.getLeastEncompassingCladeSize() != 2) {
                return false;
            }
            if (resultSingle.getTreeSize() != 219) {
                return false;
            }
            if (resultSingle.getWarnings().size() != 0) {
                return false;
            }
            resultSingle = AnalysisSingle.execute(phylogeny, "6xa_EU408330", null);
            if (!resultSingle.getGreatestCommonPrefix().equals("6xa_EU40833")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixDown().equals("6xa_EU408331")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixUp().equals("6xa_EU408332")) {
                return false;
            }
            if (resultSingle.getLeastEncompassingCladeSize() != 2) {
                return false;
            }
            if (resultSingle.getTreeSize() != 219) {
                return false;
            }
            if (resultSingle.getWarnings().size() != 0) {
                return false;
            }
            resultSingle = AnalysisSingle.execute(phylogeny, "7a_EF108306", null);
            if (!resultSingle.getGreatestCommonPrefix().equals("")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixDown().equals("2")) {
                return false;
            }
            if (!resultSingle.getGreatestCommonPrefixUp().equals("")) {
                return false;
            }
            if (resultSingle.getLeastEncompassingCladeSize() != 219) {
                return false;
            }
            if (resultSingle.getTreeSize() != 219) {
                return false;
            }
            if (resultSingle.getWarnings().size() != 2) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testCladeAnalysis3() {
        try {
            ResultMulti resultMulti = new ResultMulti();
            resultMulti.addGreatestCommonPrefix("A.1.1", 0.3);
            resultMulti.addGreatestCommonPrefix("A.1.2", 0.3);
            resultMulti.addGreatestCommonPrefix("A.1.3", 0.3);
            resultMulti.addGreatestCommonPrefix("B.1", 0.1);
            resultMulti.analyze(0.5);
            System.out.print(resultMulti.toString());
            System.out.println("------------------------- ");
            System.out.println();
            ResultMulti resultMulti2 = new ResultMulti(".");
            resultMulti2.addGreatestCommonPrefix("A.1.1.1", 0.1);
            resultMulti2.addGreatestCommonPrefix("A.1", 0.7);
            resultMulti2.addGreatestCommonPrefix("A.1.2", 0.1);
            resultMulti2.addGreatestCommonPrefix("B.1", 0.1);
            resultMulti2.analyze(0.3);
            System.out.print(resultMulti2.toString());
            System.out.println("------------------------- ");
            System.out.println();
            ResultMulti resultMulti3 = new ResultMulti(".");
            resultMulti3.addGreatestCommonPrefix("A.1.1.1", 0.1);
            resultMulti3.addGreatestCommonPrefix("A.1.1.1.1", 0.6);
            resultMulti3.addGreatestCommonPrefix("A.1", 0.1);
            resultMulti3.addGreatestCommonPrefix("A.1.2", 0.1);
            resultMulti3.addGreatestCommonPrefix("B.1", 0.1);
            resultMulti3.analyze(0.3);
            System.out.print(resultMulti3.toString());
            System.out.println("------------------------- ");
            System.out.println();
            ResultMulti resultMulti4 = new ResultMulti(".");
            resultMulti4.addGreatestCommonPrefix("A.1.1.1", 0.1);
            resultMulti4.addGreatestCommonPrefix("A.1.1.1.1", 0.3);
            resultMulti4.addGreatestCommonPrefix("A.1", 0.1);
            resultMulti4.addGreatestCommonPrefix("A.1.2", 0.1);
            resultMulti4.addGreatestCommonPrefix("B.1", 0.1);
            resultMulti4.addGreatestCommonPrefix("B.1.1.1", 0.3);
            resultMulti4.analyze(0.3);
            System.out.print(resultMulti4.toString());
            System.out.println("------------------------- ");
            System.out.println();
            ResultMulti resultMulti5 = new ResultMulti();
            resultMulti5.addGreatestCommonPrefix("A.1.1.1.1", 0.35);
            resultMulti5.addGreatestCommonPrefix("A.1.1.1.2", 0.35);
            resultMulti5.addGreatestCommonPrefix("A.1", 0.1);
            resultMulti5.addGreatestCommonPrefix("A.1.2", 0.1);
            resultMulti5.addGreatestCommonPrefix("B.1", 0.1);
            resultMulti5.analyze(0.3);
            System.out.print(resultMulti5.toString());
            System.out.println("------------------------- ");
            System.out.println();
            ResultMulti resultMulti6 = new ResultMulti();
            resultMulti6.addGreatestCommonPrefix("A.1.1.1.1", 0.2);
            resultMulti6.addGreatestCommonPrefix("C.2.3", 0.2);
            resultMulti6.addGreatestCommonPrefix("A.1.5", 0.1);
            resultMulti6.addGreatestCommonPrefix("A.3.1.4", 0.2);
            resultMulti6.addGreatestCommonPrefix("B.1.1", 0.2);
            resultMulti6.addGreatestCommonPrefix("B.1.2", 0.09);
            resultMulti6.addGreatestCommonPrefix("D.1.1.1.1", 0.01);
            resultMulti6.analyze(0.3);
            System.out.print(resultMulti6.toString());
            System.out.println("------------------------- ");
            System.out.println();
            ResultMulti resultMulti7 = new ResultMulti();
            resultMulti7.addGreatestCommonPrefix("A.1.1.1", 0.05);
            resultMulti7.addGreatestCommonPrefix("A.1.1.1.1", 0.65);
            resultMulti7.addGreatestCommonPrefix("A.1", 0.1);
            resultMulti7.addGreatestCommonPrefix("A.1.2", 0.1);
            resultMulti7.addGreatestCommonPrefix("B.1", 0.1);
            resultMulti7.analyze(0.3);
            System.out.print(resultMulti7.toString());
            System.out.println("------------------------- ");
            System.out.println();
            ResultMulti resultMulti8 = new ResultMulti();
            resultMulti8.addGreatestCommonPrefix("A.1.1.1", 0.07);
            resultMulti8.addGreatestCommonPrefix("A.1.1.1.1", 0.9);
            resultMulti8.addGreatestCommonPrefix("A.1", 0.01);
            resultMulti8.addGreatestCommonPrefix("A.1.2", 0.01);
            resultMulti8.addGreatestCommonPrefix("B.1", 0.01);
            resultMulti8.analyze(0.3);
            System.out.print(resultMulti8.toString());
            System.out.println("------------------------- ");
            System.out.println();
            ResultMulti resultMulti9 = new ResultMulti("_/_");
            resultMulti9.addGreatestCommonPrefix("AA_/_abc_/_def", 0.07);
            resultMulti9.addGreatestCommonPrefix("AA_/_abc_/_sfc", 0.9);
            resultMulti9.addGreatestCommonPrefix("AA_/_abc_/_xcd", 0.01);
            resultMulti9.addGreatestCommonPrefix("AA_/_abc_/_memr", 0.01);
            resultMulti9.addGreatestCommonPrefix("AA_/_abc_/_fkem_/_odem", 0.01);
            resultMulti9.analyze(0.3);
            System.out.print(resultMulti9.toString());
            System.out.println("------------------------- ");
            System.out.println();
            ResultMulti resultMulti10 = new ResultMulti("_/_");
            resultMulti10.addGreatestCommonPrefix("AA_/_abc_/_def", 0.07);
            resultMulti10.addGreatestCommonPrefix("AA_/_abc_/_sfc", 0.6);
            resultMulti10.addGreatestCommonPrefix("AA_/_abc_/_xcd", 0.01);
            resultMulti10.addGreatestCommonPrefix("AA_/_abc_/_memr", 0.01);
            resultMulti10.addGreatestCommonPrefix("AA_/_abc_/_fkem_/_odem", 0.01);
            resultMulti10.addGreatestCommonPrefix("BB_/_fke_/_dme_/_nx2", 0.3);
            resultMulti10.analyze(0.3);
            System.out.print(resultMulti10.toString());
            System.out.println("------------------------- ");
            System.out.println();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testCladeAnalysis4() {
        try {
            File file = new File(PATH_TO_TEST_DATA + "pplacer_2.tre");
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(file, true);
            Phylogeny phylogeny = phylogenyFactory.create(file, phylogenyParser)[0];
            ResultMulti resultMulti = AnalysisMulti.execute(phylogeny);
            resultMulti.analyze(0.3);
            System.out.print(resultMulti.toString());
            System.out.println("------------------------- ");
            System.out.println();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }
}

