/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.phylogeny.data;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Map;
import java.util.SortedMap;
import org.forester.archaeopteryx.AptxConstants;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.phylogeny.data.RenderablePhylogenyData;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.ProteinDomain;
import org.forester.util.ForesterUtil;

public final class RenderableDomainArchitecture
extends DomainArchitecture
implements RenderablePhylogenyData {
    private static final String SPECIAL_DOMAIN = "RRMa";
    private static final int BRIGHTEN_COLOR_BY = 200;
    private static final int E_VALUE_THRESHOLD_EXP_DEFAULT = 0;
    private static final BasicStroke STROKE_1 = new BasicStroke(1.0f);
    private static Map<String, Color> _domain_colors;
    private final DomainArchitecture _domain_structure;
    private int _e_value_threshold_exp = 0;
    private final Rectangle2D _rectangle = new Rectangle2D.Float();
    private float _rendering_factor_width = 1.0f;
    private float _rendering_height = 0.0f;
    private String _node_name;

    public RenderableDomainArchitecture(DomainArchitecture domainArchitecture) {
        this._domain_structure = domainArchitecture;
    }

    public RenderableDomainArchitecture(DomainArchitecture domainArchitecture, String string) {
        this._domain_structure = domainArchitecture;
        this._node_name = string;
    }

    public static void setColorMap(Map<String, Color> map) {
        _domain_colors = map;
    }

    @Override
    public StringBuffer asSimpleText() {
        return this._domain_structure.asSimpleText();
    }

    @Override
    public StringBuffer asText() {
        return this._domain_structure.asText();
    }

    @Override
    public PhylogenyData copy() {
        return this._domain_structure.copy();
    }

    private final void drawDomain(double d, double d2, double d3, double d4, String string, Graphics2D graphics2D, boolean bl) {
        double d5 = d4 / 2.0;
        Color color = this.getColorOne(string);
        Color color2 = this.getColorTwo(color);
        double d6 = 1.0;
        if (bl) {
            d6 = 0.05;
        }
        for (double d7 = 0.0; d7 < d4; d7 += d6) {
            graphics2D.setColor(ForesterUtil.calcColor(d7 >= d5 ? d4 - d7 : d7, 0.0, d5, color, color2));
            this._rectangle.setFrame(d, d7 + d2, d3, d6);
            graphics2D.fill(this._rectangle);
        }
    }

    private final void drawDomainGrey(double d, double d2, double d3, double d4, String string, Graphics2D graphics2D, boolean bl) {
        double d5 = d4 / 2.0;
        Color color = Color.GRAY;
        Color color2 = this.getColorTwo(color);
        double d6 = 1.0;
        if (bl) {
            d6 = 0.05;
        }
        for (double d7 = 0.0; d7 < d4; d7 += d6) {
            graphics2D.setColor(ForesterUtil.calcColor(d7 >= d5 ? d4 - d7 : d7, 0.0, d5, color, color2));
            this._rectangle.setFrame(d, d7 + d2, d3, d6);
            graphics2D.fill(this._rectangle);
        }
    }

    private final Color getColorOne(String string) {
        Color color = _domain_colors.get(string);
        if (color == null) {
            color = AptxUtil.calculateColorFromString(string, false);
            if (color == null) {
                throw new IllegalStateException();
            }
            _domain_colors.put(string, color);
        }
        return color;
    }

    private Color getColorTwo(Color color) {
        int n = color.getRed() + 200;
        int n2 = color.getGreen() + 200;
        int n3 = color.getBlue() + 200;
        return new Color(n > 255 ? 255 : n, n2 > 255 ? 255 : n2, n3 > 255 ? 255 : n3);
    }

    @Override
    public ProteinDomain getDomain(int n) {
        return this._domain_structure.getDomain(n);
    }

    @Override
    public SortedMap<BigDecimal, ProteinDomain> getDomains() {
        return this._domain_structure.getDomains();
    }

    @Override
    public int getNumberOfDomains() {
        return this._domain_structure.getNumberOfDomains();
    }

    @Override
    public Dimension getOriginalSize() {
        return new Dimension(this._domain_structure.getTotalLength(), ForesterUtil.roundToInt(this._rendering_height));
    }

    @Override
    public Object getParameter() {
        return this._e_value_threshold_exp;
    }

    public float getRenderingFactorWidth() {
        return this._rendering_factor_width;
    }

    @Override
    public Dimension getRenderingSize() {
        return new Dimension(ForesterUtil.roundToInt((float)this._domain_structure.getTotalLength() * this.getRenderingFactorWidth()), ForesterUtil.roundToInt(this._rendering_height));
    }

    @Override
    public int getTotalLength() {
        return this._domain_structure.getTotalLength();
    }

    @Override
    public boolean isEqual(PhylogenyData phylogenyData) {
        return this._domain_structure.isEqual(phylogenyData);
    }

    @Override
    public void render(float f, float f2, Graphics2D graphics2D, TreePanel treePanel, boolean bl) {
        float f3 = this.getRenderingFactorWidth();
        float f4 = f2 + this._rendering_height / 2.0f;
        float f5 = f + 20.0f;
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(STROKE_1);
        if (!bl) {
            graphics2D.setColor(treePanel.getTreeColorSet().getDomainBaseColor());
        } else {
            graphics2D.setColor(AptxConstants.DOMAIN_BASE_COLOR_FOR_PDF);
        }
        this._rectangle.setFrame(f5, (double)f4 - 0.5, (float)this._domain_structure.getTotalLength() * f3, 1.0);
        graphics2D.fill(this._rectangle);
        int n = 0;
        for (int i = 0; i < this._domain_structure.getDomains().size(); ++i) {
            ProteinDomain proteinDomain = this._domain_structure.getDomain(i);
            if (!(proteinDomain.getConfidence() <= Math.pow(10.0, this._e_value_threshold_exp)) && (!proteinDomain.getName().equals(SPECIAL_DOMAIN) || !(proteinDomain.getConfidence() <= 1.0))) continue;
            if (proteinDomain.getName().equals(SPECIAL_DOMAIN)) {
                n = (short)(n + 1);
            }
            float f6 = f5 + (float)proteinDomain.getFrom() * f3;
            float f7 = f6 + (float)proteinDomain.getLength() * f3;
            if (treePanel.getMainPanel().getOptions().isShowDomainLabels() && treePanel.getMainPanel().getTreeFontSet().getFontMetricsSmall().getHeight() > 4) {
                graphics2D.setFont(treePanel.getMainPanel().getTreeFontSet().getSmallFont());
                if (!bl) {
                    graphics2D.setColor(treePanel.getTreeColorSet().getDomainLabelColor());
                } else {
                    graphics2D.setColor(AptxConstants.DOMAIN_LABEL_COLOR_FOR_PDF);
                }
                graphics2D.drawString(proteinDomain.getName(), f6, f2 + (float)treePanel.getMainPanel().getTreeFontSet().getFontMetricsSmall().getAscent() + this._rendering_height);
            }
            if (this._node_name.indexOf("~") > 1 && proteinDomain.getName().equals(SPECIAL_DOMAIN) && this._node_name.indexOf("~" + n + "-") < 1) {
                this.drawDomainGrey(f6, f2, f7 - f6, this._rendering_height, proteinDomain.getName(), graphics2D, bl);
                continue;
            }
            this.drawDomain(f6, f2, f7 - f6, this._rendering_height, proteinDomain.getName(), graphics2D, bl);
        }
        graphics2D.setStroke(stroke);
    }

    @Override
    public void setParameter(double d) {
        this._e_value_threshold_exp = (int)d;
    }

    public void setRenderingFactorWidth(float f) {
        this._rendering_factor_width = f;
    }

    @Override
    public void setRenderingHeight(float f) {
        this._rendering_height = f;
    }

    @Override
    public StringBuffer toNHX() {
        return this._domain_structure.toNHX();
    }

    @Override
    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        this._domain_structure.toPhyloXML(writer, n, string);
    }
}

