/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Color;
import java.awt.Component;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import org.forester.analysis.TaxonomyDataManager;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.ControlPanel;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.TreePanel;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.BranchColor;
import org.forester.phylogeny.data.NodeDataField;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogeny.iterators.PreorderTreeIterator;
import org.forester.util.ForesterUtil;
import org.forester.util.SequenceAccessionTools;
import org.forester.util.StringInt;
import org.forester.ws.seqdb.UniProtTaxonomy;

public class TreePanelUtil {
    public static final String createUriForSeqWeb(PhylogenyNode phylogenyNode, Configuration configuration, TreePanel treePanel) {
        String string;
        String string2 = null;
        String string3 = SequenceAccessionTools.obtainUniProtAccessorFromDataFields(phylogenyNode);
        if (!ForesterUtil.isEmpty(string3)) {
            try {
                string2 = "https://www.uniprot.org/uniprot/" + URLEncoder.encode(string3, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                AptxUtil.showErrorMessage(treePanel, unsupportedEncodingException.toString());
                unsupportedEncodingException.printStackTrace();
            }
        }
        if (ForesterUtil.isEmpty(string2) && !ForesterUtil.isEmpty(string = SequenceAccessionTools.obtainGenbankAccessorFromDataFields(phylogenyNode))) {
            try {
                string2 = SequenceAccessionTools.isProteinDbQuery(string) ? "https://www.ncbi.nlm.nih.gov/protein/" + URLEncoder.encode(string, "UTF-8") : "https://www.ncbi.nlm.nih.gov/nuccore/" + URLEncoder.encode(string, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                AptxUtil.showErrorMessage(treePanel, unsupportedEncodingException.toString());
                unsupportedEncodingException.printStackTrace();
            }
        }
        if (ForesterUtil.isEmpty(string2) && !ForesterUtil.isEmpty(string = SequenceAccessionTools.obtainRefSeqAccessorFromDataFields(phylogenyNode))) {
            try {
                string2 = SequenceAccessionTools.isProteinDbQuery(string) ? "https://www.ncbi.nlm.nih.gov/protein/" + URLEncoder.encode(string, "UTF-8") : "https://www.ncbi.nlm.nih.gov/nuccore/" + URLEncoder.encode(string, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                AptxUtil.showErrorMessage(treePanel, unsupportedEncodingException.toString());
                unsupportedEncodingException.printStackTrace();
            }
        }
        if (ForesterUtil.isEmpty(string2) && !ForesterUtil.isEmpty(string = SequenceAccessionTools.obtainGiNumberFromDataFields(phylogenyNode))) {
            try {
                string2 = "https://www.ncbi.nlm.nih.gov/protein/gi:" + URLEncoder.encode(string, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                AptxUtil.showErrorMessage(treePanel, unsupportedEncodingException.toString());
                unsupportedEncodingException.printStackTrace();
            }
        }
        return string2;
    }

    public static List<String> createUrisForPdbWeb(PhylogenyNode phylogenyNode, List<Accession> list, Configuration configuration, TreePanel treePanel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!ForesterUtil.isEmpty(list)) {
            for (Accession accession : list) {
                if (ForesterUtil.isEmpty(accession.getValue())) continue;
                arrayList.add("http://www.pdb.org/pdb/explore/explore.do?pdbId=" + accession.getValue());
            }
        }
        return arrayList;
    }

    public static final void showExtDescNodeDataUserSelectedHelper(ControlPanel controlPanel, PhylogenyNode phylogenyNode, List<String> list) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        if (controlPanel.isShowNodeNames() && !ForesterUtil.isEmpty(phylogenyNode.getName())) {
            TreePanelUtil.showExtDescNodeDataUserSelectedHelperHelper(phylogenyNode.getName(), stringBuilder);
        }
        if (controlPanel.isShowSeqNames() && phylogenyNode.getNodeData().isHasSequence() && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getName())) {
            TreePanelUtil.showExtDescNodeDataUserSelectedHelperHelper(phylogenyNode.getNodeData().getSequence().getName(), stringBuilder);
        }
        if (controlPanel.isShowSeqSymbols() && phylogenyNode.getNodeData().isHasSequence() && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getSymbol())) {
            TreePanelUtil.showExtDescNodeDataUserSelectedHelperHelper(phylogenyNode.getNodeData().getSequence().getSymbol(), stringBuilder);
        }
        if (controlPanel.isShowGeneNames() && phylogenyNode.getNodeData().isHasSequence() && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getGeneName())) {
            TreePanelUtil.showExtDescNodeDataUserSelectedHelperHelper(phylogenyNode.getNodeData().getSequence().getGeneName(), stringBuilder);
        }
        if (controlPanel.isShowSequenceAcc() && phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().getAccession() != null && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getAccession().toString())) {
            TreePanelUtil.showExtDescNodeDataUserSelectedHelperHelper(phylogenyNode.getNodeData().getSequence().getAccession().toString(), stringBuilder);
        }
        if (controlPanel.isShowTaxonomyCode() && phylogenyNode.getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode())) {
            TreePanelUtil.showExtDescNodeDataUserSelectedHelperHelper(phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode(), stringBuilder);
        }
        if (controlPanel.isShowTaxonomyScientificNames() && phylogenyNode.getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getScientificName())) {
            TreePanelUtil.showExtDescNodeDataUserSelectedHelperHelper(phylogenyNode.getNodeData().getTaxonomy().getScientificName(), stringBuilder);
        }
        if (controlPanel.isShowTaxonomyCommonNames() && phylogenyNode.getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getCommonName())) {
            TreePanelUtil.showExtDescNodeDataUserSelectedHelperHelper(phylogenyNode.getNodeData().getTaxonomy().getCommonName(), stringBuilder);
        }
        if (!ForesterUtil.isEmpty(string = stringBuilder.toString().trim())) {
            list.add(string);
        }
    }

    public static final void showExtDescNodeDataUserSelectedHelperHelper(String string, StringBuilder stringBuilder) {
        if (stringBuilder.length() > 0) {
            stringBuilder.append("\t");
        }
        stringBuilder.append(string);
    }

    public static final void showInformationMessage(Component component, String string, String string2) {
        JOptionPane.showMessageDialog(component, string2, string, 1);
    }

    static final void collapseSpeciesSpecificSubtrees(Phylogeny phylogeny) {
        boolean bl = false;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNodeIterator.next().setCollapse(false);
        }
        phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal() || phylogenyNode.isCollapse() || phylogenyNode.getNumberOfDescendants() <= 1) continue;
            Set<Taxonomy> set = PhylogenyMethods.obtainDistinctTaxonomies(phylogenyNode);
            if (set != null && set.size() == 1) {
                TreePanelUtil.collapseSubtree(phylogenyNode, true);
                if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                    phylogenyNode.getNodeData().setTaxonomy((Taxonomy)phylogenyNode.getAllExternalDescendants().get(0).getNodeData().getTaxonomy().copy());
                }
                bl = true;
                continue;
            }
            phylogenyNode.setCollapse(false);
        }
        if (bl) {
            phylogeny.setRerootable(false);
        }
    }

    static final void collapseSubtree(PhylogenyNode phylogenyNode, boolean bl) {
        phylogenyNode.setCollapse(bl);
        if (phylogenyNode.isExternal()) {
            return;
        }
        PreorderTreeIterator preorderTreeIterator = new PreorderTreeIterator(phylogenyNode);
        while (preorderTreeIterator.hasNext()) {
            preorderTreeIterator.next().setCollapse(bl);
        }
    }

    static final void uncollapseSubtree(PhylogenyNode phylogenyNode) {
        phylogenyNode.setCollapse(false);
        if (phylogenyNode.isExternal()) {
            return;
        }
        PreorderTreeIterator preorderTreeIterator = new PreorderTreeIterator(phylogenyNode);
        while (preorderTreeIterator.hasNext()) {
            preorderTreeIterator.next().setCollapse(false);
        }
    }

    static void colorizeSubtree(PhylogenyNode phylogenyNode, BranchColor branchColor) {
        phylogenyNode.getBranchData().setBranchColor(branchColor);
        List<PhylogenyNode> list = PhylogenyMethods.getAllDescendants(phylogenyNode);
        for (PhylogenyNode phylogenyNode2 : list) {
            phylogenyNode2.getBranchData().setBranchColor(branchColor);
        }
    }

    static final void colorPhylogenyAccordingToConfidenceValues(Phylogeny phylogeny, TreePanel treePanel) {
        Object object;
        double d = 0.0;
        Object object2 = phylogeny.iteratorPreorder();
        while (object2.hasNext()) {
            double d2;
            object = object2.next();
            ((PhylogenyNode)object).getBranchData().setBranchColor(null);
            if (!((PhylogenyNode)object).getBranchData().isHasConfidences() || !((d2 = PhylogenyMethods.getConfidenceValue((PhylogenyNode)object)) > d)) continue;
            d = d2;
        }
        if (d > 0.0) {
            object2 = treePanel.getTreeColorSet().getBackgroundColor();
            object = treePanel.getTreeColorSet().getBranchColor();
            PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
            while (phylogenyNodeIterator.hasNext()) {
                PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
                if (!phylogenyNode.getBranchData().isHasConfidences()) continue;
                double d3 = PhylogenyMethods.getConfidenceValue(phylogenyNode);
                BranchColor branchColor = new BranchColor(ForesterUtil.calcColor(d3, 0.0, d, (Color)object2, (Color)object));
                TreePanelUtil.colorizeSubtree(phylogenyNode, branchColor);
            }
        }
    }

    static final void colorPhylogenyAccordingToExternalTaxonomy(Phylogeny phylogeny, TreePanel treePanel) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNodeIterator.next().getBranchData().setBranchColor(null);
        }
        phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            Taxonomy taxonomy;
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.getBranchData().isHasBranchColor() || (taxonomy = PhylogenyMethods.getExternalDescendantsTaxonomy(phylogenyNode)) == null) continue;
            phylogenyNode.getBranchData().setBranchColor(new BranchColor(treePanel.calculateTaxonomyBasedColor(taxonomy)));
            List<PhylogenyNode> list = PhylogenyMethods.getAllDescendants(phylogenyNode);
            for (PhylogenyNode phylogenyNode2 : list) {
                phylogenyNode2.getBranchData().setBranchColor(new BranchColor(treePanel.calculateTaxonomyBasedColor(taxonomy)));
            }
        }
    }

    static final int colorPhylogenyAccordingToRanks(Phylogeny phylogeny, String string, TreePanel treePanel) {
        PhylogenyNode phylogenyNode;
        HashMap<String, Color> hashMap = new HashMap<String, Color>();
        int n = 0;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getScientificName()) && ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getCommonName()) && ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode()) || ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getRank()) || !phylogenyNode.getNodeData().getTaxonomy().getRank().equalsIgnoreCase(string)) continue;
            BranchColor branchColor = new BranchColor(treePanel.calculateTaxonomyBasedColor(phylogenyNode.getNodeData().getTaxonomy()));
            TreePanelUtil.colorizeSubtree(phylogenyNode, branchColor);
            ++n;
            if (ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getScientificName())) continue;
            hashMap.put(phylogenyNode.getNodeData().getTaxonomy().getScientificName(), branchColor.getValue());
        }
        phylogenyNodeIterator = phylogeny.iteratorPostorder();
        block3: while (phylogenyNodeIterator.hasNext()) {
            phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.getBranchData().getBranchColor() != null || !phylogenyNode.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getLineage())) continue;
            boolean bl = false;
            if (!hashMap.isEmpty()) {
                for (String string2 : phylogenyNode.getNodeData().getTaxonomy().getLineage()) {
                    if (!hashMap.containsKey(string2)) continue;
                    TreePanelUtil.colorizeSubtree(phylogenyNode, new BranchColor((Color)hashMap.get(string2)));
                    ++n;
                    bl = true;
                    break;
                }
            }
            if (bl) continue;
            Map<String, String> map = MainPanel.getLineageToRankMap();
            for (String string3 : phylogenyNode.getNodeData().getTaxonomy().getLineage()) {
                Object object;
                Taxonomy taxonomy = new Taxonomy();
                taxonomy.setScientificName(string3);
                if (map.containsKey(string3) && !ForesterUtil.isEmpty((String)map.get(string3)) && ((String)map.get(string3)).equalsIgnoreCase(string)) {
                    object = new BranchColor(treePanel.calculateTaxonomyBasedColor(taxonomy));
                    TreePanelUtil.colorizeSubtree(phylogenyNode, (BranchColor)object);
                    ++n;
                    hashMap.put(string3, ((BranchColor)object).getValue());
                    continue block3;
                }
                object = null;
                try {
                    object = TaxonomyDataManager.obtainUniProtTaxonomy(taxonomy, null, null);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (object == null || ForesterUtil.isEmpty(((UniProtTaxonomy)object).getRank())) continue;
                map.put(string3, ((UniProtTaxonomy)object).getRank());
                System.out.println(string3 + "->" + ((UniProtTaxonomy)object).getRank());
                if (!((UniProtTaxonomy)object).getRank().equalsIgnoreCase(string)) continue;
                BranchColor branchColor = new BranchColor(treePanel.calculateTaxonomyBasedColor(taxonomy));
                TreePanelUtil.colorizeSubtree(phylogenyNode, branchColor);
                ++n;
                hashMap.put(string3, branchColor.getValue());
                continue block3;
            }
        }
        return n;
    }

    static final String createAnnotationString(SortedSet<Annotation> sortedSet, boolean bl) {
        TreeMap treeMap = new TreeMap();
        for (Annotation object : sortedSet) {
            String string;
            String string2 = string = ForesterUtil.isEmpty(object.getRefSource()) ? "?" : object.getRefSource();
            if (!treeMap.containsKey(string)) {
                treeMap.put(string, new ArrayList());
            }
            ((List)treeMap.get(string)).add(object);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : treeMap.entrySet()) {
            String string = (String)entry.getKey();
            List list = (List)entry.getValue();
            if (treeMap.size() > 1) {
                stringBuilder.append("[");
            }
            if (bl && !string.equals("?")) {
                stringBuilder.append(string);
                stringBuilder.append(": ");
            }
            for (int i = 0; i < list.size(); ++i) {
                Annotation annotation = (Annotation)list.get(i);
                if (!ForesterUtil.isEmpty(annotation.getRefValue())) {
                    stringBuilder.append(annotation.getRefValue());
                    stringBuilder.append(" ");
                }
                if (!ForesterUtil.isEmpty(annotation.getDesc())) {
                    stringBuilder.append(annotation.getDesc());
                }
                if (stringBuilder.charAt(stringBuilder.length() - 1) == ' ') {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                }
                if (i >= list.size() - 1) continue;
                stringBuilder.append(", ");
            }
            if (treeMap.size() <= 1) continue;
            stringBuilder.append("] ");
        }
        return stringBuilder.toString();
    }

    static final String getPartAfterColon(String string) {
        int n = string.indexOf(58);
        if (n < 1 || n == string.length() - 1) {
            return string;
        }
        return string.substring(n + 1, string.length());
    }

    static final boolean isHasAssignedEvent(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.getNodeData().isHasEvent()) {
            return false;
        }
        return !phylogenyNode.getNodeData().getEvent().isUnassigned();
    }

    static final boolean isSequenceEmpty(Sequence sequence) {
        return sequence.getAccession() == null && ForesterUtil.isEmpty(sequence.getName()) && ForesterUtil.isEmpty(sequence.getGeneName()) && ForesterUtil.isEmpty(sequence.getSymbol());
    }

    static final boolean isTaxonomyEmpty(Taxonomy taxonomy) {
        return taxonomy.getIdentifier() == null && ForesterUtil.isEmpty(taxonomy.getTaxonomyCode()) && ForesterUtil.isEmpty(taxonomy.getCommonName()) && ForesterUtil.isEmpty(taxonomy.getScientificName()) && taxonomy.getSynonyms().isEmpty();
    }

    static final int nodeDataIntoStringBuffer(List<String> list, Options options, StringBuilder stringBuilder) {
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        int n = 0;
        if (options.getExtDescNodeDataToReturn() != NodeDataField.SEQUENCE_MOL_SEQ_FASTA && options.getExtDescNodeDataToReturn() != NodeDataField.GO_TERM_IDS) {
            for (String object : list) {
                if (ForesterUtil.isEmpty(object)) continue;
                if (treeMap.containsKey(object)) {
                    treeMap.put(object, (Integer)treeMap.get(object) + 1);
                    continue;
                }
                treeMap.put(object, 1);
            }
            if (options.getExtDescNodeDataToReturn() == NodeDataField.DOMAINS_ALL || options.getExtDescNodeDataToReturn() == NodeDataField.DOMAINS_COLLAPSED_PER_PROTEIN || options.getExtDescNodeDataToReturn() == NodeDataField.SEQ_ANNOTATIONS) {
                Iterator iterator = new ArrayList();
                for (Map.Entry entry : treeMap.entrySet()) {
                    ((ArrayList)((Object)iterator)).add((StringInt)new StringInt((String)entry.getKey(), (Integer)entry.getValue()));
                }
                Collections.sort(iterator, new StringInt.DescendingIntComparator());
                Iterator iterator2 = ((ArrayList)((Object)iterator)).iterator();
                while (iterator2.hasNext()) {
                    StringInt stringInt = (StringInt)iterator2.next();
                    stringBuilder.append(stringInt.getString());
                    stringBuilder.append("\t");
                    stringBuilder.append(stringInt.getInt());
                    stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
                }
            } else {
                for (Map.Entry entry : treeMap.entrySet()) {
                    String string = (String)entry.getKey();
                    Object v = entry.getValue();
                    stringBuilder.append(string);
                    stringBuilder.append("\t");
                    stringBuilder.append(v);
                    stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
                }
            }
            n = treeMap.size();
        } else {
            for (String string : list) {
                if (ForesterUtil.isEmpty(string)) continue;
                stringBuilder.append(string);
                stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
            }
            n = list.size();
        }
        return n;
    }

    static final String pdbAccToString(List<Accession> list, int n) {
        if (ForesterUtil.isEmpty(list.get(n).getComment())) {
            return list.get(n).getValue();
        }
        return list.get(n).getValue() + " (" + list.get(n).getComment().toLowerCase() + ")";
    }

    static final Phylogeny subTree(PhylogenyNode phylogenyNode, Phylogeny phylogeny) {
        Phylogeny phylogeny2 = new Phylogeny();
        phylogeny2.setRooted(true);
        phylogeny2.setName(phylogeny.getName());
        phylogeny2.setDescription(phylogeny.getDescription());
        phylogeny2.setType(phylogeny.getType());
        phylogeny2.setDistanceUnit(phylogeny.getDistanceUnit());
        phylogeny2.setConfidence(phylogeny.getConfidence());
        phylogeny2.setIdentifier(phylogeny.getIdentifier());
        phylogeny2.setRoot(phylogenyNode.copyNodeDataShallow());
        int n = 0;
        for (PhylogenyNode phylogenyNode2 : phylogenyNode.getDescendants()) {
            phylogeny2.getRoot().setChildNode(n++, phylogenyNode2);
        }
        return phylogeny2;
    }
}

