/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.forester.go.PfamToGoMapping;
import org.forester.go.PfamToGoParser;
import org.forester.go.etc.MetaOntologizer;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class meta_ontologizer {
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String P_OPTION = "p";
    private static final String PRG_NAME = "meta_ontologizer";
    private static final String PRG_VERSION = "1.10";
    private static final String PRG_DATE = "2009.04.29";
    private static final String E_MAIL = "czmasek@burnham.org";
    private static final String WWW = "www.phylosoft.org/forester/";
    private static final String RESULT_FILE_PREFIX = "table";

    public static void main(String[] stringArray) {
        String string;
        String string2;
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE, E_MAIL, WWW);
        CommandLineArguments commandLineArguments = null;
        try {
            commandLineArguments = new CommandLineArguments(stringArray);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
        }
        if (commandLineArguments.isOptionSet(HELP_OPTION_1) || commandLineArguments.isOptionSet(HELP_OPTION_2) || stringArray.length == 0) {
            meta_ontologizer.printHelp();
            System.exit(0);
        }
        if (stringArray.length < 4) {
            System.out.println();
            System.out.println("[meta_ontologizer] incorrect number of arguments");
            System.out.println();
            meta_ontologizer.printHelp();
            System.exit(-1);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(P_OPTION);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(P_OPTION);
        if (commandLineArguments.getNumberOfNames() != 5 && commandLineArguments.getNumberOfNames() != 6) {
            System.out.println();
            System.out.println("[meta_ontologizer] incorrect number of arguments");
            System.out.println();
            meta_ontologizer.printHelp();
            System.exit(-1);
        }
        if ((string2 = commandLineArguments.validateMandatoryOptionsAsString(arrayList2)).length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "missing option(s): " + string2);
        }
        if ((string = commandLineArguments.validateAllowedOptionsAsString(arrayList)).length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + string);
        }
        File file = commandLineArguments.getFile(0);
        File file2 = commandLineArguments.getFile(1);
        File file3 = commandLineArguments.getFile(2);
        File file4 = null;
        String string3 = null;
        String string4 = null;
        if (commandLineArguments.getNumberOfNames() == 6) {
            file4 = commandLineArguments.getFile(3);
            string3 = commandLineArguments.getName(4);
            string4 = commandLineArguments.getName(5);
        } else {
            string3 = commandLineArguments.getName(3);
            string4 = commandLineArguments.getName(4);
        }
        double d = -1.0;
        try {
            d = commandLineArguments.getOptionValueAsDouble(P_OPTION);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
        }
        try {
            PfamToGoParser pfamToGoParser = new PfamToGoParser(file2);
            List<PfamToGoMapping> list = pfamToGoParser.parse();
            ForesterUtil.programMessage(PRG_NAME, "parsed " + list.size() + " Pfam to GO mappings");
            MetaOntologizer.reformat(file3, RESULT_FILE_PREFIX, file4, string3, file, d, string4, list);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
            iOException.printStackTrace();
        }
        ForesterUtil.programMessage(PRG_NAME, "OK");
        System.out.println();
    }

    private static void printHelp() {
        System.out.println("Usage:");
        System.out.println();
        System.out.println("meta_ontologizer -p=<adj P value limit> <obo file> <pfam to go file> <ontologizer outdir> [domain gain loss file] <base for meta ontologizer outfile> <comment>");
        System.out.println();
    }
}

