/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.swing;

import com.approximatrix.charting.DefaultChart;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.swing.AbstractChartPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class ChartPanel
extends AbstractChartPanel {
    private Rectangle currentRect = null;
    private Rectangle grRect = null;

    private ChartPanel() {
    }

    public ChartPanel(ChartDataModel model, String title) {
        this();
        this.chart = new DefaultChart(model, title);
    }

    public ChartPanel(ChartDataModel model, String title, int coord) {
        this();
        this.chart = new DefaultChart(model, title, coord);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.currentRect != null) {
            graphics.setXORMode(Color.white);
            graphics.drawRect(this.grRect.x, this.grRect.y, this.grRect.width - 1, this.grRect.height - 1);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.updateSize(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.currentRect = new Rectangle(e.getX(), e.getY(), 0, 0);
        this.updateSize(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.updateSize(e);
        this.currentRect = null;
        this.repaint();
    }

    private void updateSize(MouseEvent e) {
        int width = e.getX() - this.currentRect.x;
        int height = e.getY() - this.currentRect.y;
        this.currentRect.setSize(width, height);
        if (this.currentRect.width < 0 || this.currentRect.height < 0 || this.grRect == null) {
            this.grRect = new Rectangle(Math.min(this.currentRect.x, this.currentRect.x + width), Math.min(this.currentRect.y, this.currentRect.y + height), Math.abs(width), Math.abs(height));
        } else {
            this.grRect.setSize(width, height);
        }
        this.repaint();
    }
}

