/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.FCS;

import java.awt.Point;

public class FCS_marker {
    private String name = "";
    private int low = Integer.MIN_VALUE;
    private int high = Integer.MAX_VALUE;
    private float y = 0.0f;
    private boolean selected = false;

    public FCS_marker(String paramName) {
        this.name = paramName;
    }

    public void setLowerLimit(int paramLow) {
        this.setRange(paramLow, this.high);
    }

    public void setUpperLimit(int paramHigh) {
        this.setRange(this.low, paramHigh);
    }

    private synchronized void setRange(int limit1, int limit2) {
        if (limit1 <= limit2) {
            this.low = limit1;
            this.high = limit2;
        } else {
            this.low = limit2;
            this.high = limit1;
        }
    }

    public void setDisplayHeight(float height) {
        this.y = height;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean newSelec) {
        this.selected = newSelec;
    }

    public int getLowerLimit() {
        return this.low;
    }

    public int getUpperLimit() {
        return this.high;
    }

    public float getDisplayHeight() {
        return this.y;
    }

    public boolean contains(double channel) {
        return channel >= (double)this.low && channel <= (double)this.high;
    }

    public void setName(String paramName) {
        this.name = paramName;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNearFrame(Point toCheck, int width, int height, int displayHeight) {
        int x_1 = this.low - width;
        int x_2 = this.high + width;
        int y_1 = (int)(this.y * (float)displayHeight) - height;
        int y_2 = (int)(this.y * (float)displayHeight) + height;
        int px = toCheck.x;
        int py = toCheck.y;
        return px > x_1 && px < x_2 && py > y_1 && py < y_2;
    }

    public FCS_marker duplicate() {
        FCS_marker toReturn = new FCS_marker(this.name);
        toReturn.low = this.low;
        toReturn.high = this.high;
        toReturn.selected = this.selected;
        toReturn.y = this.y;
        return toReturn;
    }
}

