/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.GUI;

import FCSalyzer.FCS.FCS_data;
import FCSalyzer.GUI.FACS_document;
import FCSalyzer.GUI.applicationAction;
import FCSalyzer.GUI.attachParameterDialog;
import FCSalyzer.GUI.deriveParamDialog;
import FCSalyzer.GUI.formatDatafilesDialog;
import FCSalyzer.GUI.gradientDialog;
import FCSalyzer.GUI.viewRawDataDialog;
import FCSalyzer.Transform.Compensation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import staticStuff.CustomFileFilter;
import staticStuff.Fileservice;
import staticStuff.staticImages;

public class mainFrame {
    public static final String AppVersion = "0.9.22-alpha";
    public final String nameSuffix = " (FCSalyzer 0.9.22-alpha)";
    private final JFrame theWindow = new JFrame("FCSalyzer 0.9.22-alpha");
    private final JPanel theDesktop = new JPanel(new BorderLayout());
    private FACS_document theDocument;
    private static final List<FACS_document> openDocuments = mainFrame.getApplicationDocumentList();
    private PageFormat currentPage;
    public static final int dotPlotOption = 0;
    public static final int textAreaOption = 1;
    public static final int selectionOption = 2;
    public static final int quadrantOption = 3;
    public static final int regionOption = 4;
    public static final int histogramOption = 5;
    public static final int markerOption = 6;
    public static final int densityPlotOption = 7;
    public static final int openDocument = 10;
    public static final int newDocument = 11;
    public static final int saveDocument = 12;
    public static final int printDocument = 13;
    public static final int formatPage = 14;
    public static final int setDataFile = 15;
    public static final int nextDataFile = 16;
    public static final int previousDataFile = 17;
    public static final int duplicateObjects = 20;
    public static final int annotatePlots = 21;
    public static final int statisticPlots = 22;
    public static final int editStatistics = 23;
    public static final int editMarkers = 24;
    public static final int editRegionsAndGates = 25;
    public static final int changeFontSize = 26;
    public static final int copy = 27;
    public static final int paste = 28;
    public static final int changeGating = 29;
    public static final int formatDocument = 30;
    public static final int changePercentage = 31;
    public static final int saveDocumentAs = 32;
    public static final int about = 33;
    public static final int format = 34;
    public static final int moveLeft = 35;
    public static final int moveRight = 36;
    public static final int moveUp = 37;
    public static final int moveDown = 38;
    public static final int alignLeft = 39;
    public static final int alignRight = 40;
    public static final int alignTop = 41;
    public static final int alignBottom = 42;
    public static final int transCompDialog = 44;
    public static final int viewRawData = 45;
    public static final int exportDocument = 46;
    public static final int exportPlots = 47;
    public static final int deriveParameters = 49;
    public static final int gradientDialog = 50;
    public static final int attachParameter = 51;
    public static final int stepSize = 52;
    public static final int delete = 99;
    public static final int[] step = new int[]{1, 2, 3, 4, 5, 10, 20, 100, 400, 1000};
    public static final String[] stepStrings = new String[]{"100%", "50%", "33.3%", "25%", "20%", "10%", "5%", "1%", "0.25%", "0.1%"};
    public static final int noPercentage = -1;
    public static final String[] fontSizeStrings = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "30", "32", "34", "36", "38", "40", "42", "44", "46", "48", "50", "55", "60", "65", "70", "80", "90", "100", "120", "140", "160", "180", "200", "240", "280", "320"};
    public static final int noFontSize = -1;
    public static final int noGate = -1;
    private Action saveAction = null;
    private Action saveAsAction = null;
    private Action printAction = null;
    private Action exportAction = null;
    private JButton selectionMenu;
    private JButton quadrantMenu;
    private JButton markerMenu;
    private JButton regionMenu;
    private JButton dotPlotMenu;
    private JButton densityPlotMenu;
    private JButton histogramMenu;
    private JButton textAreaMenu;
    private JComboBox fontSizeMenu;
    private JComboBox percentagesMenu;
    private JComboBox gatingMenu;
    private int objectType = 2;
    private boolean performActions = true;
    public static final CustomFileFilter FCXfilter = new CustomFileFilter("", ".FCX", "FCX (FCSalyzer document XML)");
    public FileFilter standardFilter;

    public mainFrame() {
        this.createGUI();
    }

    private void createGUI() {
        this.currentPage = PrinterJob.getPrinterJob().defaultPage();
        Paper currPaper = this.currentPage.getPaper();
        double width = currPaper.getWidth();
        double height = currPaper.getHeight();
        currPaper.setImageableArea(0.0, 0.0, width, height);
        this.currentPage.setPaper(currPaper);
        this.theWindow.setIconImages(staticImages.getInstance().iconList);
        this.theWindow.setSize(800, 600);
        this.theWindow.setLocationByPlatform(true);
        this.theWindow.setDefaultCloseOperation(0);
        this.theWindow.addWindowListener(new mainFrameListener());
        this.theWindow.setLayout(new BorderLayout());
        this.theDesktop.setBackground(Color.LIGHT_GRAY);
        this.theWindow.add((Component)this.theDesktop, "Center");
        JMenuBar theBar = new JMenuBar();
        this.theWindow.add((Component)theBar, "North");
        JMenu document = new JMenu("Document");
        document.setMnemonic(68);
        theBar.add(document);
        JMenuItem fileNew = new JMenuItem();
        fileNew.setAction(new applicationAction(this, "New Document", 78, KeyStroke.getKeyStroke(78, 2), "New Document", 11));
        document.add(fileNew);
        JMenuItem fileOpen = new JMenuItem();
        fileOpen.setAction(new applicationAction(this, "Open Document", 79, KeyStroke.getKeyStroke(79, 2), "Open Document", 10));
        document.add(fileOpen);
        JMenuItem fileSave = new JMenuItem();
        this.saveAction = new applicationAction(this, "Save Document", 83, KeyStroke.getKeyStroke(83, 2), "Save Document", 12);
        fileSave.setAction(this.saveAction);
        document.add(fileSave);
        JMenuItem fileSaveAs = new JMenuItem();
        this.saveAsAction = new applicationAction(this, "Save Document As ...", 65, null, "Save Document As ...", 32);
        fileSaveAs.setAction(this.saveAsAction);
        document.add(fileSaveAs);
        JMenuItem fileExportStats = new JMenuItem();
        document.add(new JSeparator());
        JMenuItem pageFormat = new JMenuItem();
        applicationAction formatPageAction = new applicationAction(this, "Set Pageformat", 70, null, "Set Pageformat", 14);
        pageFormat.setAction(formatPageAction);
        document.add(pageFormat);
        JMenuItem documentFormat = new JMenuItem();
        applicationAction documentFormatAction = new applicationAction(this, "Set Documentsize", 68, null, "Set Documentformat", 30);
        documentFormat.setAction(documentFormatAction);
        document.add(documentFormat);
        JMenuItem filePrint = new JMenuItem();
        this.printAction = new applicationAction(this, "Print Document", 80, KeyStroke.getKeyStroke(80, 2), "Print Document", 13);
        filePrint.setAction(this.printAction);
        document.add(filePrint);
        JMenuItem fileExport = new JMenuItem();
        this.exportAction = new applicationAction(this, "Export Document ...", 88, KeyStroke.getKeyStroke(88, 2), "Export Document ...", 46);
        fileExport.setAction(this.exportAction);
        document.add(fileExport);
        JMenu datafiles = new JMenu("Data Files");
        datafiles.setMnemonic(70);
        theBar.add(datafiles);
        JMenuItem openViewEventDialog = new JMenuItem();
        applicationAction openViewEventDialogAction = new applicationAction(this, "View File Data", 86, null, "View data of datafile", 45);
        openViewEventDialog.setAction(openViewEventDialogAction);
        datafiles.add(openViewEventDialog);
        JMenuItem openDataFileDialog = new JMenuItem();
        applicationAction openDataFileDialogAction = new applicationAction(this, "Format Datafiles", 70, null, "Datafile Properties", 44);
        openDataFileDialog.setAction(openDataFileDialogAction);
        datafiles.add(openDataFileDialog);
        JMenuItem openDeriveParametersDialog = new JMenuItem();
        applicationAction openDeriveParametersAction = new applicationAction(this, "Derive Parameters", 68, null, "DeriveParameters", 49);
        openDeriveParametersDialog.setAction(openDeriveParametersAction);
        datafiles.add(openDeriveParametersDialog);
        JMenuItem openAttachParametersDialog = new JMenuItem();
        applicationAction openAttachParametersAction = new applicationAction(this, "Attach Parameters", 65, null, "AttachParameters", 51);
        openAttachParametersDialog.setAction(openAttachParametersAction);
        datafiles.add(openAttachParametersDialog);
        JMenuItem editRegions = new JMenuItem("Edit Regions / Gates");
        editRegions.setAction(new applicationAction(this, "Edit Regions / Gates", 82, KeyStroke.getKeyStroke(82, 2), "Edit Regions / Gates", 25));
        datafiles.add(editRegions);
        JMenu edit = new JMenu("Edit");
        edit.setMnemonic(69);
        theBar.add(edit);
        JMenuItem copyMenu = new JMenuItem();
        copyMenu.setAction(new applicationAction(this, "Copy", 67, KeyStroke.getKeyStroke(67, 2), "Copy", 27));
        edit.add(copyMenu);
        JMenuItem pasteMenu = new JMenuItem();
        pasteMenu.setAction(new applicationAction(this, "Paste", 80, KeyStroke.getKeyStroke(86, 2), "Paste", 28));
        edit.add(pasteMenu);
        JMenuItem duplicMenu = new JMenuItem();
        duplicMenu.setAction(new applicationAction(this, "Duplicate", 68, KeyStroke.getKeyStroke(68, 2), "Duplicate", 20));
        edit.add(duplicMenu);
        JMenuItem deleteMenu = new JMenuItem();
        deleteMenu.setAction(new applicationAction(this, "Delete", 69, KeyStroke.getKeyStroke(127, 0), "Delete", 99));
        edit.add(deleteMenu);
        JMenu plot = new JMenu("Plot");
        plot.setMnemonic(80);
        theBar.add(plot);
        JMenuItem formatPlot = new JMenuItem("Format Plot/Overlay");
        formatPlot.setAction(new applicationAction(this, "Format Plot/Overlay", 70, KeyStroke.getKeyStroke(70, 2), "Format Plot/Overlay", 34));
        plot.add(formatPlot);
        JMenuItem exportPlot = new JMenuItem("Export Plot/Overlay ...");
        exportPlot.setAction(new applicationAction(this, "Export Plot/Overlay ...", 88, null, "Export Plot/Overlay ...", 47));
        plot.add(exportPlot);
        plot.add(new JSeparator());
        JMenuItem setDatafile = new JMenuItem("Set Datafile");
        setDatafile.setAction(new applicationAction(this, "Set Datafile", 69, KeyStroke.getKeyStroke(69, 2), "Set Datafile", 15));
        plot.add(setDatafile);
        JMenuItem nexDatafile = new JMenuItem("Next Datafile");
        nexDatafile.setAction(new applicationAction(this, "Next Datafile", 78, KeyStroke.getKeyStroke(34, 1), "Next Datafile", 16));
        plot.add(nexDatafile);
        JMenuItem prevDatafile = new JMenuItem("Previous Datafile");
        prevDatafile.setAction(new applicationAction(this, "Previous Datafile", 80, KeyStroke.getKeyStroke(33, 1), "Previous Datafile", 17));
        plot.add(prevDatafile);
        JMenuItem stepSizeMenu = new JMenuItem("Step size ...");
        stepSizeMenu.setAction(new applicationAction(this, "Step size ...", 83, null, "Step size ...", 52));
        plot.add(stepSizeMenu);
        plot.add(new JSeparator());
        JMenuItem gradDialog = new JMenuItem("Manage color gradients");
        gradDialog.setAction(new applicationAction(this, "Manage color gradients", 67, null, "Manage color gradients", 50));
        plot.add(gradDialog);
        plot.add(new JSeparator());
        JMenuItem annotate = new JMenuItem("Annotate");
        annotate.setAction(new applicationAction(this, "Annotate", 65, KeyStroke.getKeyStroke(65, 2), "Annotate", 21));
        plot.add(annotate);
        JMenuItem statistics = new JMenuItem("Statistics");
        statistics.setAction(new applicationAction(this, "Statistics", 84, KeyStroke.getKeyStroke(84, 2), "Statistics", 22));
        plot.add(statistics);
        JMenuItem editStats = new JMenuItem("Edit statistics");
        editStats.setAction(new applicationAction(this, "Edit statistics", 68, null, "Edit statistics", 23));
        plot.add(editStats);
        JMenuItem editMarker = new JMenuItem("Edit markers");
        editMarker.setAction(new applicationAction(this, "Edit markers", 77, null, "Edit markers", 24));
        plot.add(editMarker);
        JMenu arrange = new JMenu("Arrangement");
        arrange.setMnemonic(65);
        theBar.add(arrange);
        JMenuItem mL = new JMenuItem("Move left");
        mL.setAction(new applicationAction(this, "Move Left", null, KeyStroke.getKeyStroke(37, 8, true), "Move Left", 35));
        arrange.add(mL);
        JMenuItem mR = new JMenuItem("Move right");
        mR.setAction(new applicationAction(this, "Move Right", null, KeyStroke.getKeyStroke(39, 8, true), "Move Right", 36));
        arrange.add(mR);
        JMenuItem mU = new JMenuItem("Move up");
        mU.setAction(new applicationAction(this, "Move Up", null, KeyStroke.getKeyStroke(38, 8, true), "Move Up", 37));
        arrange.add(mU);
        JMenuItem mD = new JMenuItem("Move down");
        mD.setAction(new applicationAction(this, "Move Down", null, KeyStroke.getKeyStroke(40, 8, true), "Move Down", 38));
        arrange.add(mD);
        arrange.add(new JSeparator());
        JMenuItem aL = new JMenuItem("Align left");
        aL.setAction(new applicationAction(this, "Align Left", null, KeyStroke.getKeyStroke(37, 2), "Align Left", 39));
        arrange.add(aL);
        JMenuItem aR = new JMenuItem("Align right");
        aR.setAction(new applicationAction(this, "Align Right", null, KeyStroke.getKeyStroke(39, 2), "Align Right", 40));
        arrange.add(aR);
        JMenuItem aT = new JMenuItem("Align top");
        aT.setAction(new applicationAction(this, "Align Top", null, KeyStroke.getKeyStroke(38, 2), "Align Top", 41));
        arrange.add(aT);
        JMenuItem aB = new JMenuItem("Align bottom");
        aB.setAction(new applicationAction(this, "Align Bottom", null, KeyStroke.getKeyStroke(40, 2), "Align Bottom", 42));
        arrange.add(aB);
        JMenu help = new JMenu("Help");
        help.setMnemonic(72);
        theBar.add(help);
        JMenuItem aboutMenu = new JMenuItem("About");
        aboutMenu.setMnemonic(65);
        aboutMenu.setAction(new applicationAction(this, "About", 65, null, "About", 33));
        help.add(aboutMenu);
        this.selectionMenu = new JButton();
        this.selectionMenu.setAction(new applicationAction(this, "Selection", null, null, "Selection", 2));
        this.selectionMenu.setIcon(staticImages.getInstance().selection_image);
        this.selectionMenu.setSelected(true);
        this.selectionMenu.setContentAreaFilled(false);
        this.selectionMenu.setBorderPainted(false);
        this.selectionMenu.setFocusPainted(false);
        this.selectionMenu.setMargin(new Insets(1, 1, 1, 1));
        this.selectionMenu.setSelectedIcon(staticImages.getInstance().selected_selection_image);
        this.selectionMenu.setHideActionText(true);
        theBar.add(this.selectionMenu);
        this.quadrantMenu = new JButton();
        this.quadrantMenu.setAction(new applicationAction(this, "Quadrant", null, null, "Quadrant", 3));
        this.quadrantMenu.setIcon(staticImages.getInstance().quadrant_image);
        this.quadrantMenu.setSelected(false);
        this.quadrantMenu.setContentAreaFilled(false);
        this.quadrantMenu.setBorderPainted(false);
        this.quadrantMenu.setFocusPainted(false);
        this.quadrantMenu.setMargin(new Insets(1, 1, 1, 1));
        this.quadrantMenu.setSelectedIcon(staticImages.getInstance().selected_quadrant_image);
        this.quadrantMenu.setHideActionText(true);
        theBar.add(this.quadrantMenu);
        this.markerMenu = new JButton();
        this.markerMenu.setAction(new applicationAction(this, "Marker", null, null, "Marker", 6));
        this.markerMenu.setIcon(staticImages.getInstance().marker_image);
        this.markerMenu.setSelected(false);
        this.markerMenu.setContentAreaFilled(false);
        this.markerMenu.setBorderPainted(false);
        this.markerMenu.setFocusPainted(false);
        this.markerMenu.setMargin(new Insets(1, 1, 1, 1));
        this.markerMenu.setSelectedIcon(staticImages.getInstance().selected_marker_image);
        this.markerMenu.setHideActionText(true);
        theBar.add(this.markerMenu);
        this.regionMenu = new JButton();
        this.regionMenu.setAction(new applicationAction(this, "Region", null, null, "Region", 4));
        this.regionMenu.setIcon(staticImages.getInstance().region_image);
        this.regionMenu.setSelected(false);
        this.regionMenu.setContentAreaFilled(false);
        this.regionMenu.setBorderPainted(false);
        this.regionMenu.setFocusPainted(false);
        this.regionMenu.setMargin(new Insets(1, 1, 1, 1));
        this.regionMenu.setSelectedIcon(staticImages.getInstance().selected_region_image);
        this.regionMenu.setHideActionText(true);
        theBar.add(this.regionMenu);
        this.dotPlotMenu = new JButton();
        this.dotPlotMenu.setAction(new applicationAction(this, "DotPlot", null, null, "Dot Plot", 0));
        this.dotPlotMenu.setIcon(staticImages.getInstance().dotPlot_image);
        this.dotPlotMenu.setSelected(false);
        this.dotPlotMenu.setHideActionText(true);
        this.dotPlotMenu.setContentAreaFilled(false);
        this.dotPlotMenu.setBorderPainted(false);
        this.dotPlotMenu.setFocusPainted(false);
        this.dotPlotMenu.setMargin(new Insets(1, 1, 1, 1));
        this.dotPlotMenu.setSelectedIcon(staticImages.getInstance().selected_dotPlot_image);
        theBar.add(this.dotPlotMenu);
        this.densityPlotMenu = new JButton();
        this.densityPlotMenu.setAction(new applicationAction(this, "DensityPlot", null, null, "Density Plot", 7));
        this.densityPlotMenu.setIcon(staticImages.getInstance().densityPlot_image);
        this.densityPlotMenu.setSelected(false);
        this.densityPlotMenu.setHideActionText(true);
        this.densityPlotMenu.setContentAreaFilled(false);
        this.densityPlotMenu.setBorderPainted(false);
        this.densityPlotMenu.setFocusPainted(false);
        this.densityPlotMenu.setMargin(new Insets(1, 1, 1, 1));
        this.densityPlotMenu.setSelectedIcon(staticImages.getInstance().selected_densityPlot_image);
        theBar.add(this.densityPlotMenu);
        this.histogramMenu = new JButton();
        this.histogramMenu.setAction(new applicationAction(this, "Histogram", null, null, "Histogram", 5));
        this.histogramMenu.setIcon(staticImages.getInstance().histogram_image);
        this.histogramMenu.setSelected(false);
        this.histogramMenu.setHideActionText(true);
        this.histogramMenu.setContentAreaFilled(false);
        this.histogramMenu.setBorderPainted(false);
        this.histogramMenu.setFocusPainted(false);
        this.histogramMenu.setMargin(new Insets(1, 1, 1, 1));
        this.histogramMenu.setSelectedIcon(staticImages.getInstance().selected_histogram_image);
        theBar.add(this.histogramMenu);
        this.textAreaMenu = new JButton();
        this.textAreaMenu.setAction(new applicationAction(this, "TextArea", null, null, "Text Area", 1));
        this.textAreaMenu.setIcon(staticImages.getInstance().textArea_image);
        this.textAreaMenu.setSelected(false);
        this.textAreaMenu.setHideActionText(true);
        this.textAreaMenu.setContentAreaFilled(false);
        this.textAreaMenu.setBorderPainted(false);
        this.textAreaMenu.setFocusPainted(false);
        this.textAreaMenu.setMargin(new Insets(1, 1, 1, 1));
        this.textAreaMenu.setSelectedIcon(staticImages.getInstance().selected_textArea_image);
        theBar.add(this.textAreaMenu);
        this.fontSizeMenu = new JComboBox<String>(fontSizeStrings);
        this.fontSizeMenu.setEditable(false);
        this.fontSizeMenu.setSelectedIndex(12);
        this.fontSizeMenu.addActionListener(new applicationAction(this, "Fontsize", null, null, "Fontsize", 26));
        this.fontSizeMenu.setMaximumSize(new Dimension(60, 25));
        theBar.add(this.fontSizeMenu);
        this.percentagesMenu = new JComboBox<String>(stepStrings);
        this.percentagesMenu.setEditable(false);
        this.percentagesMenu.setSelectedIndex(1);
        this.percentagesMenu.addActionListener(new applicationAction(this, "Percentage shown", null, null, "Percentage shown", 31));
        this.percentagesMenu.setMaximumSize(new Dimension(50, 25));
        theBar.add(this.percentagesMenu);
        this.gatingMenu = new JComboBox();
        this.gatingMenu.setEditable(false);
        this.gatingMenu.addActionListener(new applicationAction(this, "Gating", null, null, "Gating", 29));
        theBar.add(Box.createHorizontalStrut(5));
        this.gatingMenu.setMaximumSize(new Dimension(100, 25));
        theBar.add(this.gatingMenu);
        theBar.add(Box.createHorizontalGlue());
        this.setDocumentFile(null);
        this.theWindow.setVisible(true);
    }

    public void action(int actionCode) {
        if (this.performActions) {
            switch (actionCode) {
                case 11: {
                    new mainFrame().setDocumentFile(null);
                    break;
                }
                case 10: {
                    mainFrame newFrame;
                    File toOpen = Fileservice.getFileForLoad(true);
                    if (toOpen == null) break;
                    if (!toOpen.isFile()) {
                        toOpen = new File(toOpen.getParent(), toOpen.getName() + ".FCX");
                    }
                    if (!toOpen.isFile() || (newFrame = this.theDocument.getDatafiles().isEmpty() && this.theDocument.getComponentCount() == 0 ? this : new mainFrame()).setDocumentFile(toOpen)) break;
                    newFrame.closeFrame();
                    break;
                }
                case 12: {
                    try {
                        this.theDocument.save();
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(this.theWindow, "File could not be saved!", "File Error", 0);
                    }
                    break;
                }
                case 32: {
                    try {
                        this.theDocument.saveAs();
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(this.theWindow, "File could not be saved!", "File Error", 0);
                    }
                    break;
                }
                case 14: {
                    PageFormat tempFormat = this.currentPage;
                    tempFormat = this.theDocument.getPageFormat(0);
                    PageFormat newPage = PrinterJob.getPrinterJob().pageDialog(tempFormat);
                    if (newPage == tempFormat) break;
                    this.currentPage = newPage;
                    this.theDocument.setPage(newPage);
                    break;
                }
                case 13: {
                    PrinterJob job = PrinterJob.getPrinterJob();
                    if (job == null) break;
                    job.setPageable(this.theDocument);
                    job.setJobName(this.theDocument.getName() + " - FCSalyzer");
                    boolean doPrint = job.printDialog();
                    if (!doPrint) break;
                    try {
                        job.print();
                    }
                    catch (PrinterException e) {
                        JOptionPane.showMessageDialog(this.theWindow, "Document could not be printed!", "Print Error", 0);
                    }
                    break;
                }
                case 46: {
                    this.theDocument.exportDocument();
                    break;
                }
                case 45: {
                    new viewRawDataDialog(this).showDialog(this.theDocument.getDatafiles(), this.theDocument.getName());
                    break;
                }
                case 49: {
                    new deriveParamDialog(this).showDialog(this.theDocument);
                    break;
                }
                case 44: {
                    new formatDatafilesDialog(this, this.theDocument.getDatafiles(), this.theDocument.getCompensations(), this.theDocument.getName()).showDialog();
                    break;
                }
                case 2: {
                    this.selectMenuButton(this.selectionMenu);
                    this.objectType = 2;
                    this.setDocumentObjectType();
                    break;
                }
                case 0: {
                    this.selectMenuButton(this.dotPlotMenu);
                    this.objectType = 0;
                    this.setDocumentObjectType();
                    break;
                }
                case 7: {
                    this.selectMenuButton(this.densityPlotMenu);
                    this.objectType = 7;
                    this.setDocumentObjectType();
                    break;
                }
                case 5: {
                    this.selectMenuButton(this.histogramMenu);
                    this.objectType = 5;
                    this.setDocumentObjectType();
                    break;
                }
                case 1: {
                    this.selectMenuButton(this.textAreaMenu);
                    this.objectType = 1;
                    this.setDocumentObjectType();
                    break;
                }
                case 3: {
                    this.selectMenuButton(this.quadrantMenu);
                    this.objectType = 3;
                    this.setDocumentObjectType();
                    break;
                }
                case 6: {
                    this.selectMenuButton(this.markerMenu);
                    this.objectType = 6;
                    this.setDocumentObjectType();
                    break;
                }
                case 4: {
                    this.selectMenuButton(this.regionMenu);
                    this.objectType = 4;
                    this.setDocumentObjectType();
                    break;
                }
                case 20: {
                    this.theDocument.duplicateSelectedObjects();
                    break;
                }
                case 21: {
                    this.theDocument.annotateSelectedPlots();
                    break;
                }
                case 22: {
                    this.theDocument.statisticSelectedPlots();
                    break;
                }
                case 23: {
                    this.theDocument.editSelectedStatistics();
                    break;
                }
                case 24: {
                    this.theDocument.editMarkers();
                    break;
                }
                case 25: {
                    this.theDocument.editRegionsAndGates();
                    break;
                }
                case 99: {
                    this.theDocument.deleteSelectedObjects();
                    break;
                }
                case 15: {
                    this.theDocument.setDataFile();
                    break;
                }
                case 16: {
                    this.theDocument.setNextDataFile();
                    break;
                }
                case 17: {
                    this.theDocument.setPreviousDataFile();
                    break;
                }
                case 27: {
                    this.theDocument.copy();
                    break;
                }
                case 28: {
                    this.theDocument.paste();
                    break;
                }
                case 26: {
                    Object currentItem = this.fontSizeMenu.getSelectedItem();
                    if (currentItem == null) break;
                    try {
                        this.theDocument.changeFontSize(Integer.valueOf(currentItem.toString()));
                    }
                    catch (NumberFormatException n) {}
                    break;
                }
                case 31: {
                    this.theDocument.changeStep(step[this.percentagesMenu.getSelectedIndex()]);
                    break;
                }
                case 30: {
                    this.theDocument.formatDocument(this.theWindow);
                    break;
                }
                case 29: {
                    this.theDocument.changeGate(this.gatingMenu.getSelectedIndex() - 1);
                    break;
                }
                case 33: {
                    JDialog aboutDialog = new JDialog(this.theWindow, "FCSalyzer Version 0.9.22-alpha", true);
                    aboutDialog.setSize(600, 500);
                    aboutDialog.setLocationByPlatform(true);
                    aboutDialog.setLayout(new BorderLayout());
                    JTabbedPane tabHolder = new JTabbedPane();
                    JTextArea theNotice = new JTextArea();
                    theNotice.setEditable(false);
                    theNotice.setOpaque(false);
                    theNotice.setWrapStyleWord(true);
                    theNotice.setLineWrap(true);
                    theNotice.setText("FCSalyzer - a small program for analysing flow cytometry data\nCopyright (C) 2012-2020 Sven Mostb\u00f6ck\nhttp://sourceforge.net/projects/fcsalyzer\n\nThis program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.\n\nThis program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License along with this program. If not, see <http://www.gnu.org/licenses/>.\n");
                    theNotice.setCaretPosition(0);
                    tabHolder.add("About ..", new JScrollPane(theNotice));
                    JTextArea theLicense = new JTextArea();
                    theLicense.setEditable(false);
                    theLicense.setOpaque(false);
                    theLicense.setWrapStyleWord(true);
                    theLicense.setLineWrap(true);
                    theLicense.setText("                  TERMS AND CONDITIONS\n\n 0. Definitions.\n\n \"This License\" refers to version 3 of the GNU General Public License.\n\n \"Copyright\" also means copyright-like laws that apply to other kinds of works, such as semiconductor masks.\n\n \"The Program\" refers to any copyrightable work licensed under this License. Each licensee is addressed as \"you\". \"Licensees\" and \"recipients\" may be individuals or organizations.\n\n To \"modify\" a work means to copy from or adapt all or part of the work in a fashion requiring copyright permission, other than the making of an exact copy. The resulting work is called a \"modified version\" of the earlier work or a work \"based on\" the earlier work.\n\n A \"covered work\" means either the unmodified Program or a work based on the Program.\n\n To \"propagate\" a work means to do anything with it that, without permission, would make you directly or secondarily liable for infringement under applicable copyright law, except executing it on a computer or modifying a private copy. Propagation includes copying, distribution (with or without modification), making available to the public, and in some countries other activities as well.\n\n To \"convey\" a work means any kind of propagation that enables other parties to make or receive copies. Mere interaction with a user through a computer network, with no transfer of a copy, is not conveying.\n\n An interactive user interface displays \"Appropriate Legal Notices\" to the extent that it includes a convenient and prominently visible feature that (1) displays an appropriate copyright notice, and (2) tells the user that there is no warranty for the work (except to the extent that warranties are provided), that licensees may convey the work under this License, and how to view a copy of this License. If the interface presents a list of user commands or options, such as a menu, a prominent item in the list meets this criterion.\n\n 1. Source Code.\n\n The \"source code\" for a work means the preferred form of the work for making modifications to it. \"Object code\" means any non-source form of a work.\n\n A \"Standard Interface\" means an interface that either is an official standard defined by a recognized standards body, or, in the case of interfaces specified for a particular programming language, one that is widely used among developers working in that language.\n\n The \"System Libraries\" of an executable work include anything, other than the work as a whole, that (a) is included in the normal form of packaging a Major Component, but which is not part of that Major Component, and (b) serves only to enable use of the work with that Major Component, or to implement a Standard Interface for which an implementation is available to the public in source code form. A \"Major Component\", in this context, means a major essential component (kernel, window system, and so on) of the specific operating system (if any) on which the executable work runs, or a compiler used to produce the work, or an object code interpreter used to run it.\n\n The \"Corresponding Source\" for a work in object code form means all the source code needed to generate, install, and (for an executable work) run the object code and to modify the work, including scripts to control those activities. However, it does not include the work's System Libraries, or general-purpose tools or generally available free programs which are used unmodified in performing those activities but which are not part of the work. For example, Corresponding Source includes interface definition files associated with source files for the work, and the source code for shared libraries and dynamically linked subprograms that the work is specifically designed to require, such as by intimate data communication or control flow between those subprograms and other parts of the work.\n\n The Corresponding Source need not include anything that users can regenerate automatically from other parts of the Corresponding Source.\n\n The Corresponding Source for a work in source code form is that same work.\n\n 2. Basic Permissions.\n\n All rights granted under this License are granted for the term of copyright on the Program, and are irrevocable provided the stated conditions are met. This License explicitly affirms your unlimited permission to run the unmodified Program. The output from running a covered work is covered by this License only if the output, given its content, constitutes a covered work. This License acknowledges your rights of fair use or other equivalent, as provided by copyright law.\n\n You may make, run and propagate covered works that you do not convey, without conditions so long as your license otherwise remains in force. You may convey covered works to others for the sole purpose of having them make modifications exclusively for you, or provide you with facilities for running those works, provided that you comply with the terms of this License in conveying all material for which you do not control copyright. Those thus making or running the covered works for you must do so exclusively on your behalf, under your direction and control, on terms that prohibit them from making any copies of your copyrighted material outside their relationship with you.\n\n Conveying under any other circumstances is permitted solely under the conditions stated below. Sublicensing is not allowed; section 10 makes it unnecessary.\n\n 3. Protecting Users' Legal Rights From Anti-Circumvention Law.\n\n No covered work shall be deemed part of an effective technological measure under any applicable law fulfilling obligations under article 11 of the WIPO copyright treaty adopted on 20 December 1996, or similar laws prohibiting or restricting circumvention of such measures.\n\n When you convey a covered work, you waive any legal power to forbid circumvention of technological measures to the extent such circumvention is effected by exercising rights under this License with respect to the covered work, and you disclaim any intention to limit operation or modification of the work as a means of enforcing, against the work's users, your or third parties' legal rights to forbid circumvention of technological measures.\n\n 4. Conveying Verbatim Copies.\n\n You may convey verbatim copies of the Program's source code as you receive it, in any medium, provided that you conspicuously and appropriately publish on each copy an appropriate copyright notice; keep intact all notices stating that this License and any non-permissive terms added in accord with section 7 apply to the code; keep intact all notices of the absence of any warranty; and give all recipients a copy of this License along with the Program.\n\n You may charge any price or no price for each copy that you convey, and you may offer support or warranty protection for a fee.\n\n 5. Conveying Modified Source Versions.\n\n You may convey a work based on the Program, or the modifications to produce it from the Program, in the form of source code under the terms of section 4, provided that you also meet all of these conditions:\n\n a) The work must carry prominent notices stating that you modified  it, and giving a relevant date.\n\n b) The work must carry prominent notices stating that it is  released under this License and any conditions added under section  7. This requirement modifies the requirement in section 4 to  \"keep intact all notices\".\n\n c) You must license the entire work, as a whole, under this  License to anyone who comes into possession of a copy. This  License will therefore apply, along with any applicable section 7  additional terms, to the whole of the work, and all its parts,  regardless of how they are packaged. This License gives no  permission to license the work in any other way, but it does not  invalidate such permission if you have separately received it.\n\n d) If the work has interactive user interfaces, each must display  Appropriate Legal Notices; however, if the Program has interactive  interfaces that do not display Appropriate Legal Notices, your  work need not make them do so.\n\n A compilation of a covered work with other separate and independent works, which are not by their nature extensions of the covered work, and which are not combined with it such as to form a larger program, in or on a volume of a storage or distribution medium, is called an \"aggregate\" if the compilation and its resulting copyright are not used to limit the access or legal rights of the compilation's users beyond what the individual works permit. Inclusion of a covered work in an aggregate does not cause this License to apply to the other parts of the aggregate.\n\n 6. Conveying Non-Source Forms.\n\n You may convey a covered work in object code form under the terms of sections 4 and 5, provided that you also convey the machine-readable Corresponding Source under the terms of this License, in one of these ways:\n\n a) Convey the object code in, or embodied in, a physical product  (including a physical distribution medium), accompanied by the  Corresponding Source fixed on a durable physical medium  customarily used for software interchange.\n\n b) Convey the object code in, or embodied in, a physical product  (including a physical distribution medium), accompanied by a  written offer, valid for at least three years and valid for as  long as you offer spare parts or customer support for that product  model, to give anyone who possesses the object code either (1) a  copy of the Corresponding Source for all the software in the  product that is covered by this License, on a durable physical  medium customarily used for software interchange, for a price no  more than your reasonable cost of physically performing this  conveying of source, or (2) access to copy the  Corresponding Source from a network server at no charge.\n\n c) Convey individual copies of the object code with a copy of the  written offer to provide the Corresponding Source. This  alternative is allowed only occasionally and noncommercially, and  only if you received the object code with such an offer, in accord  with subsection 6b.\n\n d) Convey the object code by offering access from a designated  place (gratis or for a charge), and offer equivalent access to the  Corresponding Source in the same way through the same place at no  further charge. You need not require recipients to copy the  Corresponding Source along with the object code. If the place to  copy the object code is a network server, the Corresponding Source  may be on a different server (operated by you or a third party)  that supports equivalent copying facilities, provided you maintain  clear directions next to the object code saying where to find the  Corresponding Source. Regardless of what server hosts the  Corresponding Source, you remain obligated to ensure that it is  available for as long as needed to satisfy these requirements.\n\n e) Convey the object code using peer-to-peer transmission, provided  you inform other peers where the object code and Corresponding  Source of the work are being offered to the general public at no  charge under subsection 6d.\n\n A separable portion of the object code, whose source code is excluded from the Corresponding Source as a System Library, need not be included in conveying the object code work.\n\n A \"User Product\" is either (1) a \"consumer product\", which means any tangible personal property which is normally used for personal, family, or household purposes, or (2) anything designed or sold for incorporation into a dwelling. In determining whether a product is a consumer product, doubtful cases shall be resolved in favor of coverage. For a particular product received by a particular user, \"normally used\" refers to a typical or common use of that class of product, regardless of the status of the particular user or of the way in which the particular user actually uses, or expects or is expected to use, the product. A product is a consumer product regardless of whether the product has substantial commercial, industrial or non-consumer uses, unless such uses represent the only significant mode of use of the product.\n\n \"Installation Information\" for a User Product means any methods, procedures, authorization keys, or other information required to install and execute modified versions of a covered work in that User Product from a modified version of its Corresponding Source. The information must suffice to ensure that the continued functioning of the modified object code is in no case prevented or interfered with solely because modification has been made.\n\n If you convey an object code work under this section in, or with, or specifically for use in, a User Product, and the conveying occurs as part of a transaction in which the right of possession and use of the User Product is transferred to the recipient in perpetuity or for a fixed term (regardless of how the transaction is characterized), the Corresponding Source conveyed under this section must be accompanied by the Installation Information. But this requirement does not apply if neither you nor any third party retains the ability to install modified object code on the User Product (for example, the work has been installed in ROM).\n\n The requirement to provide Installation Information does not include a requirement to continue to provide support service, warranty, or updates for a work that has been modified or installed by the recipient, or for the User Product in which it has been modified or installed. Access to a network may be denied when the modification itself materially and adversely affects the operation of the network or violates the rules and protocols for communication across the network.\n\n Corresponding Source conveyed, and Installation Information provided, in accord with this section must be in a format that is publicly documented (and with an implementation available to the public in source code form), and must require no special password or key for unpacking, reading or copying.\n\n 7. Additional Terms.\n\n \"Additional permissions\" are terms that supplement the terms of this License by making exceptions from one or more of its conditions. Additional permissions that are applicable to the entire Program shall be treated as though they were included in this License, to the extent that they are valid under applicable law. If additional permissions apply only to part of the Program, that part may be used separately under those permissions, but the entire Program remains governed by this License without regard to the additional permissions.\n\n When you convey a copy of a covered work, you may at your option remove any additional permissions from that copy, or from any part of it. (Additional permissions may be written to require their own removal in certain cases when you modify the work.) You may place additional permissions on material, added by you to a covered work, for which you have or can give appropriate copyright permission.\n\n Notwithstanding any other provision of this License, for material you add to a covered work, you may (if authorized by the copyright holders of that material) supplement the terms of this License with terms:\n\n a) Disclaiming warranty or limiting liability differently from the  terms of sections 15 and 16 of this License; or\n\n b) Requiring preservation of specified reasonable legal notices or  author attributions in that material or in the Appropriate Legal  Notices displayed by works containing it; or\n\n c) Prohibiting misrepresentation of the origin of that material, or  requiring that modified versions of such material be marked in  reasonable ways as different from the original version; or\n\n d) Limiting the use for publicity purposes of names of licensors or  authors of the material; or\n\n e) Declining to grant rights under trademark law for use of some  trade names, trademarks, or service marks; or\n\n f) Requiring indemnification of licensors and authors of that  material by anyone who conveys the material (or modified versions of  it) with contractual assumptions of liability to the recipient, for  any liability that these contractual assumptions directly impose on  those licensors and authors.\n\n All other non-permissive additional terms are considered \"further restrictions\" within the meaning of section 10. If the Program as you received it, or any part of it, contains a notice stating that it is governed by this License along with a term that is a further restriction, you may remove that term. If a license document contains a further restriction but permits relicensing or conveying under this License, you may add to a covered work material governed by the terms of that license document, provided that the further restriction does not survive such relicensing or conveying.\n\n If you add terms to a covered work in accord with this section, you must place, in the relevant source files, a statement of the additional terms that apply to those files, or a notice indicating where to find the applicable terms.\n\n Additional terms, permissive or non-permissive, may be stated in the form of a separately written license, or stated as exceptions; the above requirements apply either way.\n\n 8. Termination.\n\n You may not propagate or modify a covered work except as expressly provided under this License. Any attempt otherwise to propagate or modify it is void, and will automatically terminate your rights under this License (including any patent licenses granted under the third paragraph of section 11).\n\n However, if you cease all violation of this License, then your license from a particular copyright holder is reinstated (a) provisionally, unless and until the copyright holder explicitly and finally terminates your license, and (b) permanently, if the copyright holder fails to notify you of the violation by some reasonable means prior to 60 days after the cessation.\n\n Moreover, your license from a particular copyright holder is reinstated permanently if the copyright holder notifies you of the violation by some reasonable means, this is the first time you have received notice of violation of this License (for any work) from that copyright holder, and you cure the violation prior to 30 days after your receipt of the notice.\n\n Termination of your rights under this section does not terminate the licenses of parties who have received copies or rights from you under this License. If your rights have been terminated and not permanently reinstated, you do not qualify to receive new licenses for the same material under section 10.\n\n 9. Acceptance Not Required for Having Copies.\n\n You are not required to accept this License in order to receive or run a copy of the Program. Ancillary propagation of a covered work occurring solely as a consequence of using peer-to-peer transmission to receive a copy likewise does not require acceptance. However, nothing other than this License grants you permission to propagate or modify any covered work. These actions infringe copyright if you do not accept this License. Therefore, by modifying or propagating a covered work, you indicate your acceptance of this License to do so.\n\n 10. Automatic Licensing of Downstream Recipients.\n\n Each time you convey a covered work, the recipient automatically receives a license from the original licensors, to run, modify and propagate that work, subject to this License. You are not responsible for enforcing compliance by third parties with this License.\n\n An \"entity transaction\" is a transaction transferring control of an organization, or substantially all assets of one, or subdividing an organization, or merging organizations. If propagation of a covered work results from an entity transaction, each party to that transaction who receives a copy of the work also receives whatever licenses to the work the party's predecessor in interest had or could give under the previous paragraph, plus a right to possession of the Corresponding Source of the work from the predecessor in interest, if the predecessor has it or can get it with reasonable efforts.\n\n You may not impose any further restrictions on the exercise of the rights granted or affirmed under this License. For example, you may not impose a license fee, royalty, or other charge for exercise of rights granted under this License, and you may not initiate litigation (including a cross-claim or counterclaim in a lawsuit) alleging that any patent claim is infringed by making, using, selling, offering for sale, or importing the Program or any portion of it.\n\n 11. Patents.\n\n A \"contributor\" is a copyright holder who authorizes use under this License of the Program or a work on which the Program is based. The work thus licensed is called the contributor's \"contributor version\".\n\n A contributor's \"essential patent claims\" are all patent claims owned or controlled by the contributor, whether already acquired or hereafter acquired, that would be infringed by some manner, permitted by this License, of making, using, or selling its contributor version, but do not include claims that would be infringed only as a consequence of further modification of the contributor version. For purposes of this definition, \"control\" includes the right to grant patent sublicenses in a manner consistent with the requirements of this License.\n\n Each contributor grants you a non-exclusive, worldwide, royalty-free patent license under the contributor's essential patent claims, to make, use, sell, offer for sale, import and otherwise run, modify and propagate the contents of its contributor version.\n\n In the following three paragraphs, a \"patent license\" is any express agreement or commitment, however denominated, not to enforce a patent (such as an express permission to practice a patent or covenant not to sue for patent infringement). To \"grant\" such a patent license to a party means to make such an agreement or commitment not to enforce a patent against the party.\n\n If you convey a covered work, knowingly relying on a patent license, and the Corresponding Source of the work is not available for anyone to copy, free of charge and under the terms of this License, through a publicly available network server or other readily accessible means, then you must either (1) cause the Corresponding Source to be so available, or (2) arrange to deprive yourself of the benefit of the patent license for this particular work, or (3) arrange, in a manner consistent with the requirements of this License, to extend the patent license to downstream recipients. \"Knowingly relying\" means you have actual knowledge that, but for the patent license, your conveying the covered work in a country, or your recipient's use of the covered work in a country, would infringe one or more identifiable patents in that country that you have reason to believe are valid.\n\n If, pursuant to or in connection with a single transaction or arrangement, you convey, or propagate by procuring conveyance of, a covered work, and grant a patent license to some of the parties receiving the covered work authorizing them to use, propagate, modify or convey a specific copy of the covered work, then the patent license you grant is automatically extended to all recipients of the covered work and works based on it.\n\n A patent license is \"discriminatory\" if it does not include within the scope of its coverage, prohibits the exercise of, or is conditioned on the non-exercise of one or more of the rights that are specifically granted under this License. You may not convey a covered work if you are a party to an arrangement with a third party that is in the business of distributing software, under which you make payment to the third party based on the extent of your activity of conveying the work, and under which the third party grants, to any of the parties who would receive the covered work from you, a discriminatory patent license (a) in connection with copies of the covered work conveyed by you (or copies made from those copies), or (b) primarily for and in connection with specific products or compilations that contain the covered work, unless you entered into that arrangement, or that patent license was granted, prior to 28 March 2007.\n\n Nothing in this License shall be construed as excluding or limiting any implied license or other defenses to infringement that may otherwise be available to you under applicable patent law.\n\n 12. No Surrender of Others' Freedom.\n\n If conditions are imposed on you (whether by court order, agreement or otherwise) that contradict the conditions of this License, they do not excuse you from the conditions of this License. If you cannot convey a covered work so as to satisfy simultaneously your obligations under this License and any other pertinent obligations, then as a consequence you may not convey it at all. For example, if you agree to terms that obligate you to collect a royalty for further conveying from those to whom you convey the Program, the only way you could satisfy both those terms and this License would be to refrain entirely from conveying the Program. \n 13. Use with the GNU Affero General Public License.\n\n Notwithstanding any other provision of this License, you have permission to link or combine any covered work with a work licensed under version 3 of the GNU Affero General Public License into a single combined work, and to convey the resulting work. The terms of this License will continue to apply to the part which is the covered work, but the special requirements of the GNU Affero General Public License, section 13, concerning interaction through a network will apply to the combination as such.\n\n 14. Revised Versions of this License.\n\n The Free Software Foundation may publish revised and/or new versions of the GNU General Public License from time to time. Such new versions will be similar in spirit to the present version, but may differ in detail to address new problems or concerns.\n\n Each version is given a distinguishing version number. If the Program specifies that a certain numbered version of the GNU General Public License \"or any later version\" applies to it, you have the option of following the terms and conditions either of that numbered version or of any later version published by the Free Software Foundation. If the Program does not specify a version number of the GNU General Public License, you may choose any version ever published by the Free Software Foundation.\n\n If the Program specifies that a proxy can decide which future versions of the GNU General Public License can be used, that proxy's public statement of acceptance of a version permanently authorizes you to choose that version for the Program.\n\n Later license versions may give you additional or different permissions. However, no additional obligations are imposed on any author or copyright holder as a result of your choosing to follow a later version.\n\n 15. Disclaimer of Warranty.\n\n THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM \"AS IS\" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION. \n\n 16. Limitation of Liability.\n\n IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES AND/OR CONVEYS THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.\n\n 17. Interpretation of Sections 15 and 16.\n\n If the disclaimer of warranty and limitation of liability provided above cannot be given local legal effect according to their terms, reviewing courts shall apply local law that most closely approximates an absolute waiver of all civil liability in connection with the Program, unless a warranty or assumption of liability accompanies a copy of the Program in return for a fee.\n\n                  END OF TERMS AND CONDITIONS\n");
                    theLicense.setCaretPosition(0);
                    tabHolder.add("Terms and Conditions", new JScrollPane(theLicense));
                    JTextArea logicleLicense = new JTextArea();
                    logicleLicense.setEditable(false);
                    logicleLicense.setOpaque(false);
                    logicleLicense.setWrapStyleWord(true);
                    logicleLicense.setLineWrap(true);
                    logicleLicense.setText("Logicle Data Scale\n\nProvides an implementation of the Logicle data scale and its inverse. The Logicle data scale is a generalization of the inverse hyperbolic sine function or arcsinh. Like arcsinh it is logarithmic for large data values, linear in the neighborhood of zero, symmetric around zero and changes smoothly between the log and linear regions. It is more general because the width of the linear region can be independently controlled. The scale is parameterized by the choice of a number of decades of data range to cover, the maximum data value on scale and the width of the linear region. It is used in flow cytometry where a large dynamic range of data, most suitable for a logarithmic scale, is present along with other data distributed near zero and including negative values, for which an ordinary logarithmic scale is not suitable.\n\nRelated Documentation\n\nThe Logicle methods was originally described in the publication: \"A new 'Logicle' display method avoids deceptive effects of logarithmic scaling for low signals and compensated data\", David R. Parks, Mario Roederer, Wayne A. Moore, Cytometry Part A, Volume 69A, Issue 6, Pages 541-551, available online as PDF (http://www3.interscience.wiley.com/cgi-bin/fulltext/112587611/PDFSTART) or HTML(http://www3.interscience.wiley.com/cgi-bin/fulltext/112587611/HTMLSTART). \nThe method is included in the Gating-ML proposed standard of the International Society for the Advancement ofCytometry. The specifications for Gating-ML are available at http://flowcyt.sourceforge.net/gating/.\n\nCopyright, License and Patent\n\nCopyright (c) 2009, 2011, The Board of Trustees of The Leland Stanford Junior University. \nAll rights reserved.\n\nRedistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:\n- Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.\n- Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.\n- Neither the name of the Leland Stanford Junior University nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.\n\nTHIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n\nThe Logicle method is patented under United States Patent 6,954,722. However, Stanford University does not enforce the patent for non-profit academic purposes or for commercial use in the field of flow cytometry.\n");
                    logicleLicense.setCaretPosition(0);
                    tabHolder.add("Logicle - Terms and Conditions", new JScrollPane(logicleLicense));
                    aboutDialog.add((Component)tabHolder, "Center");
                    aboutDialog.setVisible(true);
                    break;
                }
                case 34: {
                    this.theDocument.formatPlot();
                    break;
                }
                case 35: {
                    this.theDocument.moveSelectedObjects(-1, 0);
                    break;
                }
                case 36: {
                    this.theDocument.moveSelectedObjects(1, 0);
                    break;
                }
                case 37: {
                    this.theDocument.moveSelectedObjects(0, -1);
                    break;
                }
                case 38: {
                    this.theDocument.moveSelectedObjects(0, 1);
                    break;
                }
                case 39: {
                    this.theDocument.alignSelectedObjects(1);
                    break;
                }
                case 40: {
                    this.theDocument.alignSelectedObjects(2);
                    break;
                }
                case 41: {
                    this.theDocument.alignSelectedObjects(3);
                    break;
                }
                case 42: {
                    this.theDocument.alignSelectedObjects(4);
                    break;
                }
                case 47: {
                    this.theDocument.exportSelectedPlots();
                    break;
                }
                case 50: {
                    gradientDialog gD = new gradientDialog(this.theDocument);
                    gD.showDialog();
                    break;
                }
                case 51: {
                    attachParameterDialog aD = new attachParameterDialog(this.theDocument, this);
                    aD.showDialog();
                    break;
                }
                case 52: {
                    String inp = JOptionPane.showInputDialog("Please enter the new step size", (Object)this.theDocument.getStepSize());
                    try {
                        Integer in = Integer.parseInt(inp);
                        this.theDocument.setStepSize(in);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
            }
        }
    }

    public boolean setDocumentFile(File toOpen) {
        FACS_document newDoc = null;
        if (toOpen == null) {
            newDoc = new FACS_document(this, this.currentPage);
        } else {
            try {
                newDoc = new FACS_document(this, this.currentPage, toOpen);
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(this.theWindow, "File not found!", "File Error", 0);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.theWindow, "File could not be opened!", "File Error", 0);
            }
            catch (IllegalArgumentException ex) {
                JOptionPane.showMessageDialog(this.theWindow, "File could not be opened!\nThis is not a valid FCX file.", "File Error", 0);
            }
            catch (ParserConfigurationException ex) {
                JOptionPane.showMessageDialog(this.theWindow, "File could not be opened!\nThis is not a valid FCX file.", "File Error", 0);
            }
            catch (SAXException ex) {
                JOptionPane.showMessageDialog(this.theWindow, "File could not be opened!\nThis is not a valid FCX file.", "File Error", 0);
            }
            if (newDoc == null) {
                return false;
            }
        }
        if (this.theDocument != null) {
            openDocuments.remove(this.theDocument);
            this.theDesktop.remove(this.theDocument.getFrame());
        }
        openDocuments.add(newDoc);
        newDoc.setObjectType(this.objectType);
        this.theDesktop.add(newDoc.getFrame());
        this.theDocument = newDoc;
        this.theDesktop.validate();
        return true;
    }

    public void setTitle(String name) {
        this.theWindow.setTitle(name + " (FCSalyzer 0.9.22-alpha)");
    }

    private void selectMenuButton(JButton toSelect) {
        this.selectionMenu.setSelected(false);
        this.dotPlotMenu.setSelected(false);
        this.densityPlotMenu.setSelected(false);
        this.histogramMenu.setSelected(false);
        this.textAreaMenu.setSelected(false);
        this.quadrantMenu.setSelected(false);
        this.markerMenu.setSelected(false);
        this.regionMenu.setSelected(false);
        toSelect.setSelected(true);
    }

    public int getObjectType() {
        return this.objectType;
    }

    private void setDocumentObjectType() {
        for (FACS_document current : openDocuments) {
            current.setObjectType(this.objectType);
        }
    }

    public void closeFrame() {
        boolean cancel = false;
        boolean onlyDoc = openDocuments.size() == 1;
        boolean bl = cancel = !this.theDocument.closeDocument();
        if (!cancel) {
            if (onlyDoc) {
                System.exit(0);
            } else {
                this.theWindow.dispose();
            }
        }
    }

    public void removeDocument(FACS_document toRemove) {
        openDocuments.remove(toRemove);
        toRemove.getFrame().setVisible(false);
        this.theDesktop.remove(toRemove.getFrame());
        this.theDesktop.validate();
    }

    public void setGateMenu(String[] gates) {
        this.setPerformActions(false);
        this.gatingMenu.removeAllItems();
        this.gatingMenu.addItem("-");
        for (String string : gates) {
            this.gatingMenu.addItem(string);
        }
        this.setPerformActions(true);
    }

    public void setDisplayedFontGatePercentage(Integer fontSize, Integer gate, Integer percentage) {
        this.setPerformActions(false);
        if (fontSize != null) {
            for (int current = fontSize.intValue(); current > -1; --current) {
                String setFontSize = String.valueOf(current);
                this.fontSizeMenu.setSelectedItem(null);
                this.fontSizeMenu.setSelectedItem(setFontSize);
                if (this.fontSizeMenu.getSelectedIndex() == -1) {
                    continue;
                }
                break;
            }
        } else {
            this.fontSizeMenu.setSelectedItem(null);
        }
        if (gate != null) {
            if (gate >= this.gatingMenu.getItemCount() || gate < 0) {
                gate = -1;
            }
            this.gatingMenu.setSelectedIndex(gate);
        }
        if (percentage != null) {
            if (percentage >= stepStrings.length || percentage < 0) {
                percentage = -1;
            }
            this.percentagesMenu.setSelectedIndex(percentage);
        }
        this.setPerformActions(true);
    }

    public void setPerformActions(boolean newValue) {
        this.performActions = newValue;
    }

    public void transformationChanged(FCS_data changedFile) {
        for (FACS_document currDoc : openDocuments) {
            currDoc.refreshView(changedFile);
        }
    }

    public void compensationChanged(Compensation changedCompensation) {
        for (FACS_document currDoc : openDocuments) {
            currDoc.refreshView(changedCompensation);
        }
    }

    public void labelsChanged(FCS_data changedFile) {
        for (FACS_document currDoc : openDocuments) {
            currDoc.refreshLabels(changedFile);
        }
    }

    public static List<FACS_document> getApplicationDocumentList() {
        if (openDocuments == null) {
            return Collections.synchronizedList(new ArrayList());
        }
        return openDocuments;
    }

    private class mainFrameListener
    extends WindowAdapter {
        private mainFrameListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            mainFrame.this.closeFrame();
        }
    }
}

